/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.tests;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.tests.TestProject;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class BuildConfiguratorTest
extends TestCase {
    IProject javaProject = null;
    IProject ajProject = null;
    static int testNum = 0;
    IFile fileA;
    IFile fileB;
    IFile fileDef;

    protected void setUp() throws Exception {
        super.setUp();
        TestProject tp = new TestProject("Java Project created by BuildConfiguratorTest " + testNum);
        this.javaProject = tp.getProject();
        TestProject tp2 = new TestProject("AJ Project created by BuildConfiguratorTest" + testNum++);
        this.ajProject = tp2.getProject();
        AspectJPreferences.setAJDTPrefConfigDone(true);
        AJDTUtils.addAspectJNature(this.ajProject);
        this.waitForJobsToComplete(this.ajProject);
        this.setupSandboxSourceFolder();
        this.waitForJobsToComplete(this.ajProject);
    }

    private void setupSandboxSourceFolder() throws Exception {
        IFolder pack;
        IFolder src = this.ajProject.getFolder("testSrcPath");
        if (!src.exists()) {
            src.create(true, true, null);
        }
        IJavaProject jp = JavaCore.create((IProject)this.ajProject);
        IClasspathEntry[] cpes = jp.getRawClasspath();
        IClasspathEntry[] newCpes = new IClasspathEntry[cpes.length + 1];
        boolean alreadyThere = false;
        int i = 0;
        while (i < cpes.length) {
            newCpes[i] = cpes[i];
            if (cpes[i].getPath().equals((Object)src.getFullPath())) {
                alreadyThere = true;
            }
            ++i;
        }
        if (!alreadyThere) {
            newCpes[cpes.length] = JavaCore.newSourceEntry((IPath)src.getFullPath());
            jp.setRawClasspath(newCpes, null);
        }
        this.fileDef = src.getFile("InDefaultPack.java");
        if (!this.fileDef.exists()) {
            this.fileDef.create((InputStream)new StringBufferInputStream("public class InDefaultPack{}"), true, null);
        }
        if (!(pack = src.getFolder("package1")).exists()) {
            pack.create(true, true, null);
        }
        this.fileA = pack.getFile("A.java");
        if (!this.fileA.exists()) {
            this.fileA.create((InputStream)new StringBufferInputStream("package package1;\npublic class A{}"), true, null);
        }
        this.fileB = pack.getFile("B.java");
        if (!this.fileB.exists()) {
            this.fileB.create((InputStream)new StringBufferInputStream("package package1;\npublic class B{}"), true, null);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetBuildConfigurator() {
        BuildConfigurator conf2;
        BuildConfigurator conf = BuildConfigurator.getBuildConfigurator();
        if (conf != (conf2 = BuildConfigurator.getBuildConfigurator())) {
            Assert.fail((String)"Build Configurator not unique.");
        }
    }

    public void testGetProjectBuildConfigurator() throws CoreException {
        BuildConfigurator conf = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator pbc = conf.getProjectBuildConfigurator(this.javaProject);
        if (pbc != null) {
            Assert.fail((String)"Could obtain a ProjectBuildConfigurator for non-aj project. This should not be possible.");
        }
        this.ajProject.close(null);
        pbc = conf.getProjectBuildConfigurator(this.ajProject);
        if (pbc != null) {
            Assert.fail((String)"Could obtain a ProjectBuildConfigurator for closed project. This should not be possible.");
        }
        this.ajProject.open(null);
        pbc = conf.getProjectBuildConfigurator(this.ajProject);
        if (pbc == null) {
            Assert.fail((String)"Could not get a ProjectBuildConfigurator for an aj project.");
        }
    }

    public void testGetBuildConfiguration() {
        BuildConfigurator conf = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator pbc = conf.getProjectBuildConfigurator(this.ajProject);
        BuildConfiguration bc = pbc.getActiveBuildConfiguration();
        if (bc == null) {
            Assert.fail((String)"Could not get active BuildConfiguration.");
        }
        ArrayList bcs = new ArrayList(pbc.getBuildConfigurations());
        Iterator iter = bcs.iterator();
        while (iter.hasNext()) {
            BuildConfiguration tempbc = (BuildConfiguration)iter.next();
            pbc.removeBuildConfiguration(tempbc);
        }
        bc = pbc.getActiveBuildConfiguration();
        iter = bcs.iterator();
        boolean isIncluded = false;
        while (iter.hasNext()) {
            BuildConfiguration tempbc = (BuildConfiguration)iter.next();
            pbc.addBuildConfiguration(tempbc);
            if (!tempbc.getFile().equals((Object)bc.getFile())) continue;
            isIncluded = true;
        }
        if (!isIncluded) {
            pbc.removeBuildConfiguration(bc);
        }
        if (bc == null) {
            Assert.fail((String)"No new build configuration was created when removing all old ones.");
        }
    }

    public void testBuildConfigurationIsincluded() {
        BuildConfigurator conf = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator pbc = conf.getProjectBuildConfigurator(this.ajProject);
        BuildConfiguration bc = pbc.getActiveBuildConfiguration();
        this.waitForJobsToComplete(this.ajProject);
        if (!bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"A.java was not included.");
        }
        if (!bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"B.java was not included.");
        }
        if (!bc.isIncluded((IResource)this.fileDef)) {
            Assert.fail((String)"InDefaultPackage.java was not included.");
        }
    }

    public void testBuildConfigurationExclude() throws CoreException {
        BuildConfigurator conf = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator pbc = conf.getProjectBuildConfigurator(this.ajProject);
        BuildConfiguration bc = pbc.getActiveBuildConfiguration();
        this.testBuildConfigurationIsincluded();
        this.waitForJobsToComplete(this.ajProject);
        ArrayList<Object> l = new ArrayList<Object>(3);
        l.add(this.fileA);
        bc.excludeFiles(l);
        this.waitForJobsToComplete(this.ajProject);
        if (bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"Exclude failed. A.java still included.");
        }
        if (!bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"Exclude failed. B.java should be included.");
        }
        if (!bc.isIncluded((IResource)this.fileDef)) {
            Assert.fail((String)"Exclude failed. InDefaultPackage.java should be included.");
        }
        l.clear();
        l.add(this.fileA.getParent());
        bc.excludeFiles(l);
        this.waitForJobsToComplete(this.ajProject);
        if (bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"Exclude failed. A.java still included.");
        }
        if (bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"Exclude failed. B.java still included.");
        }
        if (!bc.isIncluded((IResource)this.fileDef)) {
            Assert.fail((String)"Exclude failed. InDefaultPackage.java should be included.");
        }
        bc.includeFiles(l);
        this.waitForJobsToComplete(this.ajProject);
        if (!bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"Reinclude failed. A.java should be included.");
        }
        if (!bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"Reinclude failed. B.java should be included.");
        }
        if (!bc.isIncluded((IResource)this.fileDef)) {
            Assert.fail((String)"Reinclude failed. InDefaultPackage.java should be included.");
        }
        l.clear();
        l.add(this.fileA);
        l.add(this.fileB);
        bc.excludeFiles(l);
        this.waitForJobsToComplete(this.ajProject);
        if (bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"Exclude failed. A.java still included.");
        }
        if (bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"Exclude failed. B.java still included.");
        }
        if (!bc.isIncluded((IResource)this.fileDef)) {
            Assert.fail((String)"Exclude failed. InDefaultPackage.java should be included.");
        }
    }

    public void testBuildConfigurationInclude() throws CoreException {
        BuildConfigurator conf = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator pbc = conf.getProjectBuildConfigurator(this.ajProject);
        BuildConfiguration bc = pbc.getActiveBuildConfiguration();
        this.waitForJobsToComplete(this.ajProject);
        ArrayList<Object> l = new ArrayList<Object>(3);
        l.add(this.fileA.getParent());
        l.add(this.fileDef);
        bc.excludeFiles(l);
        this.waitForJobsToComplete(this.ajProject);
        if (bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"Exclude failed. A.java should be excluded.");
        }
        if (bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"Exclude failed. B.java should be excluded.");
        }
        if (bc.isIncluded((IResource)this.fileDef)) {
            Assert.fail((String)"Exclude failed. InDefaultPackage.java should be excluded.");
        }
        l.clear();
        l.add(this.fileDef);
        bc.includeFiles(l);
        this.waitForJobsToComplete(this.ajProject);
        if (bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"Include failed. A.java should be excluded.");
        }
        if (bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"Include failed. B.java should be excluded.");
        }
        if (!bc.isIncluded((IResource)this.fileDef)) {
            Assert.fail((String)"Include failed. InDefaultPackage.java should be included.");
        }
        l.clear();
        l.add(this.fileA.getParent());
        bc.includeFiles(l);
        this.waitForJobsToComplete(this.ajProject);
        if (!bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"Include failed. A.java is not included.");
        }
        if (!bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"Include failed. B.java is not included.");
        }
        if (!bc.isIncluded((IResource)this.fileDef)) {
            Assert.fail((String)"Include failed. InDefaultPackage.java is not included.");
        }
    }

    public void testNatureConversion() throws CoreException {
        BuildConfiguration bc;
        BuildConfigurator conf = BuildConfigurator.getBuildConfigurator();
        AJDTUtils.removeAspectJNature(this.ajProject);
        this.waitForJobsToComplete(this.ajProject);
        ProjectBuildConfigurator pbc = conf.getProjectBuildConfigurator(this.ajProject);
        if (pbc != null) {
            AJDTUtils.addAspectJNature(this.ajProject);
            Assert.fail((String)"could obtain pbc despite of removed aj nature");
        }
        IResource[] mems = this.ajProject.members();
        int i = 0;
        while (i < mems.length) {
            if (mems[i].getName().endsWith("ajproperties")) {
                mems[i].delete(true, null);
            }
            ++i;
        }
        IJavaProject jp = JavaCore.create((IProject)this.ajProject);
        IClasspathEntry[] cpes = jp.getRawClasspath();
        int i2 = 0;
        while (i2 < cpes.length) {
            if (cpes[i2].getPath().equals((Object)this.fileDef.getParent().getFullPath())) {
                IPath[] expats = new IPath[]{this.fileA.getFullPath().removeFirstSegments(cpes[i2].getPath().matchingFirstSegments(this.fileA.getFullPath()))};
                cpes[i2] = JavaCore.newSourceEntry((IPath)cpes[i2].getPath(), (IPath[])expats);
            }
            ++i2;
        }
        jp.setRawClasspath(cpes, null);
        AJDTUtils.addAspectJNature(this.ajProject);
        this.waitForJobsToComplete(this.ajProject);
        pbc = conf.getProjectBuildConfigurator(this.ajProject);
        if (pbc == null) {
            Assert.fail((String)"No ProjectBuildConfigurator was created after adding aj nature.");
        }
        if ((bc = pbc.getActiveBuildConfiguration()) == null) {
            Assert.fail((String)"No active build configuration was created when added aj nature to project.");
        }
        this.waitForJobsToComplete(this.ajProject);
        if (bc.isIncluded((IResource)this.fileA)) {
            Assert.fail((String)"jdt exclusion filter not taken into account when converted to aj project.");
        }
        if (!bc.isIncluded((IResource)this.fileDef) || !bc.isIncluded((IResource)this.fileB)) {
            Assert.fail((String)"not all desired files included after conversion to aj project.");
        }
        if (!bc.getFile().exists()) {
            Assert.fail((String)"New build configuration was created when adding aj nature, but file not written.");
        }
        jp.getRawClasspath();
        cpes = jp.getRawClasspath();
        int i3 = 0;
        while (i3 < cpes.length) {
            if (cpes[i3].getPath().equals((Object)this.fileDef.getParent().getFullPath()) && cpes[i3].getExclusionPatterns().length > 0) {
                Assert.fail((String)"Exclusion patterns not reset when converting to aj project.");
            }
            ++i3;
        }
    }

    private void waitForJobsToComplete(IProject pro) {
        Job job = new Job("Dummy Job"){

            public IStatus run(IProgressMonitor m) {
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.setRule((ISchedulingRule)pro);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

