/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.launching.JavaRuntime;

public class TestProject {
    private IProject project;
    private IJavaProject javaProject;
    private IPackageFragmentRoot sourceFolder;
    private boolean disposeDone = false;

    public TestProject() throws CoreException {
        this("TestProject", "bin", true);
    }

    public TestProject(String pname) throws CoreException {
        this(pname, "bin", true);
    }

    public TestProject(String pname, boolean createContent) throws CoreException {
        this(pname, "bin", createContent);
    }

    public TestProject(String pname, String outputfoldername) throws CoreException {
        this(pname, outputfoldername, true);
    }

    public TestProject(String pname, String outputfoldername, boolean createContent) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject(pname);
        this.project.create(null);
        this.project.open(null);
        this.javaProject = JavaCore.create((IProject)this.project);
        this.setJavaNature();
        IFolder outputFolder = this.createOutputFolder(outputfoldername);
        this.javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.createOutputFolder(outputFolder);
        if (createContent) {
            this.addSystemLibraries();
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void addJar(String plugin, String jar) throws MalformedURLException, IOException, JavaModelException {
        Path result = this.findFileInPlugin(plugin, jar);
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newLibraryEntry((IPath)result, null, null);
        this.javaProject.setRawClasspath(newEntries, null);
    }

    public IPackageFragment createPackage(String name) throws CoreException {
        if (this.sourceFolder == null) {
            this.sourceFolder = this.createSourceFolder();
        }
        return this.sourceFolder.createPackageFragment(name, false, null);
    }

    public IType createType(IPackageFragment pack, String cuName, String source) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        buf.append("package " + pack.getElementName() + ";\n");
        buf.append("\n");
        buf.append(source);
        ICompilationUnit cu = pack.createCompilationUnit(cuName, buf.toString(), false, null);
        return cu.getTypes()[0];
    }

    public IPackageFragmentRoot getSourceFolder() throws CoreException {
        if (this.sourceFolder == null) {
            this.sourceFolder = this.createSourceFolder();
        }
        return this.sourceFolder;
    }

    public IFolder createFolder(IPackageFragmentRoot root, String name) throws JavaModelException, CoreException {
        IFolder folder = (IFolder)root.getCorrespondingResource();
        IFolder ret = folder.getFolder(name);
        ret.create(true, true, null);
        return ret;
    }

    public IFile createFile(IFolder inFolder, String name, String content) throws CoreException {
        IFile file = inFolder.getFile(name);
        ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)source, true, null);
        return file;
    }

    public synchronized void dispose() throws CoreException {
        this.waitForIndexer();
        this.disposeDone = false;
        this.project.delete(true, true, new IProgressMonitor(){

            public void done() {
                TestProject.this.disposeDone();
            }

            public void beginTask(String name, int totalWork) {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        });
        try {
            if (!this.disposeDone) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void disposeDone() {
        this.disposeDone = true;
        this.notify();
    }

    private IFolder createOutputFolder(String outputfoldername) throws CoreException {
        IFolder binFolder = this.project.getFolder(outputfoldername);
        try {
            if (!binFolder.exists()) {
                binFolder.create(false, true, null);
            }
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
        return binFolder;
    }

    private void setJavaNature() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        this.project.setDescription(description, null);
    }

    private void createOutputFolder(IFolder binFolder) throws JavaModelException {
        IPath outputLocation = binFolder.getFullPath();
        this.javaProject.setOutputLocation(outputLocation, null);
    }

    private IPackageFragmentRoot createSourceFolder() throws CoreException {
        IFolder folder = this.project.getFolder("src");
        folder.create(false, true, null);
        IPackageFragmentRoot root = this.javaProject.getPackageFragmentRoot((IResource)folder);
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)root.getPath());
        this.javaProject.setRawClasspath(newEntries, null);
        return root;
    }

    private void addSystemLibraries() throws JavaModelException {
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaRuntime.getDefaultJREContainerEntry();
        this.javaProject.setRawClasspath(newEntries, null);
    }

    private Path findFileInPlugin(String plugin, String file) throws MalformedURLException, IOException {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IPluginDescriptor descriptor = registry.getPluginDescriptor(plugin);
        URL pluginURL = descriptor.getInstallURL();
        URL jarURL = new URL(pluginURL, file);
        URL localJarURL = Platform.asLocalURL((URL)jarURL);
        return new Path(localJarURL.getPath());
    }

    private void waitForIndexer() throws JavaModelException {
        new SearchEngine().searchAllTypeNames(ResourcesPlugin.getWorkspace(), null, null, 0, true, 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]), new ITypeNameRequestor(){

            public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            }

            public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            }
        }, 3, null);
    }
}

