/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.ajdt.buildconfigurator.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class UtilTests
extends TestCase {
    String pwd;

    protected void setUp() throws Exception {
        super.setUp();
        this.pwd = String.valueOf(System.getProperty("user.dir")) + "\\src\\org\\eclipse\\ajdt\\buildconfigurator\\tests";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetRelativePathStringWithCommonRoot() {
        Path from = new Path("c:/my/dir");
        Path file = new Path("c:/my/src/foo/bar/MyClass.java");
        String relativePath = Util.getRelativePathString((IPath)file, (IPath)from);
        Assert.assertEquals((String)"../src/foo/bar/MyClass.java", (String)relativePath);
    }

    public void testGetRelativePathStringNoCommonRoot() {
        Path from = new Path("c:/my/dir");
        Path file = new Path("c:/cat/in/the/hat/MyClass.java");
        String relativePath = Util.getRelativePathString((IPath)file, (IPath)from);
        Assert.assertEquals((String)"../../cat/in/the/hat/MyClass.java", (String)relativePath);
    }

    public void testGetRelativePathStringWithSameHome() {
        Path from = new Path("c:/my/dir");
        Path file = new Path("c:/my/dir/MyClass.java");
        String relativePath = Util.getRelativePathString((IPath)file, (IPath)from);
        Assert.assertEquals((String)"MyClass.java", (String)relativePath);
    }

    public void testGetRelativePathStringWithIdenticalPaths() {
        Path from = new Path("c:/warren/oates");
        Path file = new Path("c:/warren/oates");
        String relativePath = Util.getRelativePathString((IPath)file, (IPath)from);
        Assert.assertEquals((String)".", (String)relativePath);
    }

    public void testGetRelativePathStringWithNullFile() {
        IPath from = null;
        Path file = new Path("c:/my/src/foo/bar/MyClass.java");
        String relativePath = Util.getRelativePathString((IPath)file, from);
        Assert.assertNull((Object)relativePath);
    }

    public void testGetRelativePathStringWithNullFromDir() {
        Path from = new Path("c:/my/dir");
        IPath file = null;
        String relativePath = Util.getRelativePathString(file, (IPath)from);
        Assert.assertNull((Object)relativePath);
    }

    public void testGetRelativePathStringWithStringCommonRoot() {
        String from = "c:/my/dir";
        String file = "c:/my/src/foo/bar/MyClass.java";
        String relativePath = Util.getRelativePathString(file, from);
        Assert.assertEquals((String)"../src/foo/bar/MyClass.java", (String)relativePath);
    }

    public void testGetRelativePathStringNoStringCommonRoot() {
        String from = "c:/my/dir";
        String file = "c:/cat/in/the/hat/MyClass.java";
        String relativePath = Util.getRelativePathString(file, from);
        Assert.assertEquals((String)"../../cat/in/the/hat/MyClass.java", (String)relativePath);
    }

    public void testGetRelativePathStringWithStringNullFile() {
        String from = null;
        String file = "c:/my/src/foo/bar/MyClass.java";
        String relativePath = Util.getRelativePathString(file, from);
        Assert.assertNull((Object)relativePath);
    }

    public void testGetRelativePathStringWithStringNullFromDir() {
        String from = "c:/my/dir";
        String file = null;
        String relativePath = Util.getRelativePathString(file, from);
        Assert.assertNull((Object)relativePath);
    }

    public void testGetRelativePathStringWithIdenticalStrings() {
        String from = "c:/warren/oates";
        String file = "c:/warren/oates";
        String relativePath = Util.getRelativePathString(file, from);
        Assert.assertEquals((String)".", (String)relativePath);
    }

    public void testGetRelativePathStringWithEmptyStrings() {
        String from = "";
        String file = "";
        String relativePath = Util.getRelativePathString(file, from);
        Assert.assertEquals((String)".", (String)relativePath);
    }

    public void testGetLstFileContentsNullFile() {
        IPath lstFile = null;
        ArrayList files = new ArrayList();
        ArrayList options = new ArrayList();
        ArrayList links = new ArrayList();
        try {
            Util.getLstFileContents(lstFile, files, options, links);
            Assert.assertEquals((int)0, (int)files.size());
            Assert.assertEquals((int)0, (int)options.size());
            Assert.assertEquals((int)0, (int)links.size());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetLstFileContentsNonExistentFile() {
        Path lstFile = new Path("c:/made/up/file/name.lst");
        ArrayList files = new ArrayList();
        ArrayList options = new ArrayList();
        ArrayList links = new ArrayList();
        try {
            Util.getLstFileContents((IPath)lstFile, files, options, links);
            Assert.fail((String)"Preceeding call should have thrown FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testGetLstFileContentsFilesOnly() {
        Path lstFile = new Path(new File(this.pwd, "filesonly.lst").getAbsolutePath());
        ArrayList files = new ArrayList();
        ArrayList options = new ArrayList();
        ArrayList links = new ArrayList();
        try {
            Util.getLstFileContents((IPath)lstFile, files, options, links);
            Assert.assertEquals((int)18, (int)files.size());
            Assert.assertEquals((int)0, (int)options.size());
            Assert.assertEquals((int)0, (int)links.size());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetLstFileContentsFilesAndLinkOnly() {
        Path lstFile = new Path(new File(this.pwd, "filesandlinks.lst").getAbsolutePath());
        ArrayList files = new ArrayList();
        ArrayList options = new ArrayList();
        ArrayList links = new ArrayList();
        try {
            Util.getLstFileContents((IPath)lstFile, files, options, links);
            Assert.assertEquals((int)18, (int)files.size());
            Assert.assertEquals((int)0, (int)options.size());
            Assert.assertEquals((int)1, (int)links.size());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetLstFileOptionsOnly() {
        Path lstFile = new Path(new File(this.pwd, "optionsonly.lst").getAbsolutePath());
        ArrayList files = new ArrayList();
        ArrayList options = new ArrayList();
        ArrayList links = new ArrayList();
        try {
            Util.getLstFileContents((IPath)lstFile, files, options, links);
            Assert.assertEquals((int)0, (int)files.size());
            Assert.assertEquals((int)3, (int)options.size());
            Assert.assertEquals((int)0, (int)links.size());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetLstFileOptionsAndLinkOnly() {
        Path lstFile = new Path(new File(this.pwd, "optionsandlink.lst").getAbsolutePath());
        ArrayList files = new ArrayList();
        ArrayList options = new ArrayList();
        ArrayList links = new ArrayList();
        try {
            Util.getLstFileContents((IPath)lstFile, files, options, links);
            Assert.assertEquals((int)0, (int)files.size());
            Assert.assertEquals((int)3, (int)options.size());
            Assert.assertEquals((int)1, (int)links.size());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithNoLinksFile() {
        Path lstFile = new Path(new File(this.pwd, "filesonly.lst").getAbsolutePath());
        try {
            IPath result = Util.getInlinedLstFile((IPath)lstFile);
            Assert.assertSame((String)"Should get input IPath returned", (Object)lstFile, (Object)result);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithLinksFileAndAbsolutePath() {
        Path lstFile = new Path(new File(this.pwd, "filesandabsolutelink.lst").getAbsolutePath());
        try {
            IPath result = Util.getInlinedLstFile((IPath)lstFile);
            Assert.assertEquals((String)Util.getInlinedFileName(lstFile.toString()), (String)result.toString());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithLinksFileAndRelativePath() {
        Path lstFile = new Path(new File(this.pwd, "filesandrelativelink.lst").getAbsolutePath());
        try {
            IPath result = Util.getInlinedLstFile((IPath)lstFile);
            Assert.assertEquals((String)Util.getInlinedFileName(lstFile.toString()), (String)result.toString());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithNestedLinkFiles() {
        Path lstFile = new Path(new File(this.pwd, "linkone.lst").getAbsolutePath());
        try {
            IPath result = Util.getInlinedLstFile((IPath)lstFile);
            Assert.assertEquals((String)Util.getInlinedFileName(lstFile.toString()), (String)result.toString());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithBadLinkFile() {
        Path lstFile = new Path(new File(this.pwd, "badlink.lst").getAbsolutePath());
        try {
            IPath result = Util.getInlinedLstFile((IPath)lstFile);
            Assert.assertEquals((String)Util.getInlinedFileName(lstFile.toString()), (String)result.toString());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithNullInput() {
        try {
            IPath result = Util.getInlinedLstFile(null);
            Assert.assertNull((Object)result);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithNonExistentFileInput() {
        Path lstFile = new Path(new File(this.pwd, "doesnotexist.lst").getAbsolutePath());
        try {
            IPath result = Util.getInlinedLstFile((IPath)lstFile);
            Assert.fail((String)"Preceeding call should have thrown FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testGetInlinedFileName() {
        String result = Util.getInlinedFileName("c:\\made\\up\\name.lst");
        Assert.assertEquals((String)"c:\\made\\up\\name.inlined.lst", (String)result);
    }
}

