/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildManager;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationshipMap;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AspectJContentOutlinePage;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.visualiser.AJDTContentProvider;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class Builder
extends IncrementalProjectBuilder {
    public static final String DEFAULT_CONFIG_FILE = ".generated.lst";
    private static final int CONFIG_FILE_WRITE_ERROR = -10;
    private static final int DEFAULT_TIMEOUT = 120;
    private static final String COMPILE_TIMEOUT = "org.aspectj.ajdt.ui.compile-timeout";
    private static IProject lastBuiltProject = null;
    public static boolean isLocalBuild = false;
    private boolean buildCancelled = false;
    private BuildManager buildManager = null;
    private IProgressMonitor monitor;
    int totalnodes = 0;
    int totalrels = 0;

    public static IProject getLastBuildTarget() {
        return lastBuiltProject;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor progressMonitor) throws CoreException {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("Building at " + new Date().toString());
        }
        this.buildCancelled = false;
        IProject project = this.getProject();
        AspectJPlugin ajPlugin = AspectJPlugin.getDefault();
        ajPlugin.setCurrentProject(project);
        long buildstarttime = System.currentTimeMillis();
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        if (pbc != null && pbc.fullBuildRequested()) {
            kind = 6;
            pbc.requestFullBuild(false);
        }
        String buildPrereqsMessage = "The project cannot be built until its prerequisite " + project.getName() + " is rebuilt. Cleaning and rebuilding all projects is recommended";
        AJDTEventTrace.generalEvent("Trashing build state for project " + project.getName());
        JavaModelManager.getJavaModelManager().setLastBuiltState(project, null);
        try {
            String kindS = null;
            if (kind == 9) {
                kindS = "AUTOBUILD";
            }
            if (kind == 10) {
                kindS = "INCREMENTALBUILD";
            }
            if (kind == 6) {
                kindS = "FULLBUILD";
            }
            String mode = "";
            mode = AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getIncrementalMode() ? "Incremental AspectJ compilation" : "Full AspectJ compilation";
            AJDTEventTrace.generalEvent("build: Kind=" + kindS + " Project=" + project.getName() + " Mode=" + mode);
            IResourceDelta dta = this.getDelta(this.getProject());
            if (kind != 6 && !this.sourceFilesChanged(dta) && (dta.getFlags() | 0x80000) == 0) {
                AJDTEventTrace.generalEvent("build: Examined delta - no source file changes");
                return null;
            }
            this.monitor = progressMonitor;
            AJDTEventTrace.build(project, AspectJPlugin.getBuildConfigurationFile(project), ajPlugin.getAjdtProjectProperties().getClasspath());
            ProjectProperties props = ajPlugin.getAjdtProjectProperties();
            List projectFiles = props.getProjectSourceFiles(project, ProjectProperties.ASPECTJ_SOURCE_FILTER);
            this.updateBuildConfigIfNecessary(project, projectFiles);
            if (projectFiles.isEmpty()) {
                return null;
            }
            if (new File(AspectJPlugin.getBuildConfigurationFile(project)).length() == 0L) {
                return null;
            }
            IProject[] referencedProjects = this.getRequiredProjects(project);
            boolean haveClearedMarkers = false;
            int i = 0;
            while (i < referencedProjects.length) {
                String referencedMessage = "The project cannot be built until its prerequisite " + referencedProjects[i].getName() + " is rebuilt. Cleaning and rebuilding all projects is recommended";
                if (this.projectAlreadyMarked(project, referencedMessage)) {
                    if (kind == 6) {
                        props.clearMarkers(true);
                        CompilerMonitor.clearOtherProjectMarkers(project);
                    } else {
                        props.clearMarkers(false);
                    }
                    this.markProject(project, referencedMessage);
                    haveClearedMarkers = true;
                }
                ++i;
            }
            if (!haveClearedMarkers) {
                if (kind == 6) {
                    props.clearMarkers(true);
                    CompilerMonitor.clearOtherProjectMarkers(project);
                } else {
                    props.clearMarkers(false);
                }
            }
            AJDTUtils.changeProjectToClassDependencies(project);
            CompilerMonitor compilerMonitor = ajPlugin.getCompilerMonitor();
            if (kind == 6) {
                IJavaProject ijp = JavaCore.create((IProject)project);
                if (ijp != null) {
                    this.cleanOutputFolders(ijp);
                } else {
                    AJDTEventTrace.generalEvent("Unable to empty output folder on build all - why cant we find the IJavaProject?");
                }
                compilerMonitor.prepare(projectFiles, progressMonitor);
            } else {
                compilerMonitor.prepare(projectFiles, null);
            }
            lastBuiltProject = project;
            try {
                this.buildManager = Ajde.getDefault().getBuildManager();
                if (!AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getBuildAsm()) {
                    AJDTEventTrace.generalEvent("build: No structure model to be built for project: " + AspectJPlugin.getDefault().getCurrentProject().getName());
                    this.buildManager.setBuildModelMode(false);
                } else {
                    this.buildManager.setBuildModelMode(true);
                }
                if (kind == 6) {
                    this.buildManager.buildFresh(this.getBuildFilePath(project));
                } else {
                    this.buildManager.build(this.getBuildFilePath(project));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.waitForBuildCompletion(compilerMonitor);
            if (AspectJPlugin.getDefault().getDisplay().isDisposed()) {
                System.err.println("Not updating vis, display is disposed!");
            } else {
                AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
                            AJDTContentProvider provider = (AJDTContentProvider)ProviderManager.getContentProvider();
                            provider.reset();
                            VisualiserPlugin.refresh();
                        }
                    }
                });
            }
            if (this.buildCancelled) {
                this.markReferencingProjects(project, buildPrereqsMessage);
            } else {
                this.removeMarkerOnReferencingProjects(project, buildPrereqsMessage);
            }
            CompilerMonitor.showOutstandingProblems();
            if (!AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getBuildAsm()) {
                AspectJEditor.forceEditorUpdates(project);
            }
            StructureModelUtil.wipeCache();
            AspectJContentOutlinePage.performPendingAdviceMarkerUpdates();
            project.refreshLocal(2, null);
            AJDTEventTrace.generalEvent("build: build time = " + (System.currentTimeMillis() - buildstarttime) + "ms");
        }
        catch (Throwable t) {
            Ajde.getDefault().getErrorHandler().handleError("Compile failed.", t);
        }
        IProject[] requiredResourceDeltasOnNextInvocation = null;
        return requiredResourceDeltasOnNextInvocation;
    }

    private IProject[] getDependingProjects(IProject project) {
        IProject[] referencingProjects = project.getReferencingProjects();
        IProject[] classFolderReferences = AJDTUtils.getClassFolderDependingProjects(project);
        IProject[] dependingProjects = new IProject[referencingProjects.length + classFolderReferences.length];
        int i = 0;
        while (i < referencingProjects.length) {
            dependingProjects[i] = referencingProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderReferences.length) {
            dependingProjects[i + referencingProjects.length] = classFolderReferences[i];
            ++i;
        }
        return dependingProjects;
    }

    private IProject[] getRequiredProjects(IProject project) {
        IProject[] referencedProjects;
        try {
            referencedProjects = project.getReferencedProjects();
        }
        catch (CoreException e) {
            referencedProjects = new IProject[]{};
            e.printStackTrace();
        }
        IProject[] classFolderRequirements = AJDTUtils.getRequiredClassFolderProjects(project);
        IProject[] requiredProjects = new IProject[referencedProjects.length + classFolderRequirements.length];
        int i = 0;
        while (i < referencedProjects.length) {
            requiredProjects[i] = referencedProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderRequirements.length) {
            requiredProjects[i + referencedProjects.length] = classFolderRequirements[i];
            ++i;
        }
        return requiredProjects;
    }

    private void checkAndHandleCancelation() {
        if (this.monitor != null && this.buildManager != null && this.monitor.isCanceled()) {
            this.buildManager.abortBuild();
            this.buildCancelled = true;
        }
    }

    private void markReferencingProjects(IProject project, String errorMessage) {
        IProject[] referencingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < referencingProjects.length) {
            IProject referencingProject = referencingProjects[i];
            if (!this.projectAlreadyMarked(referencingProject, errorMessage)) {
                this.markProject(referencingProject, errorMessage);
            }
            ++i;
        }
    }

    private void markProject(IProject project, String errorMessage) {
        try {
            IMarker errorMarker = project.createMarker("org.eclipse.core.resources.problemmarker");
            errorMarker.setAttribute("message", (Object)errorMessage);
            errorMarker.setAttribute("severity", 2);
        }
        catch (CoreException e) {
            AJDTEventTrace.generalEvent("build: Problem occured creating the error marker for project " + project.getName() + ": " + e.getStackTrace());
        }
    }

    private void removeMarkerOnReferencingProjects(IProject project, String errorMessage) {
        try {
            IProject[] referencingProjects = this.getDependingProjects(project);
            int i = 0;
            while (i < referencingProjects.length) {
                IProject referencingProject = referencingProjects[i];
                IMarker[] problemMarkers = referencingProject.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                if (problemMarkers.length > 0) {
                    int j = 0;
                    while (j < problemMarkers.length) {
                        IMarker marker = problemMarkers[j];
                        int markerSeverity = marker.getAttribute("severity", -1);
                        String markerMessage = marker.getAttribute("message", "no message");
                        if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                            marker.delete();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            AJDTEventTrace.generalEvent("build: Problem occured either finding the markers for project " + project.getName() + ", or deleting the error marker: " + e.getStackTrace());
        }
    }

    private boolean projectAlreadyMarked(IProject project, String errorMessage) {
        try {
            IMarker[] problemMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            if (problemMarkers.length > 0) {
                int j = 0;
                while (j < problemMarkers.length) {
                    IMarker marker = problemMarkers[j];
                    int markerSeverity = marker.getAttribute("severity", -1);
                    String markerMessage = marker.getAttribute("message", "no message");
                    if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                        return true;
                    }
                    ++j;
                }
            }
        }
        catch (CoreException e) {
            AJDTEventTrace.generalEvent("build: Problem occured finding the markers for project " + project.getName() + ": " + e.getStackTrace());
        }
        return false;
    }

    private void dumpStructureModel() {
        IHierarchy hierarchy = AsmManager.getDefault().getHierarchy();
        if (hierarchy == null) {
            AJDTEventTrace.generalEvent("build: no structure model !!");
            return;
        }
        this.totalnodes = 0;
        this.totalrels = 0;
        this.dumpModelHelper(0, hierarchy.getRoot(), AsmManager.getDefault().getRelationshipMap());
        try {
            AJDTEventTrace.generalEvent("build: ProgramElements in ASM: " + this.totalnodes + (this.totalnodes == 1 ? "  (Probably just the .lst file)" : ""));
            AJDTEventTrace.generalEvent("build: Relationships in ASM: " + this.totalrels);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void dumpModelHelper(int depth, IProgramElement node, IRelationshipMap irm) {
        ++this.totalnodes;
        if (node instanceof IProgramElement) {
            IProgramElement ipe = node;
            List rels = irm.get(ipe);
            if (AspectJPlugin.DEBUG_BUILDER) {
                StringBuffer line = new StringBuffer();
                int i = 0;
                while (i < depth) {
                    line.append("-");
                    ++i;
                }
                line.append(">");
                line.append(node.toString());
                if (ipe.getSourceLocation() != null) {
                    line.append("    ").append(ipe.getSourceLocation().getSourceFile());
                }
                AJDTEventTrace.generalEvent(line.toString());
            }
            if (rels != null) {
                this.totalrels += rels.size();
            }
            if (ipe.getChildren() != null) {
                Iterator iter = ipe.getChildren().iterator();
                while (iter.hasNext()) {
                    IProgramElement h = (IProgramElement)iter.next();
                    this.dumpModelHelper(depth + 2, h, irm);
                }
            }
        } else {
            AJDTEventTrace.generalEvent("What the hell is this?" + node);
        }
    }

    private boolean sourceFilesChanged(IResourceDelta dta) {
        if (dta == null) {
            return true;
        }
        String resname = dta.getFullPath().toString();
        if (resname.endsWith(".java") || resname.endsWith(".aj")) {
            return true;
        }
        if (resname.endsWith(".lst") && !resname.endsWith("/default.lst")) {
            return true;
        }
        boolean kids_results = false;
        int i = 0;
        IResourceDelta[] kids = dta.getAffectedChildren();
        while (!kids_results && i < kids.length) {
            kids_results |= this.sourceFilesChanged(kids[i]);
            ++i;
        }
        return kids_results;
    }

    private void waitForBuildCompletion(CompilerMonitor monitor) {
        int timesTried = 0;
        int timeout = 120;
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        if (store.contains(COMPILE_TIMEOUT)) {
            timeout = store.getInt(COMPILE_TIMEOUT);
        } else {
            store.setValue(COMPILE_TIMEOUT, timeout);
        }
        while (!monitor.finished() && timesTried < timeout) {
            ++timesTried;
            try {
                this.checkAndHandleCancelation();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (timesTried == timeout) {
            this.waitForBuildCompletion(monitor);
        }
    }

    private boolean continueCompilation(final CompilerMonitor monitor) {
        final String title = AspectJPlugin.getResourceString("suspiciouslyLongCompileDialog");
        final String message = AspectJPlugin.getResourceString("isYourProjectReallyBig");
        AspectJPlugin.getDefault().getDisplay().syncExec(new Runnable(){

            public void run() {
                boolean keepWaiting = false;
                Shell[] s = AspectJPlugin.getDefault().getDisplay().getShells();
                if (s != null && s.length > 0) {
                    Shell shell = s[0];
                    keepWaiting = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
                }
                if (keepWaiting) {
                    IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
                    int timeout = store.getInt(Builder.COMPILE_TIMEOUT);
                    store.setValue(Builder.COMPILE_TIMEOUT, timeout *= 2);
                } else {
                    monitor.finish();
                }
            }
        });
        return !monitor.finished();
    }

    private String getBuildFilePath(IProject project) {
        String buildfile = AspectJPlugin.getBuildConfigurationFile(project);
        return buildfile;
    }

    private void updateBuildConfigIfNecessary(IProject project, List projectFiles) throws CoreException {
        if (this.getBuildFilePath(project).endsWith(DEFAULT_CONFIG_FILE)) {
            this.writeBuildConfigFile(projectFiles, project);
        }
    }

    private void writeBuildConfigFile(List projectFiles, IProject project) throws CoreException {
        String configurationFilename = this.getBuildFilePath(project);
        try {
            FileWriter fw = new FileWriter(configurationFilename);
            BufferedWriter bw = new BufferedWriter(fw);
            Iterator it = projectFiles.iterator();
            while (it.hasNext()) {
                File jf = (File)it.next();
                String fileName = jf.toString();
                if (!fileName.endsWith(".java") && !fileName.endsWith(".aj")) continue;
                bw.write(fileName);
                bw.write("\n");
            }
            bw.flush();
            fw.flush();
            fw.close();
            IResource res = project.findMember(DEFAULT_CONFIG_FILE);
            if (res != null) {
                res.refreshLocal(0, null);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.ajdt.ui", -10, AspectJPlugin.getResourceString("configFileCreateError"), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected void cleanOutputFolders(IJavaProject project) throws CoreException {
        boolean deleteAll = "clean".equals(project.getOption("org.eclipse.jdt.core.builder.cleanOutputFolder", true));
        if (deleteAll) {
            boolean linked = false;
            String realOutputLocation = null;
            IPath workspaceRelativeOutputPath = project.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                realOutputLocation = project.getResource().getLocation().toOSString();
            } else {
                IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
                linked = out.isLinked();
                realOutputLocation = out.getLocation().toOSString();
            }
            File outputDir = new File(realOutputLocation);
            int numberDeleted = this.wipeClasses(outputDir.listFiles());
            AJDTEventTrace.generalEvent("Builder: Tidied output folder, deleted " + numberDeleted + " .class files from " + realOutputLocation + (linked ? " (Linked output folder from " + workspaceRelativeOutputPath.toOSString() + ")" : ""));
        }
    }

    private int wipeClasses(File[] fs) {
        int count = 0;
        if (fs != null) {
            int fcounter = 0;
            while (fcounter < fs.length) {
                File file = fs[fcounter];
                if (file.getName().endsWith(".class")) {
                    file.delete();
                    ++count;
                }
                if (file.isDirectory()) {
                    count += this.wipeClasses(file.listFiles());
                }
                ++fcounter;
            }
        }
        return count;
    }
}

