/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.aspectj.ajde.Ajde;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class AJDTEventTrace {
    private static Vector listeners = new Vector();
    private static Vector eventTrace = new Vector();
    private static final int MAXENTRIES = 5000;
    private static final int EVT_STARTUP = 0;
    private static final int EVT_EDITOR_OPEN = 1;
    private static final int EVT_EDITOR_CLOSE = 2;
    private static final int EVT_CONFIG_SELECT = 3;
    private static final int EVT_STRUCTURE_VIEW = 4;
    private static final int EVT_MODEL_UPDATED = 5;
    private static final int EVT_BUILD = 6;
    private static final int EVT_VIEW_ACTION = 7;
    private static final int EVT_NEW_PROJECT = 8;
    private static final int EVT_NEW_CONFIG = 9;
    private static final int EVT_NEW_ASPECT = 10;
    private static final int EVT_NODE_CLICK = 11;
    private static final int EVT_PROJ_PROPS_CHANGED = 12;
    private static final int EVT_PROJ_PROPS_DEFAULTED = 13;
    private static final int EVT_BUILD_CONFIG_READ = 14;
    private static final int EVT_BUILD_CONFIG_WRITE = 15;
    private static final int EVT_GENERAL = 99999;

    public static void startup() {
        StringBuffer eventData = new StringBuffer();
        eventData.append("\tAJDT version: ");
        eventData.append(AspectJPlugin.VERSION);
        eventData.append("\n\tAspectJ Compiler version: ");
        eventData.append(Ajde.getDefault().getVersion());
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        String[] props = AspectJPlugin.getDefault().getPluginPreferences().propertyNames();
        int i = 0;
        while (i < props.length) {
            eventData.append("\n\t");
            eventData.append(props[i]);
            eventData.append(" = ");
            eventData.append(store.getString(props[i]));
            ++i;
        }
        AJDTEventTrace.addEvent(new Event(0, eventData));
    }

    public static void generalEvent(String eventDescription) {
        AJDTEventTrace.addEvent(new Event(99999, eventDescription));
    }

    public static void editorOpened(IFile onFile) {
        AJDTEventTrace.addEvent(new Event(1, onFile.getName()));
    }

    public static void editorClosed(IFile onFile) {
        AJDTEventTrace.addEvent(new Event(2, onFile.getName()));
    }

    public static void buildConfigSelected(String file, IProject project) {
        AJDTEventTrace.addEvent(new Event(3, file, project.getName()));
    }

    public static void structureViewRequested(String file) {
        AJDTEventTrace.addEvent(new Event(4, file));
    }

    public static void modelUpdated(IFile forFile) {
        AJDTEventTrace.addEvent(new Event(5, forFile.getName()));
    }

    public static void build(IProject project, String config, String classpath) {
        AJDTEventTrace.addEvent(new Event(6, new Object[]{project.getName(), config, classpath}));
    }

    public static void outlineViewAction(String action, IFile onFile) {
        AJDTEventTrace.addEvent(new Event(7, action, onFile.getName()));
    }

    public static void newProjectCreated(IProject project) {
        AJDTEventTrace.addEvent(new Event(8, project.getName()));
    }

    public static void newConfigFileCreated(IFile file) {
        AJDTEventTrace.addEvent(new Event(9, file.getName()));
    }

    public static void newAspectCreated(IFile file) {
        AJDTEventTrace.addEvent(new Event(10, file.getName()));
    }

    public static void nodeClicked(String label, IMarker target) {
        AJDTEventTrace.addEvent(new Event(11, label, target));
    }

    public static void projectPropertiesChanged(IProject project) {
        AJDTEventTrace.addEvent(new Event(12, project.getName()));
    }

    public static void projectPropertiesDefaulted(IProject project) {
        AJDTEventTrace.addEvent(new Event(13, project.getName()));
    }

    public static void buildConfigRead(IFile configFile) {
        AJDTEventTrace.addEvent(new Event(14, configFile.getName()));
    }

    public static void buildConfigWrite(IFile configFile) {
        AJDTEventTrace.addEvent(new Event(15, configFile.getName()));
    }

    private static void addEvent(final Event e) {
        if (eventTrace.size() > 5000) {
            eventTrace.remove(0);
        }
        eventTrace.add(e);
        if (!listeners.isEmpty()) {
            AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Iterator it = listeners.iterator();
                    while (it.hasNext()) {
                        ((EventListener)it.next()).ajdtEvent(e);
                    }
                }
            });
        }
    }

    public static void addListener(EventListener l) {
        listeners.add(l);
        Iterator it = eventTrace.iterator();
        while (it.hasNext()) {
            l.ajdtEvent((Event)it.next());
        }
    }

    public static void removeListener(EventListener l) {
        listeners.remove(l);
    }

    public static interface EventListener {
        public void ajdtEvent(Event var1);
    }

    public static class Event {
        Date time;
        int eventCode;
        Object[] eventData;

        public Event(int eventCode) {
            this.init(eventCode, new Object[0]);
        }

        public Event(int eventCode, Object eventData) {
            this.init(eventCode, new Object[]{eventData});
        }

        public Event(int eventCode, Object eventData1, Object eventData2) {
            this.init(eventCode, new Object[]{eventData1, eventData2});
        }

        public Event(int eventCode, Object[] eventData) {
            this.init(eventCode, eventData);
        }

        private void init(int eventCode, Object[] eventData) {
            this.time = new Date();
            this.eventCode = eventCode;
            this.eventData = eventData != null ? eventData : new Object[0];
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(DateFormat.getTimeInstance().format(this.time));
            buff.append("\t ");
            switch (this.eventCode) {
                case 0: {
                    buff.append("AJDT Plugin Startup\n");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 1: {
                    buff.append("Editor opened on ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 2: {
                    buff.append("Editor closed - ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 3: {
                    buff.append("Configuration file ");
                    buff.append(this.eventData[0]);
                    buff.append(" selected for ");
                    buff.append(this.eventData[1]);
                    break;
                }
                case 4: {
                    buff.append("Structure view requested for ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 5: {
                    buff.append("Model update notification for ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 6: {
                    buff.append("Building ");
                    buff.append(this.eventData[0]);
                    buff.append(" with config ");
                    buff.append(this.eventData[1]);
                    buff.append(".\n\t\t CLASSPATH=");
                    buff.append(this.eventData[2]);
                    break;
                }
                case 7: {
                    buff.append("Outline view action triggered: ");
                    buff.append(this.eventData[0]);
                    buff.append(" for ");
                    buff.append(this.eventData[1]);
                    break;
                }
                case 8: {
                    buff.append("New project created: ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 9: {
                    buff.append("New config file created: ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 10: {
                    buff.append("New aspect file created: ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 11: {
                    buff.append("Tree node selected: ");
                    buff.append(this.eventData[0]);
                    buff.append(". Navigation target: ");
                    if (this.eventData[1] != null) {
                        IMarker marker = (IMarker)this.eventData[1];
                        buff.append(marker.getResource().getName());
                        buff.append(" line ");
                        try {
                            Integer lineNo = (Integer)marker.getAttribute("lineNumber");
                            buff.append(lineNo);
                        }
                        catch (Exception ex) {
                            buff.append("ERR");
                        }
                        break;
                    }
                    buff.append("<None>");
                    break;
                }
                case 12: {
                    buff.append("Compiler properties changed for project: ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 13: {
                    buff.append("Compiler properties reset to default for project: ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 14: {
                    buff.append("Build configuration file read: ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 15: {
                    buff.append("Build configuration file written: ");
                    buff.append(this.eventData[0]);
                    break;
                }
                case 99999: {
                    buff.append(this.eventData[0]);
                }
            }
            return buff.toString();
        }
    }
}

