/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNode;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AJDTStructureViewNodeAdapter
implements IWorkbenchAdapter {
    private static AJDTStructureViewNodeAdapter instance = null;

    public static AJDTStructureViewNodeAdapter getDefault() {
        if (instance == null) {
            instance = new AJDTStructureViewNodeAdapter();
        }
        return instance;
    }

    private AJDTStructureViewNodeAdapter() {
    }

    public Object[] getChildren(Object o) {
        if (o instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode node = (AJDTStructureViewNode)o;
            return node.getChildren().toArray();
        }
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object o) {
        ImageDescriptor retVal = ImageDescriptor.getMissingImageDescriptor();
        if (o instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode node = (AJDTStructureViewNode)o;
            ImageDescriptor baseDesc = ((AJDTIcon)node.getIcon()).getImageDescriptor();
            retVal = this.decorate(baseDesc, node);
        }
        return retVal;
    }

    public String getLabel(Object o) {
        String label = "<>";
        if (o instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode node = (AJDTStructureViewNode)o;
            label = node.getLabel();
        }
        return label;
    }

    public Object getParent(Object o) {
        if (o instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode node = (AJDTStructureViewNode)o;
            return node.getParent();
        }
        return null;
    }

    private ImageDescriptor decorate(ImageDescriptor base, AJDTStructureViewNode node) {
        int flags = 0;
        IProgramElement pNode = node.getStructureNode();
        if (pNode != null) {
            IMessage sMessage;
            List modifiers = pNode.getModifiers();
            if (modifiers != null) {
                if (modifiers.contains(IProgramElement.Modifiers.ABSTRACT)) {
                    flags |= 1;
                }
                if (modifiers.contains(IProgramElement.Modifiers.FINAL)) {
                    flags |= 2;
                }
                if (modifiers.contains(IProgramElement.Modifiers.SYNCHRONIZED)) {
                    flags |= 4;
                }
                if (modifiers.contains(IProgramElement.Modifiers.STATIC)) {
                    flags |= 8;
                }
            }
            if (pNode.getKind() == IProgramElement.Kind.CONSTRUCTOR || pNode.getKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                flags |= 0x200;
            }
            if (pNode.isRunnable()) {
                flags |= 0x10;
            }
            if (pNode.isOverrider()) {
                flags |= 0x80;
            }
            if (pNode.isImplementor()) {
                flags |= 0x100;
            }
            if ((sMessage = pNode.getMessage()) != null) {
                if (sMessage.getKind() == IMessage.ERROR) {
                    flags |= 0x40;
                } else if (sMessage.getKind() == IMessage.WARNING) {
                    flags |= 0x20;
                }
            }
        }
        return AJDTUtils.decorate(base, flags);
    }
}

