/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.util.List;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.AbstractIconRegistry;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNode;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;

public class AJDTStructureViewNodeFactory
extends StructureViewNodeFactory {
    IRelationship latestRelationship;

    private AJDTStructureViewNodeFactory() {
        super(null);
    }

    public AJDTStructureViewNodeFactory(AbstractIconRegistry iconRegistry) {
        super(iconRegistry);
    }

    protected IStructureViewNode createDeclaration(IProgramElement node, AbstractIcon icon, List children) {
        if (icon == null || icon.getIconResource() == null) {
            icon = AJDTIcon.MISSING_ICON;
        }
        icon = this.changeIconIfAdviceNode(node, icon, false);
        return new AJDTStructureViewNode(node, icon, children);
    }

    protected IStructureViewNode createLink(IProgramElement node, AbstractIcon icon) {
        icon = this.latestRelationship != null ? this.changeIconIfAdviceNode(node, icon, this.latestRelationship.hasDynamicTests()) : this.changeIconIfAdviceNode(node, icon, false);
        return new AJDTStructureViewNode(node, icon);
    }

    protected IStructureViewNode createRelationship(IRelationship relationship, AbstractIcon icon) {
        this.latestRelationship = relationship;
        return new AJDTStructureViewNode(relationship, icon);
    }

    private AbstractIcon changeIconIfAdviceNode(IProgramElement node, AbstractIcon defaultIcon, boolean hasDynamicTests) {
        if (node.getKind() == IProgramElement.Kind.ADVICE && node.getAdviceInfo() != null && node.getAdviceInfo().getExtraAdviceInformation() != null) {
            defaultIcon = node.getAdviceInfo().getExtraAdviceInformation().equals("before") ? (hasDynamicTests ? AspectJImages.DYNAMIC_BEFORE_ADVICE : AspectJImages.BEFORE_ADVICE) : (node.getAdviceInfo().getExtraAdviceInformation().equals("around") ? (hasDynamicTests ? AspectJImages.DYNAMIC_AROUND_ADVICE : AspectJImages.AROUND_ADVICE) : (hasDynamicTests ? AspectJImages.DYNAMIC_AFTER_ADVICE : AspectJImages.AFTER_ADVICE));
        }
        return defaultIcon;
    }
}

