/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.AJDTConfigSettings;
import org.eclipse.ajdt.internal.ui.dialogs.MessageDialogWithToggle;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.wizards.AJDTPrefConfigWizard;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class AJDTUtils {
    private static final Point SMALL_SIZE = new Point(16, 16);
    private static final Point BIG_SIZE = new Point(22, 16);
    private static final int SMALL_ICONS_MASK = 32;
    private static Hashtable imageDescriptorCache = new Hashtable();

    public static String getWorkspacePath() {
        return AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public static String getProjectRootDirectory(IProject project) {
        return project.getLocation().toOSString();
    }

    public static String getResourcePath(IResource resource) {
        return resource.getLocation().toOSString();
    }

    public static ImageDescriptor decorate(ImageDescriptor base, int decorations) {
        Point size = AJDTUtils.useSmallSize(decorations) ? SMALL_SIZE : BIG_SIZE;
        String key = new String(String.valueOf(base.toString()) + ":::" + decorations + ":::" + size.toString());
        if (imageDescriptorCache.get(key) != null) {
            return (ImageDescriptor)imageDescriptorCache.get(key);
        }
        JavaElementImageDescriptor imageDescriptor = new JavaElementImageDescriptor(base, decorations, size);
        imageDescriptorCache.put(key, imageDescriptor);
        return imageDescriptor;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 0x20) != 0;
    }

    public static void addAjrtToBuildPath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            IClasspathEntry ajrtLIB = JavaCore.newVariableEntry((IPath)new Path("ASPECTJRT_LIB"), null, null);
            int originalCPLength = originalCP.length;
            IClasspathEntry[] newCP = new IClasspathEntry[originalCPLength + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCPLength);
            newCP[originalCPLength] = ajrtLIB;
            javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public static void addAspectJNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
        newNatures[0] = "org.eclipse.ajdt.ui.ajnature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        if (project.hasNature("org.eclipse.pde.PluginNature")) {
            AJDTUtils.addAJPluginDependency(project);
        } else {
            AJDTUtils.addAjrtToBuildPath(project);
        }
        AJDTUtils.changeProjectToClassDependencies(project);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AJDTUtils.verifyWorkbenchConfiguration();
            }
        });
        BuildConfigurator.getBuildConfigurator().setup(project);
    }

    public static void changeProjectToClassDependencies(IProject project) {
        List outputLocationPaths = AJDTUtils.getOutputLocationPaths(project);
        if (outputLocationPaths.size() == 0) {
            return;
        }
        IProject[] referencingProjects = project.getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            block12: {
                JavaProject ref;
                IProject referencingProject;
                block11: {
                    referencingProject = referencingProjects[i];
                    try {
                        if (referencingProject.hasNature("org.eclipse.jdt.core.javanature")) break block11;
                        break block12;
                    }
                    catch (CoreException e1) {
                        AspectJPlugin.logException(e1);
                    }
                }
                if ((ref = (JavaProject)JavaCore.create((IProject)referencingProject)) != null) {
                    JavaProject javaProject = ref;
                    try {
                        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                        int j = 0;
                        while (j < cpEntry.length) {
                            IClasspathEntry entry = cpEntry[j];
                            int entryKind = entry.getEntryKind();
                            IPath entryPath = entry.getPath();
                            if (entryKind == 2 && entryPath.equals((Object)project.getFullPath())) {
                                Iterator iter = outputLocationPaths.iterator();
                                while (iter.hasNext()) {
                                    IPath outputLocationPath = (IPath)iter.next();
                                    IClasspathEntry classFolderEntry = JavaCore.newLibraryEntry((IPath)outputLocationPath, null, null);
                                    newEntries.add(classFolderEntry);
                                }
                            } else {
                                newEntries.add(entry);
                            }
                            ++j;
                        }
                        IClasspathEntry[] newCP = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                        javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        JavaModelManager.getJavaModelManager().setLastBuiltState(project, null);
    }

    private static List getOutputLocationPaths(IProject project) {
        ArrayList<IPath> outputLocations = new ArrayList<IPath>();
        JavaProject jp = (JavaProject)JavaCore.create((IProject)project);
        if (jp == null) {
            return outputLocations;
        }
        JavaProject javaProject = jp;
        try {
            IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
            int j = 0;
            while (j < cpEntry.length) {
                IClasspathEntry entry = cpEntry[j];
                int entryKind = entry.getEntryKind();
                int contentKind = entry.getContentKind();
                if (contentKind == 10 && entry.getOutputLocation() != null) {
                    outputLocations.add(entry.getOutputLocation());
                }
                ++j;
            }
            if (outputLocations.size() == 0) {
                outputLocations.add(javaProject.getOutputLocation());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return outputLocations;
    }

    private static void changeClassToProjectDependencies(IProject project) {
        List outputLocationPaths = AJDTUtils.getOutputLocationPaths(project);
        if (outputLocationPaths.size() == 0) {
            return;
        }
        IProject[] dependingProjects = AJDTUtils.getClassFolderDependingProjects(project);
        int i = 0;
        while (i < dependingProjects.length) {
            IProject proj = dependingProjects[i];
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)proj);
            if (javaProject != null) {
                Iterator iterator = outputLocationPaths.iterator();
                while (iterator.hasNext()) {
                    IPath path = (IPath)iterator.next();
                    try {
                        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                        int j = 0;
                        while (j < cpEntry.length) {
                            IClasspathEntry entry = cpEntry[j];
                            int entryKind = entry.getEntryKind();
                            IPath entryPath = entry.getPath();
                            if (entryKind == 1 && entryPath.equals((Object)path)) {
                                IClasspathEntry projectEntry = JavaCore.newProjectEntry((IPath)project.getFullPath());
                                newEntries.add(projectEntry);
                            } else {
                                newEntries.add(entry);
                            }
                            ++j;
                        }
                        IClasspathEntry[] newCP = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                        javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public static IProject[] getClassFolderDependingProjects(IProject project) {
        IProject[] projectsInWorkspace = AspectJPlugin.getWorkspace().getRoot().getProjects();
        List outputLocationPaths = AJDTUtils.getOutputLocationPaths(project);
        ArrayList<IProject> dependingProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < projectsInWorkspace.length) {
            block9: {
                if (projectsInWorkspace[i].isOpen()) {
                    try {
                        JavaProject javaProject;
                        if (!projectsInWorkspace[i].hasNature("org.eclipse.jdt.core.javanature") || (javaProject = (JavaProject)JavaCore.create((IProject)projectsInWorkspace[i])) == null) break block9;
                        Iterator iterator = outputLocationPaths.iterator();
                        while (iterator.hasNext()) {
                            IPath path = (IPath)iterator.next();
                            try {
                                IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                                ArrayList newEntries = new ArrayList();
                                int j = 0;
                                while (j < cpEntry.length) {
                                    IClasspathEntry entry = cpEntry[j];
                                    int entryKind = entry.getEntryKind();
                                    IPath entryPath = entry.getPath();
                                    if (entryKind == 1 && entryPath.equals((Object)path)) {
                                        dependingProjects.add(projectsInWorkspace[i]);
                                        break block9;
                                    }
                                    ++j;
                                }
                            }
                            catch (JavaModelException e) {
                                e.printStackTrace();
                                break;
                            }
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        IProject[] projects = dependingProjects.toArray(new IProject[0]);
        return projects;
    }

    public static IProject[] getRequiredClassFolderProjects(IProject project) {
        JavaProject jp = (JavaProject)JavaCore.create((IProject)project);
        if (jp == null) {
            return new IProject[0];
        }
        JavaProject javaProject = jp;
        ArrayList<IProject> requiredProjects = new ArrayList<IProject>();
        IProject[] projectsInWorkspace = AspectJPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projectsInWorkspace.length) {
            block10: {
                try {
                    if (!projectsInWorkspace[i].isOpen()) break block10;
                    if (!projectsInWorkspace[i].hasNature("org.eclipse.jdt.core.javanature")) {
                    }
                }
                catch (CoreException e1) {}
                break block10;
                IProject proj = projectsInWorkspace[i];
                List outputLocationPaths = AJDTUtils.getOutputLocationPaths(proj);
                Iterator iterator = outputLocationPaths.iterator();
                block5: while (iterator.hasNext()) {
                    IPath path = (IPath)iterator.next();
                    try {
                        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                        ArrayList newEntries = new ArrayList();
                        int j = 0;
                        while (j < cpEntry.length) {
                            IClasspathEntry entry = cpEntry[j];
                            int entryKind = entry.getEntryKind();
                            IPath entryPath = entry.getPath();
                            if (entryKind == 1 && entryPath.equals((Object)path)) {
                                requiredProjects.add(projectsInWorkspace[i]);
                                break block5;
                            }
                            ++j;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
            ++i;
        }
        IProject[] projects = requiredProjects.toArray(new IProject[0]);
        return projects;
    }

    private static void removeMarkerOnReferencingProjects(IProject project) {
        try {
            String errorMessage = "The project cannot be built until its prerequisite " + project.getName() + " is rebuilt. Cleaning and rebuilding all projects is recommended";
            IProject[] refProjects = project.getReferencingProjects();
            IProject[] classFolderReferences = AJDTUtils.getClassFolderDependingProjects(project);
            IProject[] referencingProjects = new IProject[refProjects.length + classFolderReferences.length];
            int i = 0;
            while (i < refProjects.length) {
                referencingProjects[i] = refProjects[i];
                ++i;
            }
            i = 0;
            while (i < classFolderReferences.length) {
                referencingProjects[i + refProjects.length] = classFolderReferences[i];
                ++i;
            }
            i = 0;
            while (i < referencingProjects.length) {
                IProject referencingProject = referencingProjects[i];
                IMarker[] problemMarkers = referencingProject.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                if (problemMarkers.length > 0) {
                    int j = 0;
                    while (j < problemMarkers.length) {
                        IMarker marker = problemMarkers[j];
                        int markerSeverity = marker.getAttribute("severity", -1);
                        String markerMessage = marker.getAttribute("message", "no message");
                        if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                            marker.delete();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static void addAJPluginDependency(IProject project) {
        IWorkbenchWindow window = AspectJPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        boolean autoImport = false;
        if (AspectJPreferences.askPDEAutoImport() && AJDTUtils.confirmPDEAutoImport(window) || AspectJPreferences.doPDEAutoImport()) {
            autoImport = true;
        }
        if (autoImport) {
            AJDTUtils.importRuntimePlugin(project);
        } else {
            MessageDialog.openWarning((Shell)window.getShell(), (String)AspectJPlugin.getResourceString("NoAutoPluginImportDialog.title"), (String)AspectJPlugin.getResourceString("NoAutoPluginImportDialog.message"));
        }
    }

    private static void importRuntimePlugin(IProject project) {
        ManifestEditor manEd = AJDTUtils.getPDEManifestEditor(project);
        if (manEd != null) {
            IPluginModel model = (IPluginModel)manEd.getAggregateModel();
            try {
                AJDTUtils.addImportToPDEModel(model, "org.aspectj.ajde");
                manEd.doSave((IProgressMonitor)new NullProgressMonitor());
                project.build(6, "AspectJ Builder", null, null);
            }
            catch (CoreException e) {
                AspectJPlugin.getDefault().getLog().log(e.getStatus());
                ErrorDialog.openError((Shell)AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AutoPluginImportErrorDialog.title"), (String)AspectJPlugin.getResourceString("AutoPluginImportErrorDialog.message"), (IStatus)e.getStatus());
            }
        } else {
            AspectJPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("AutoPluginImportDialog.noEditor.message"), null));
            MessageDialog.openError((Shell)AspectJPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AutoPluginImportDialog.noEditor.title"), (String)AspectJPlugin.getResourceString("AutoPluginImportDialog.noEditor.message"));
        }
    }

    private static void addImportToPDEModel(IPluginModel model, String importId) throws CoreException {
        IPluginImport importNode = model.getPluginFactory().createImport();
        importNode.setId(importId);
        model.getPluginBase().add(importNode);
        IFile manifestFile = (IFile)model.getUnderlyingResource();
        manifestFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private static ManifestEditor getPDEManifestEditor(IProject project) {
        String pluginId = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModel(project).getPluginBase().getId();
        ManifestEditor.openPluginEditor((String)pluginId);
        ManifestEditor manEd = null;
        IEditorReference[] eRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < eRefs.length) {
            IEditorReference er = eRefs[i];
            if (er.getId().equals("org.eclipse.pde.ui.manifestEditor")) {
                IEditorReference manEdRef = er;
                manEd = (ManifestEditor)manEdRef.getPart(true);
                break;
            }
            ++i;
        }
        if (manEd != null) {
            manEd.setActivePage("dependencies");
        }
        return manEd;
    }

    public static void verifyWorkbenchConfiguration() {
        boolean showWizard = true;
        if (AspectJPreferences.isAJDTPrefConfigDone()) {
            showWizard = false;
        }
        if (AJDTConfigSettings.isAnalyzeAnnotationsDisabled() && AJDTConfigSettings.isAspectJEditorDefault()) {
            showWizard = false;
        }
        if (showWizard) {
            AJDTPrefConfigWizard wizard = new AJDTPrefConfigWizard();
            wizard.init();
            WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static void removeAspectJNature(IProject project) throws CoreException {
        AspectJPlugin ajPlugin = AspectJPlugin.getDefault();
        ajPlugin.setCurrentProject(project);
        ajPlugin.getAjdtProjectProperties().clearMarkers(true);
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length - 1];
        int newPosition = 0;
        int i = 0;
        while (i < prevNatures.length) {
            if (!prevNatures[i].equals("org.eclipse.ajdt.ui.ajnature")) {
                if (newPosition < newNatures.length) {
                    newNatures[newPosition++] = prevNatures[i];
                } else {
                    newNatures = prevNatures;
                    break;
                }
            }
            ++i;
        }
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        if (project.hasNature("org.eclipse.pde.PluginNature")) {
            AJDTUtils.removeAJPluginDependency(project);
        } else {
            AJDTUtils.removeAjrtFromBuildPath(project);
        }
        AJDTUtils.changeClassToProjectDependencies(project);
        AJDTUtils.removeMarkerOnReferencingProjects(project);
        BuildConfigurator.getBuildConfigurator().restoreJDTState(project);
    }

    private static void removeAJPluginDependency(IProject project) {
        ManifestEditor manEd = AJDTUtils.getPDEManifestEditor(project);
        if (manEd != null) {
            IPluginModel model = (IPluginModel)manEd.getAggregateModel();
            try {
                AJDTUtils.removeImportFromPDEModel(model, "org.aspectj.ajde");
                manEd.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                AspectJPlugin.getDefault().getLog().log(e.getStatus());
                ErrorDialog.openError((Shell)AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AutoPluginRemoveErrorDialog.title"), (String)AspectJPlugin.getResourceString("AutoPluginRemoveErrorDialog.message"), (IStatus)e.getStatus());
            }
        } else {
            AspectJPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.message"), null));
            MessageDialog.openError((Shell)AspectJPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.title"), (String)AspectJPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.message"));
        }
    }

    private static void removeImportFromPDEModel(IPluginModel model, String importId) throws CoreException {
        IPluginImport[] imports = model.getPluginBase().getImports();
        IPluginImport doomed = null;
        int i = 0;
        while (i < imports.length) {
            IPluginImport importObj = imports[i];
            if (importObj.getId().equals(importId)) {
                doomed = importObj;
                break;
            }
            ++i;
        }
        if (doomed != null) {
            model.getPluginBase().remove(doomed);
        }
        IFile manifestFile = (IFile)model.getUnderlyingResource();
        manifestFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeAjrtFromBuildPath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> tempCP = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < originalCP.length) {
                IPath path = originalCP[i].getPath();
                if (!path.toOSString().endsWith("ASPECTJRT_LIB") && !path.toOSString().endsWith("aspectjrt.jar")) {
                    tempCP.add(originalCP[i]);
                }
                ++i;
            }
            if (originalCP.length != tempCP.size()) {
                IClasspathEntry[] newCP = tempCP.toArray(new IClasspathEntry[tempCP.size()]);
                javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            AJDTEventTrace.generalEvent(e.getMessage());
        }
    }

    public static void verifyAjrtVersion(IProject current) {
        IJavaProject javaProject = JavaCore.create((IProject)current);
        String ajrtPath = AspectJPlugin.getDefault().getAjdtProjectProperties().getAspectjrtClasspath();
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> tempCP = new ArrayList<IClasspathEntry>();
            boolean changed = false;
            int i = 0;
            while (i < originalCP.length) {
                IPath path = originalCP[i].getPath();
                if (path.toOSString().endsWith("aspectjrt.jar")) {
                    IClasspathEntry ajrtCP = JavaCore.newLibraryEntry((IPath)new Path(ajrtPath), null, null);
                    tempCP.add(ajrtCP);
                    changed = true;
                    AJDTEventTrace.generalEvent("In project " + current.getName() + " - replacing " + originalCP[i].getPath() + " with " + ajrtCP.getPath());
                } else {
                    tempCP.add(originalCP[i]);
                }
                ++i;
            }
            if (changed) {
                IClasspathEntry[] newCP = tempCP.toArray(new IClasspathEntry[tempCP.size()]);
                javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            AJDTEventTrace.generalEvent(e.getMessage());
        }
    }

    private static boolean confirmPDEAutoImport(IWorkbenchWindow window) {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openQuestion(window.getShell(), AspectJPlugin.getResourceString("PluginImportDialog.importConfirmTitle"), AspectJPlugin.getResourceString("PluginImportDialog.importConfirmMsg"), AspectJPlugin.getResourceString("PluginImportDialog.importConfirmToggleMsg"), false);
        int result = dialog.getReturnCode();
        if (result >= 0 && dialog.getToggleState()) {
            if (result == 0) {
                AspectJPreferences.setDoPDEAutoImport(true);
                AspectJPreferences.setAskPDEAutoImport(false);
            } else {
                AspectJPreferences.setDoPDEAutoImport(false);
                AspectJPreferences.setAskPDEAutoImport(false);
            }
        }
        return result == 0;
    }
}

