/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class AJDTUtilsTest
extends TestCase {
    private IProject project;
    private IResource resource;

    public AJDTUtilsTest(String name) {
        super(name);
    }

    public void setUp() {
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        Assert.assertTrue((String)"Must be at least one project in workspace for this test", (projects.length > 0 ? 1 : 0) != 0);
        this.project = projects[0];
        Assert.assertEquals((String)"Project should be set to 'Examples'", (String)"Examples", (String)this.project.getName());
        this.resource = this.findRequiredResource(this.project, "custom1.lst");
    }

    public void testGetWorkspacePath() {
        String path = AJDTUtils.getWorkspacePath();
        Assert.assertEquals((String)"D:\\eclipse\\runtime-workspace", (String)path);
    }

    public void testGetProjectRootDirectory() {
        String path = AJDTUtils.getProjectRootDirectory(this.project);
        Assert.assertEquals((String)"D:\\eclipse\\runtime-workspace\\Examples", (String)path);
    }

    public void testGetResourcePath() {
        String path = AJDTUtils.getResourcePath(this.resource);
        Assert.assertEquals((String)"D:\\eclipse\\runtime-workspace\\Examples\\custom1.lst", (String)path);
    }

    private IResource findRequiredResource(IProject p, String fName) {
        IResource retVal = null;
        IResource[] projectMembers = null;
        try {
            projectMembers = p.members();
        }
        catch (CoreException cEx) {
            Assert.fail((String)("Exception listing project contents: " + cEx.getMessage()));
        }
        int i = 0;
        while (i < projectMembers.length) {
            IResource resource = projectMembers[i];
            if (resource.getName().endsWith(fName)) {
                retVal = resource;
                break;
            }
            ++i;
        }
        if (retVal == null) {
            Assert.fail((String)("Missing required project resource: " + fName + "in project " + p.getName()));
        }
        return retVal;
    }
}

