/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class NewAspectUtilsTest
extends TestCase {
    private IProject project;
    private IResource resource;

    public NewAspectUtilsTest(String name) {
        super(name);
    }

    public void testGetInnerInsertionPoint() {
        String input1 = "/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\npackage foo.test;\n\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {\n\tpublic static void main(String[] args){\n\t\tSystem.out.println(\"Hello\");\n\t}\n}";
        String clname1 = "TestClass";
        int p = NewAspectCreationWizardPage.NewAspectUtils.getInnerInsertionPoint(input1, clname1);
        String before = input1.substring(0, p);
        String after = input1.substring(p);
        Assert.assertTrue((String)"Pre- and post-insertion point sections should together match the entire input", (boolean)input1.equals(String.valueOf(before) + after));
        Assert.assertTrue((String)"Pre-insertion point section should end with {", (boolean)before.trim().endsWith("{"));
        Assert.assertTrue((String)"Post-insertion point section should begin with main declaration", (boolean)after.trim().startsWith("public static void main"));
    }

    public void testGetInnerImportsInsertionPoint() {
        String[] input = new String[]{"/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\npackage foo.test;\n\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {", "/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\npackage foo.test;\nimport javax.swing.JComponent;\nimport javax.swing.JFrame;\n\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {", "/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\nimport javax.swing.JComponent;\nimport javax.swing.JFrame;\n\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {", "/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {"};
        int i = 0;
        while (i < input.length) {
            int p = NewAspectCreationWizardPage.NewAspectUtils.getInnerImportsInsertionPoint(input[i]);
            String before = input[i].substring(0, p);
            String after = input[i].substring(p);
            Assert.assertTrue((String)"Pre- and post-insertion point sections should together match the entire input", (boolean)input[i].equals(String.valueOf(before) + after));
            if (i == 0 || i == 1) {
                Assert.assertTrue((String)"Pre-insertion point section should contain package statement", (before.indexOf("package") >= 0 ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)"Post-insertion point section should contain class declaration", (after.indexOf("public class TestClass") >= 0 ? 1 : 0) != 0);
            ++i;
        }
    }
}

