/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.isolation;

import org.eclipse.ajdt.internal.isolation.EclipseVersionStrategy;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;

public class EclipseVersionIsolationLayer {
    private static final String STRATEGY_PREFIX = "org.eclipse.ajdt.internal.isolation.EclipseVersionStrategyImpl_";
    private static boolean strategyLoaded = false;
    private static EclipseVersionStrategy strategy = null;

    public static EclipseVersionStrategy getStrategy() {
        if (!strategyLoaded) {
            EclipseVersionIsolationLayer.loadStrategy();
        }
        return strategy;
    }

    private EclipseVersionIsolationLayer() {
    }

    private static void loadStrategy() {
        if (!strategyLoaded) {
            IPluginRegistry registry = Platform.getPluginRegistry();
            IPluginDescriptor desc = registry.getPluginDescriptor("org.eclipse.core.resources");
            PluginVersionIdentifier ident = desc.getVersionIdentifier();
            String version = String.valueOf(ident.getMajorComponent()) + "_" + ident.getMinorComponent() + "_" + ident.getServiceComponent();
            try {
                Class<?> strategyClass = Class.forName(STRATEGY_PREFIX + version);
                strategy = (EclipseVersionStrategy)strategyClass.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        strategyLoaded = true;
    }
}

