/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.io.File;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class AspectJProjectPropertiesPage
extends PropertyPage
implements SelectionListener {
    private Button incremental_modeBtn;
    private Button buildAsmBtn;
    private Button showweavemessagesBtn;
    private Button fileExtBtn;
    private StringFieldEditor outputJarEditor;
    private StringFieldEditor nonStandardOptionsEditor;
    private IProject thisProject;
    private static int BROWSE_FOR_CLASSJARS = 0;
    private static int BROWSE_FOR_ASPECTJARS = 1;

    protected Control createContents(Composite parent) {
        this.thisProject = (IProject)this.getElement();
        BuildOptionsAdapter.ensurePropertiesInitialized(this.thisProject);
        Composite pageComposite = this.createPageComposite(parent, 3);
        Composite row0Composite = this.createRowComposite(pageComposite, 1);
        Label optionsLabel = this.createLabel(row0Composite, AspectJPlugin.getResourceString("compilerPropsPage.description"));
        Composite row3Comp = this.createRowComposite(pageComposite, 2);
        this.outputJarEditor = new StringFieldEditor("", AspectJPlugin.getResourceString("compilerPropsPage.outputJar"), row3Comp);
        this.nonStandardOptionsEditor = new StringFieldEditor("", AspectJPlugin.getResourceString("compilerPropsPage.nonStandardOptions"), StringFieldEditor.UNLIMITED, pageComposite);
        Label spacerLabel009 = this.createLabel(pageComposite, "");
        this.incremental_modeBtn = this.buildButton(pageComposite, AspectJPlugin.getResourceString("compilerPropsPage.useIncrementalCompiler"));
        Label incExptLabel = this.createLabel(pageComposite, AspectJPlugin.getResourceString("compilerPropsPage.incrementalCompilerStatus"));
        this.buildAsmBtn = this.buildButton(pageComposite, AspectJPlugin.getResourceString("compilerPropsPage.buildasm"));
        Label asmDetails = this.createLabel(pageComposite, AspectJPlugin.getResourceString("compilerPropsPage.buildasm.details"));
        this.showweavemessagesBtn = this.buildButton(pageComposite, AspectJPlugin.getResourceString("compilerPropsPage.showweavemessages"));
        Label showweavemessagesDetails = this.createLabel(pageComposite, AspectJPlugin.getResourceString("compilerPropsPage.showweavemessages.details"));
        this.fileExtBtn = this.buildButton(pageComposite, AspectJPlugin.getResourceString("compilerPropsPage.fileExt"));
        Label extDetails = this.createLabel(pageComposite, AspectJPlugin.getResourceString("compilerPropsPage.fileExt.details"));
        this.updatePageContents();
        return pageComposite;
    }

    private Button buildButton(Composite container, String label) {
        Button btn = new Button(container, 32);
        btn.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        btn.setLayoutData((Object)data);
        return btn;
    }

    private Button buildPushButton(Composite container, String label) {
        Button btn = new Button(container, 8);
        btn.setText(label);
        btn.addSelectionListener((SelectionListener)this);
        return btn;
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        button.setLayoutData((Object)data);
        return button;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.horizontalAlignment = 1;
        label.setLayoutData((Object)data);
        return label;
    }

    private Composite createPageComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Composite createRowComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void preserveSetting(QualifiedName key, boolean flag) throws CoreException {
        this.preserveSetting(key, new Boolean(flag).toString());
    }

    private void preserveSetting(QualifiedName key, String value) throws CoreException {
        this.thisProject.setPersistentProperty(key, value);
    }

    private String retrieveSettingString(QualifiedName key) {
        try {
            String value = this.thisProject.getPersistentProperty(key);
            return value;
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("projectProperties.exceptionDuringRetrieve"), ce);
            return "";
        }
    }

    private boolean retrieveSettingBoolean(QualifiedName key) {
        try {
            String value = this.thisProject.getPersistentProperty(key);
            if (value == null) {
                return false;
            }
            boolean valueB = new Boolean(value);
            return valueB;
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("projectProperties.exceptionDuringRetrieve"), ce);
            return false;
        }
    }

    private String findInvalidJars(String setOfJars) {
        if (setOfJars.length() == 0) {
            return null;
        }
        String inputCopy = setOfJars;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = this.thisProject.getLocation().toOSString();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (!f.exists()) {
                invalidEntries.append(f + "\n");
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (!f.exists()) {
                invalidEntries.append(f + "\n");
            }
        }
        if (invalidEntries.length() == 0) {
            return null;
        }
        return invalidEntries.toString();
    }

    private String findInvalidDirs(String setOfDirs) {
        if (setOfDirs.length() == 0) {
            return null;
        }
        String inputCopy = setOfDirs;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (!f.isDirectory()) {
                invalidEntries.append(f + "\n");
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (!f.isDirectory()) {
                invalidEntries.append(f + "\n");
            }
        }
        if (invalidEntries.length() == 0) {
            return null;
        }
        return invalidEntries.toString();
    }

    public boolean performOk() {
        String outJar = this.outputJarEditor.getStringValue();
        if (outJar != null) {
            try {
                if (!outJar.startsWith(File.separator)) {
                    IJavaProject jp = JavaCore.create((IProject)this.thisProject);
                    IPath workspaceRelativeOutpath = jp.getOutputLocation();
                    IPath full = AspectJPlugin.getWorkspace().getRoot().getLocation().append(workspaceRelativeOutpath);
                    outJar = full.toOSString();
                }
            }
            catch (JavaModelException jp) {
                // empty catch block
            }
        }
        AJDTEventTrace.projectPropertiesChanged(this.thisProject);
        try {
            this.preserveSetting(BuildOptionsAdapter.INCREMENTAL_COMPILATION, this.incremental_modeBtn.getSelection());
            this.preserveSetting(BuildOptionsAdapter.BUILD_ASM, this.buildAsmBtn.getSelection());
            this.preserveSetting(BuildOptionsAdapter.WEAVEMESSAGES, this.showweavemessagesBtn.getSelection());
            this.preserveSetting(BuildOptionsAdapter.OUTPUTJAR, this.outputJarEditor.getStringValue());
            this.preserveSetting(BuildOptionsAdapter.CHAR_ENC, "");
            this.preserveSetting(BuildOptionsAdapter.NON_STANDARD_OPTS, this.nonStandardOptionsEditor.getStringValue());
            this.preserveSetting(BuildOptionsAdapter.JAVA_OR_AJ_EXT, this.fileExtBtn.getSelection());
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("projectProperties.exceptionDuringStore"), ce);
            return false;
        }
        return true;
    }

    public void performDefaults() {
        AJDTEventTrace.projectPropertiesDefaulted(this.thisProject);
        try {
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.INCREMENTAL_COMPILATION, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.OUTPUTJAR, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.ASPECTJARS, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.SOURCEROOTS, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.INPUTJARS, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.CHAR_ENC, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.JAVA_OR_AJ_EXT, null);
            BuildOptionsAdapter.ensurePropertiesInitialized(this.thisProject);
            this.updatePageContents();
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("projectProperties.exceptionDefaultingProperties"), ce);
        }
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.widgetSelected(se);
    }

    public void widgetSelected(SelectionEvent se) {
        Object source = se.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
        }
    }

    public String calculateStrictnessFromButtons() {
        return null;
    }

    public void updatePageContents() {
        this.incremental_modeBtn.setSelection(this.retrieveSettingBoolean(BuildOptionsAdapter.INCREMENTAL_COMPILATION));
        this.buildAsmBtn.setSelection(this.retrieveSettingBoolean(BuildOptionsAdapter.BUILD_ASM));
        this.showweavemessagesBtn.setSelection(this.retrieveSettingBoolean(BuildOptionsAdapter.WEAVEMESSAGES));
        this.outputJarEditor.setStringValue(this.retrieveSettingString(BuildOptionsAdapter.OUTPUTJAR));
        this.nonStandardOptionsEditor.setStringValue(this.retrieveSettingString(BuildOptionsAdapter.NON_STANDARD_OPTS));
        this.fileExtBtn.setSelection(this.retrieveSettingBoolean(BuildOptionsAdapter.JAVA_OR_AJ_EXT));
    }
}

