/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.actions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveAJNatureAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private Vector selected = new Vector();

    public void run(IAction arg0) {
        Iterator iter = this.selected.iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            try {
                AJDTUtils.removeAspectJNature(project);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selected.clear();
        boolean enable = true;
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (object instanceof IJavaProject) {
                    object = ((IJavaProject)object).getProject();
                }
                if (object instanceof IProject) {
                    IProject project = (IProject)object;
                    try {
                        if (!project.isOpen() || !project.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                            enable = false;
                            break;
                        }
                        this.selected.add(project);
                    }
                    catch (CoreException e) {}
                    continue;
                }
                enable = false;
                break;
            }
            action.setEnabled(enable);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

