/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaProject;

public class BuildOptionsAdapter
implements org.aspectj.ajde.BuildOptionsAdapter {
    public static final QualifiedName INCREMENTAL_COMPILATION = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.incrementalMode");
    public static final QualifiedName BUILD_ASM = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.buildAsm");
    public static final QualifiedName WEAVEMESSAGES = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.showweavemessages");
    public static final QualifiedName INPUTJARS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inputJars");
    public static final QualifiedName INPUTJARSBROWSEDIR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inputJarsBrowseDir");
    public static final QualifiedName ASPECTJARSBROWSEDIR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectJarsBrowseDir");
    public static final QualifiedName INPATH = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpath");
    public static final QualifiedName INPATH_CON_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpathConKinds");
    public static final QualifiedName INPATH_ENT_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpathEntKinds");
    public static final QualifiedName ASPECTPATH = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpath");
    public static final QualifiedName ASPECTPATH_CON_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpathConKinds");
    public static final QualifiedName ASPECTPATH_ENT_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpathEntKinds");
    public static final QualifiedName OUTPUTJAR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.outputJar");
    public static final QualifiedName SOURCEROOTS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.sourceRoots");
    public static final QualifiedName ASPECTJARS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectJars");
    public static final QualifiedName CHAR_ENC = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.characterEncoding");
    public static final QualifiedName NON_STANDARD_OPTS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.nonStandardOptions");
    public static final QualifiedName COMPILATION_STRICTNESS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.compilationStrictness");
    public static final QualifiedName JAVA_OR_AJ_EXT = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.javaOrAjExt");
    public static final boolean INCREMENTAL_COMPILATION_DEFAULT = false;
    public static final boolean WEAVE_MESSAGES_DEFAULT = false;
    public static final boolean BUILD_ASM_DEFAULT = true;
    public static final String NON_STANDARD_OPTS_DEFAULT = "-Xlint";
    public static final String CHAR_ENC_DEFAULT = System.getProperty("file.encoding");
    public static final boolean JAVA_OR_AJ_EXT_DEFAULT = false;

    public Map getJavaOptionsMap() {
        Map optionsMap = null;
        try {
            JavaProject project = (JavaProject)AspectJPlugin.getDefault().getCurrentProject().getNature("org.eclipse.jdt.core.javanature");
            Class<?> superclass = project.getClass();
            Method getOptionsMethod = superclass.getDeclaredMethod("getOptions", Boolean.TYPE);
            optionsMap = (Map)getOptionsMethod.invoke((Object)project, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (optionsMap == null) {
            return JavaCore.getOptions();
        }
        return optionsMap;
    }

    public String toString() {
        StringBuffer formattedOptions = new StringBuffer();
        formattedOptions.append("Current Compiler options set:");
        formattedOptions.append("[Incremental compilation=" + this.getIncrementalMode() + "]");
        formattedOptions.append("[NonStandard options='" + this.getNonStandardOptions() + "']");
        return formattedOptions.toString();
    }

    private boolean retrieveSettingBoolean(QualifiedName key) {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        try {
            String value = thisProject.getPersistentProperty(key);
            boolean valueB = new Boolean(value);
            return valueB;
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("buildOptionsAdapter.exceptionDuringRetrieve"), ce);
            return false;
        }
    }

    private String retrieveSettingString(QualifiedName key) {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        try {
            String value = thisProject.getPersistentProperty(key);
            if (value == null) {
                return "";
            }
            return value;
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("buildOptionsAdapter.exceptionDuringRetrieve"), ce);
            return "";
        }
    }

    public boolean getLenientSpecMode() {
        return false;
    }

    public String getNonStandardOptions() {
        this.ensurePropertiesInitialized();
        String nonStandardOptions = this.retrieveSettingString(NON_STANDARD_OPTS);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getNonStandardOptions called, returning :" + nonStandardOptions);
        }
        nonStandardOptions = String.valueOf(nonStandardOptions) + AspectJPreferences.getLintOptions();
        nonStandardOptions = String.valueOf(nonStandardOptions) + AspectJPreferences.getAdvancedOptions();
        if (AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getShowWeaveMessages()) {
            nonStandardOptions = String.valueOf(nonStandardOptions) + " -showWeaveInfo";
        }
        return nonStandardOptions;
    }

    public boolean getPortingMode() {
        return false;
    }

    public boolean getPreprocessMode() {
        return false;
    }

    public boolean getSourceOnePointFourMode() {
        return false;
    }

    public boolean getStrictSpecMode() {
        return false;
    }

    public boolean getIncrementalMode() {
        this.ensurePropertiesInitialized();
        boolean incrementalMode = this.retrieveSettingBoolean(INCREMENTAL_COMPILATION);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getIncrementalMode called, returning :" + new Boolean(incrementalMode));
        }
        return incrementalMode;
    }

    public boolean getBuildAsm() {
        this.ensurePropertiesInitialized();
        boolean buildAsm = this.retrieveSettingBoolean(BUILD_ASM);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getBuildAsm called, returning :" + new Boolean(buildAsm));
        }
        return buildAsm;
    }

    public boolean getShowWeaveMessages() {
        this.ensurePropertiesInitialized();
        boolean showweavemessages = this.retrieveSettingBoolean(WEAVEMESSAGES);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getShowWeaveMessages called, returning :" + new Boolean(showweavemessages));
        }
        return showweavemessages;
    }

    public boolean getJavaOrAjExt() {
        this.ensurePropertiesInitialized();
        boolean javaOrAjExt = this.retrieveSettingBoolean(JAVA_OR_AJ_EXT);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getJavaOrAjExt called, returning :" + new Boolean(javaOrAjExt));
        }
        return javaOrAjExt;
    }

    public String getWorkingOutputPath() {
        return "";
    }

    public String getComplianceLevel() {
        return null;
    }

    public Set getDebugLevel() {
        return null;
    }

    public boolean getNoImportError() {
        return false;
    }

    public boolean getPreserveAllLocals() {
        return false;
    }

    public String getSourceCompatibilityLevel() {
        return null;
    }

    public Set getWarnings() {
        return null;
    }

    public boolean getUseJavacMode() {
        return false;
    }

    public String getCharacterEncoding() {
        return null;
    }

    private static void preserveSetting(IProject project, QualifiedName key, boolean flag) throws CoreException {
        BuildOptionsAdapter.preserveSetting(project, key, new Boolean(flag).toString());
    }

    private static void preserveSetting(IProject project, QualifiedName key, String value) throws CoreException {
        project.setPersistentProperty(key, value);
    }

    private void ensurePropertiesInitialized() {
        BuildOptionsAdapter.ensurePropertiesInitialized(AspectJPlugin.getDefault().getCurrentProject());
    }

    public static void ensurePropertiesInitialized(IProject project) {
        try {
            if (project.getPersistentProperty(INCREMENTAL_COMPILATION) == null) {
                BuildOptionsAdapter.preserveSetting(project, INCREMENTAL_COMPILATION, false);
            }
            if (project.getPersistentProperty(BUILD_ASM) == null) {
                BuildOptionsAdapter.preserveSetting(project, BUILD_ASM, true);
            }
            if (project.getPersistentProperty(WEAVEMESSAGES) == null) {
                BuildOptionsAdapter.preserveSetting(project, WEAVEMESSAGES, false);
            }
            if (project.getPersistentProperty(INPUTJARSBROWSEDIR) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPUTJARSBROWSEDIR, project.getLocation().toOSString());
            }
            if (project.getPersistentProperty(ASPECTJARSBROWSEDIR) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTJARSBROWSEDIR, project.getLocation().toOSString());
            }
            if (project.getPersistentProperty(INPATH) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPATH, "");
            }
            if (project.getPersistentProperty(INPATH_CON_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPATH_CON_KINDS, "");
            }
            if (project.getPersistentProperty(INPATH_ENT_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPATH_ENT_KINDS, "");
            }
            if (project.getPersistentProperty(ASPECTPATH) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTPATH, "");
            }
            if (project.getPersistentProperty(ASPECTPATH_CON_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTPATH_CON_KINDS, "");
            }
            if (project.getPersistentProperty(ASPECTPATH_ENT_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTPATH_ENT_KINDS, "");
            }
            if (project.getPersistentProperty(INPUTJARS) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPUTJARS, "");
            }
            if (project.getPersistentProperty(OUTPUTJAR) == null) {
                BuildOptionsAdapter.preserveSetting(project, OUTPUTJAR, "");
            }
            if (project.getPersistentProperty(ASPECTJARS) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTJARS, "");
            }
            if (project.getPersistentProperty(SOURCEROOTS) == null) {
                BuildOptionsAdapter.preserveSetting(project, SOURCEROOTS, "");
            }
            if (project.getPersistentProperty(CHAR_ENC) == null) {
                BuildOptionsAdapter.preserveSetting(project, CHAR_ENC, CHAR_ENC_DEFAULT);
            }
            if (project.getPersistentProperty(JAVA_OR_AJ_EXT) == null) {
                BuildOptionsAdapter.preserveSetting(project, JAVA_OR_AJ_EXT, false);
            }
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("buildOptionsAdapter.exceptionInitializingProperties"), ce);
        }
    }

    public String getOutJar() {
        this.ensurePropertiesInitialized();
        String outputJar = this.retrieveSettingString(OUTPUTJAR);
        if (outputJar.trim().length() > 0 && !outputJar.startsWith("\\") && !outputJar.startsWith("/")) {
            String trimmedName = outputJar.trim();
            boolean prependProject = true;
            if (trimmedName.length() > 1 && trimmedName.charAt(1) == ':') {
                prependProject = false;
            }
            if (prependProject) {
                IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
                String projectBaseDirectory = thisProject.getLocation().toOSString();
                outputJar = new String(String.valueOf(projectBaseDirectory) + File.separator + outputJar.trim());
            }
        }
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getOutJar called, returning :" + outputJar);
        }
        return outputJar;
    }

    public Set getInJars() {
        this.ensurePropertiesInitialized();
        String inputJars = this.retrieveSettingString(INPUTJARS);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getInJars called, returning :" + inputJars);
        }
        if (inputJars.length() == 0) {
            return null;
        }
        return this.mapStringToSet(inputJars, false);
    }

    public Set getInPath() {
        this.ensurePropertiesInitialized();
        String inpath = this.retrieveSettingString(INPATH);
        inpath = this.fullyQualifyPathEntries(inpath);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getInPath called, returning :" + inpath);
        }
        if (inpath.length() == 0) {
            return null;
        }
        return this.mapStringToSet(inpath, false);
    }

    private String fullyQualifyPathEntries(String inputPath) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(inputPath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            if (current.startsWith("/")) {
                String projectName = null;
                int slashPos = current.indexOf("/", 1);
                projectName = slashPos != -1 ? current.substring(1, slashPos) : current.substring(1);
                IProject project = AspectJPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.getLocation() != null) {
                    String projectPath = project.getLocation().toString();
                    if (slashPos != -1) {
                        resultBuffer.append(String.valueOf(projectPath) + "/" + current.substring(slashPos + 1));
                    } else {
                        resultBuffer.append(projectPath);
                    }
                } else {
                    AJDTEventTrace.generalEvent("AspectJ path entry " + current + " does not exist. Ignoring.");
                    if (AspectJPlugin.DEBUG_BUILDER) {
                        System.out.println("BuildOptionsAdapter.fullyQualifyPathEntries detected path entry " + current + " does not exist");
                    }
                }
            } else {
                resultBuffer.append(current);
            }
            resultBuffer.append(File.pathSeparator);
        }
        String result = resultBuffer.toString();
        if (result.endsWith(File.pathSeparator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public Set getAspectPath() {
        this.ensurePropertiesInitialized();
        String aspectpath = this.retrieveSettingString(ASPECTPATH);
        aspectpath = this.fullyQualifyPathEntries(aspectpath);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getAspectPath called, returning :" + aspectpath);
        }
        if (aspectpath.length() == 0) {
            return null;
        }
        return this.mapStringToSet(aspectpath, false);
    }

    private Set mapStringToSet(String input, boolean validateFiles) {
        if (input.length() == 0) {
            return null;
        }
        String inputCopy = input;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("Converting ]" + input + "[");
        }
        HashSet<File> fileSet = new HashSet<File>();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
                if (AspectJPlugin.DEBUG_BUILDER) {
                    System.out.println("Skipping file ]" + f.toString() + "[");
                }
            } else {
                fileSet.add(f);
                if (AspectJPlugin.DEBUG_BUILDER) {
                    System.out.println("Adding file ]" + f.toString() + "[");
                }
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
                if (AspectJPlugin.DEBUG_BUILDER) {
                    System.out.println("Skipping file ]" + f.toString() + "[");
                }
            } else {
                fileSet.add(f);
                if (AspectJPlugin.DEBUG_BUILDER) {
                    System.out.println("Adding file ]" + f.toString() + "[");
                }
            }
        }
        if (validateFiles && invalidEntries.length() != 0) {
            AspectJPlugin.getDefault().getErrorHandler().handleWarning("The following jar files do not exist and are being ignored:\n" + invalidEntries.toString());
        }
        return fileSet;
    }

    public Set getSourceRoots() {
        this.ensurePropertiesInitialized();
        String sourceRoots = this.retrieveSettingString(SOURCEROOTS);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getSourceRoots called, returning :" + sourceRoots);
        }
        return this.mapStringToSet(sourceRoots, false);
    }
}

