/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.ui.ajde.RuntimeClasspathCalculator;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class ProjectProperties
implements ProjectPropertiesAdapter {
    private static final String AJDE_VERSION_KEY = "ajde.version";
    private static final String AJDE_DEV = "@AJDEVERSION@";
    private static final String AJDE_VERSION_DEV = "9.9.9";
    private Hashtable fileToResourceHt = null;
    private String aspectjrtPath = null;
    public static final FilenameFilter ASPECTJ_SOURCE_FILTER = new FilenameFilter(){

        public boolean accept(String name) {
            return name.endsWith(".java") || name.endsWith(".aj");
        }
    };
    public static final FilenameFilter RESOURCE_FILTER = new FilenameFilter(){

        public boolean accept(String name) {
            return !name.endsWith(".java") && !name.endsWith(".aj") && !name.endsWith(".class");
        }
    };
    static /* synthetic */ Class class$0;

    public String getAjcWorkingDir() {
        return AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public String getOutputPath() {
        try {
            IProject currProject = AspectJPlugin.getDefault().getCurrentProject();
            IJavaProject jProject = JavaCore.create((IProject)currProject);
            IPath workspaceRelativeOutputPath = jProject.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                return jProject.getResource().getLocation().toOSString();
            }
            IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
            return out.getLocation().toOSString();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            Ajde.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("noOutputDir"), (Throwable)ce);
            return null;
        }
    }

    public String getProjectName() {
        return AspectJPlugin.getDefault().getCurrentProject().getName();
    }

    public String getClassToExecute() {
        System.err.println("*** AJ Plugin: ProjectProperties.getClassToExecute NOT IMPLEMENTED ***");
        return null;
    }

    public String getRootProjectDir() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        return project.getLocation().toOSString();
    }

    public List getProjectSourceFiles() {
        IProject activeProject = AspectJPlugin.getDefault().getCurrentProject();
        return this.getProjectSourceFiles(activeProject, ASPECTJ_SOURCE_FILTER);
    }

    public List getProjectSourceFiles(IProject project, FilenameFilter filter) {
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        if (pbc != null) {
            return pbc.getActiveBuildConfiguration().getIncludedJavaFiles(filter);
        }
        return new ArrayList(0);
    }

    public String getProjectSourcePath() {
        IProject p = AspectJPlugin.getDefault().getCurrentProject();
        return p.getLocation().toOSString();
    }

    public String getClasspath() {
        StringBuffer classpath = new StringBuffer();
        try {
            IProject proj = AspectJPlugin.getDefault().getCurrentProject();
            IJavaProject jp = JavaCore.create((IProject)proj);
            IRuntimeClasspathEntry[] rtcp = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)jp);
            HashSet<String> cp = new HashSet<String>();
            int i = 0;
            while (i < rtcp.length) {
                IRuntimeClasspathEntry[] resolved = RuntimeClasspathCalculator.resolveRuntimeClasspathEntry(rtcp[i], jp);
                int j = 0;
                while (j < resolved.length) {
                    cp.add(resolved[j].getLocation());
                    ++j;
                }
                ++i;
            }
            Iterator it = cp.iterator();
            while (it.hasNext()) {
                classpath.append(it.next());
                classpath.append(File.pathSeparator);
            }
        }
        catch (CoreException cEx) {
            System.out.println((Object)cEx);
        }
        if (AspectJPlugin.isDebugging) {
            System.out.println("Using classpath: " + classpath);
        }
        return classpath.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getJavaProjectClasspath(IProject project, Set projectClasspathSet, Set circularDependencyPreventer, boolean processingDependantProjects) throws CoreException {
        String projectLocalPrefix = String.valueOf(File.separator) + project.getName();
        String prependPath = project.getLocation().removeLastSegments(1).toOSString();
        IJavaProject jProject = JavaCore.create((IProject)project);
        String outputLocation = jProject.getOutputLocation().toOSString();
        if (processingDependantProjects) {
            projectClasspathSet.add(String.valueOf(prependPath) + outputLocation);
        }
        IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
        int i = 0;
        while (i < classpathEntries.length) {
            block9: {
                String cpstring = classpathEntries[i].getPath().toOSString();
                if (!processingDependantProjects || classpathEntries[i].isExported()) {
                    switch (classpathEntries[i].getEntryKind()) {
                        case 1: {
                            if (cpstring == null || !cpstring.startsWith(projectLocalPrefix)) break;
                            cpstring = String.valueOf(prependPath) + cpstring;
                            break;
                        }
                        case 2: {
                            String name = classpathEntries[i].getPath().lastSegment();
                            IProject projectDependancy = AspectJPlugin.getWorkspace().getRoot().getProject(name);
                            if (projectDependancy.exists() && projectDependancy.isOpen() && projectDependancy.hasNature("org.eclipse.jdt.core.javanature") && !circularDependencyPreventer.contains(projectDependancy)) {
                                circularDependencyPreventer.add(projectDependancy);
                                this.getJavaProjectClasspath(projectDependancy, projectClasspathSet, circularDependencyPreventer, true);
                            }
                            break block9;
                        }
                        case 3: {
                            cpstring = String.valueOf(prependPath) + cpstring;
                        }
                    }
                    projectClasspathSet.add(cpstring);
                }
            }
            ++i;
        }
    }

    public String getBootClasspath() {
        return null;
    }

    public String getExecutionArgs() {
        String options = AspectJPreferences.getCompilerOptions();
        return options;
    }

    public String getVmArgs() {
        return null;
    }

    public void clearMarkers(boolean recurse) {
        IProject currProject = AspectJPlugin.getDefault().getCurrentProject();
        try {
            currProject.deleteMarkers("org.eclipse.core.resources.problemmarker", true, recurse ? 2 : 0);
            currProject.deleteMarkers("org.eclipse.core.resources.taskmarker", true, recurse ? 2 : 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IResource findResource(String fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(fullPath);
        return root.getFileForLocation((IPath)path);
    }

    public IResource findResource(String fullPath, IProject p) {
        String toMatch = fullPath.replace('\\', '/');
        try {
            IJavaProject jp = JavaCore.create((IProject)p);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                IPath pe;
                IClasspathEntry e = cpes[i];
                if (e.getEntryKind() == 3 && (pe = e.getPath()).segment(0).equals(p.getName())) {
                    IProject iproj;
                    String postfix;
                    Path postfixPath;
                    IResource ires = p.findMember(pe.removeFirstSegments(1));
                    if (ires instanceof IFolder) {
                        IFolder f = (IFolder)ires;
                        if (toMatch.startsWith(f.getLocation().toString()) && f.exists((IPath)(postfixPath = new Path(postfix = toMatch.substring(f.getLocation().toString().length()))))) {
                            return f.findMember((IPath)postfixPath);
                        }
                    } else if (ires instanceof IProject && toMatch.startsWith((iproj = (IProject)ires).getLocation().toString()) && iproj.exists((IPath)(postfixPath = new Path(postfix = toMatch.substring(iproj.getLocation().toString().length()))))) {
                        return iproj.findMember((IPath)postfixPath);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException jp) {
            // empty catch block
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootPath = root.getLocation();
        Path path = new Path(fullPath);
        if (rootPath.isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(rootPath.segmentCount());
        }
        IResource ret = p.findMember((IPath)path);
        return ret;
    }

    public String getAspectjrtClasspath() {
        if (this.aspectjrtPath == null) {
            StringBuffer cpath = new StringBuffer();
            IPluginRegistry reg = Platform.getPluginRegistry();
            String ajVersion = AspectJPlugin.getResourceString(AJDE_VERSION_KEY);
            if (ajVersion.equals(AJDE_DEV)) {
                ajVersion = AJDE_VERSION_DEV;
            }
            int maj = 1;
            int min = 1;
            int svc = 1;
            try {
                StringTokenizer tok = new StringTokenizer(ajVersion, ".");
                maj = Integer.parseInt(tok.nextToken());
                min = Integer.parseInt(tok.nextToken());
                svc = Integer.parseInt(tok.nextToken());
            }
            catch (Exception ex) {
                System.err.println("Exception parsing AJDE version: " + ex);
            }
            IPluginDescriptor ajdePluginDesc = reg.getPluginDescriptor("org.aspectj.ajde", new PluginVersionIdentifier(maj, min, svc));
            if (ajdePluginDesc == null) {
                ajdePluginDesc = reg.getPluginDescriptor("org.aspectj.ajde");
            }
            String pluginLoc = null;
            if (ajdePluginDesc != null) {
                URL installLoc = ajdePluginDesc.getInstallURL();
                URL resolved = null;
                try {
                    resolved = Platform.resolve((URL)installLoc);
                    pluginLoc = resolved.toExternalForm();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (pluginLoc != null && pluginLoc.startsWith("file:")) {
                cpath.append(pluginLoc.substring("file:".length()));
                cpath.append("aspectjrt.jar");
            }
            if (new File(cpath.toString()).exists()) {
                this.aspectjrtPath = cpath.toString();
            } else {
                IPath rootPath = AspectJPlugin.getWorkspace().getRoot().getLocation();
                IPath installPath = rootPath.removeLastSegments(1);
                cpath = new StringBuffer().append(installPath.toOSString());
                cpath.append(File.separator);
                cpath.append("workspace");
                cpath.append(File.separator);
                cpath.append("org.aspectj.ajde");
                cpath.append(File.separator);
                cpath.append("aspectjrt.jar");
                if (new File(cpath.toString()).exists()) {
                    this.aspectjrtPath = cpath.toString();
                }
            }
        }
        return this.aspectjrtPath;
    }

    private void getAllFiles(IResource[] resource_list, List allProjectFiles, Hashtable fileToResourceHt, FilenameFilter filter, BuildConfiguration bc) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir instanceof IContainer) {
                    this.getAllFiles(((IContainer)ir).members(), allProjectFiles, fileToResourceHt, filter, bc);
                } else if (filter.accept(ir.getName()) && bc.isIncluded(ir)) {
                    allProjectFiles.add(new File(ir.getLocation().toOSString()));
                    if (fileToResourceHt != null) {
                        fileToResourceHt.put(new File(ir.getLocation().toOSString()), ir);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getProjectRelativePaths(IResource[] resource_list, List allProjectFiles, FilenameFilter filter, int trimSegments) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir instanceof IContainer) {
                    this.getProjectRelativePaths(((IContainer)ir).members(), allProjectFiles, filter, trimSegments);
                } else if (filter.accept(ir.getName())) {
                    String[] segments = ir.getProjectRelativePath().segments();
                    String path = "";
                    int j = trimSegments;
                    while (j < segments.length) {
                        path = String.valueOf(path) + segments[j];
                        if (j < segments.length - 1) {
                            path = String.valueOf(path) + '/';
                        }
                        ++j;
                    }
                    allProjectFiles.add(path);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getBuildConfigFiles() {
        ArrayList<String> lstFiles_Strings = new ArrayList<String>();
        List lstFiles_IResources = AspectJPlugin.getDefault().getListOfConfigFilesForCurrentProject();
        Iterator iter = lstFiles_IResources.iterator();
        while (iter.hasNext()) {
            IResource ir = (IResource)iter.next();
            lstFiles_Strings.add(ir.getFullPath().toOSString());
        }
        return lstFiles_Strings;
    }

    public String getDefaultBuildConfigFile() {
        String defaultLstFile = String.valueOf(AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString()) + File.separator + ".generated.lst";
        return defaultLstFile;
    }

    public String getLastActiveBuildConfigFile() {
        String currentLstFile = AspectJPlugin.getBuildConfigurationFile(AspectJPlugin.getDefault().getCurrentProject());
        return currentLstFile;
    }

    public Set getInJars() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getInJars();
    }

    public Map getSourcePathResources() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        HashMap<String, File> map = new HashMap<String, File>();
        try {
            String realOutputLocation;
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            IPath workspaceRelativeOutputPath = jProject.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                realOutputLocation = jProject.getResource().getLocation().toOSString();
            } else {
                IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
                realOutputLocation = out.getLocation().toOSString();
            }
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    IClasspathEntry sourceEntry = classpathEntries[i];
                    IPath sourcePath = sourceEntry.getPath();
                    ArrayList files = new ArrayList();
                    sourcePath = sourcePath.removeFirstSegments(1);
                    IResource[] srcContainer = new IResource[]{project.findMember(sourcePath)};
                    this.getProjectRelativePaths(srcContainer, files, RESOURCE_FILTER, srcContainer[0].getFullPath().segmentCount() - 1);
                    ArrayList linkedSrcFolders = this.getLinkedChildFolders(srcContainer[0]);
                    Iterator it = files.iterator();
                    while (it.hasNext()) {
                        String relPath = (String)it.next();
                        String fullPath = this.getResourceFullPath(srcContainer[0], relPath, linkedSrcFolders);
                        if (fullPath.startsWith(realOutputLocation) || relPath.endsWith(".classpath") || relPath.endsWith(".project") || relPath.endsWith(".ajsym") || relPath.endsWith(".lst")) continue;
                        File file = new File(fullPath);
                        map.put(relPath, file);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException jmEx) {
            String message = AspectJPlugin.getResourceString("jmCoreException");
            Status status = new Status(4, "org.eclipse.ajdt.ui", 0, message, (Throwable)jmEx);
            Shell shell = AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell();
            ErrorDialog.openError((Shell)shell, (String)AspectJPlugin.getResourceString("ajErrorDialogTitle"), (String)message, (IStatus)status);
        }
        return map;
    }

    public boolean getIncrementalMode() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getIncrementalMode();
    }

    public String getFileExt() {
        boolean javaOrAjExt = AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getJavaOrAjExt();
        return javaOrAjExt ? ".java" : ".aj";
    }

    public String getOutJar() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getOutJar();
    }

    public Set getSourceRoots() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getSourceRoots();
    }

    public Set getAspectPath() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getAspectPath();
    }

    private ArrayList getLinkedChildFolders(IResource resource) {
        ArrayList<IResource> resultList = new ArrayList<IResource>();
        if (resource instanceof IContainer) {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    try {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Method isLinkedMethod = clazz.getDeclaredMethod("isLinked", new Class[0]);
                        boolean linked = (Boolean)isLinkedMethod.invoke((Object)children[i], new Object[0]);
                        if (children[i] instanceof IFolder && linked) {
                            resultList.add(children[i]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    private String getResourceFullPath(IResource srcContainer, String relPath, ArrayList linkedFolders) {
        String result = null;
        if (relPath.lastIndexOf(47) != -1) {
            Iterator it = linkedFolders.iterator();
            while (it.hasNext()) {
                IFolder folder = (IFolder)it.next();
                String linkedFolderName = folder.getName();
                if (relPath.indexOf(String.valueOf(linkedFolderName) + "/") != 0) continue;
                result = String.valueOf(folder.getLocation().toString()) + relPath.substring(linkedFolderName.length());
                result = result.replace('/', File.separatorChar);
                break;
            }
        }
        if (result == null) {
            result = String.valueOf(srcContainer.getLocation().toOSString()) + File.separator + relPath;
        }
        return result;
    }

    public Set getInpath() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getInPath();
    }

    public static interface FilenameFilter {
        public boolean accept(String var1);
    }
}

