/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AdviceActionDelegate
extends AbstractRulerActionDelegate {
    IEditorPart editor = null;
    IVerticalRulerInfo rulerInfo = null;

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        String id;
        if (!(targetEditor == null || (id = targetEditor.getSite().getId()).equals("org.eclipse.jdt.ui.CompilationUnitEditor") || id.equals("org.eclipse.jdt.ui.ClassFileEditor") || id.equals("CompilationUnitEditor"))) {
            targetEditor = null;
        }
        this.editor = targetEditor;
        super.setActiveEditor(callerAction, targetEditor);
    }

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.rulerInfo = rulerInfo;
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        try {
            AJDTMenuAction ama;
            String textLabel;
            IMarker m;
            int j;
            Integer clickedLine;
            IEditorSite ies = this.editor.getEditorSite();
            IFileEditorInput ifep = (IFileEditorInput)this.editor.getEditorInput();
            IFile ifile = ifep.getFile();
            IDocumentProvider idp = ((ITextEditor)this.editor).getDocumentProvider();
            IDocument id = idp.getDocument((Object)ifep);
            int linenumber = this.rulerInfo.getLineOfLastMouseButtonActivity();
            IMarker[] markers = ifile.findMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
            IMarker[] decMarkers = ifile.findMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
            MenuManager adviceSubmenu = null;
            boolean adviceSubmenuInitialized = false;
            MenuManager declarationSubmenu = null;
            boolean declarationSubmenuInitialized = false;
            if (markers != null && markers.length != 0) {
                clickedLine = new Integer(linenumber + 1);
                j = 0;
                while (j < markers.length) {
                    m = markers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        textLabel = (String)m.getAttribute("message");
                        ama = new AJDTMenuAction(textLabel, m);
                        if (!adviceSubmenuInitialized) {
                            adviceSubmenu = new MenuManager(AspectJPlugin.getResourceString("EditorRulerContextMenu.adviceInAffect"));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IContributionItem)adviceSubmenu);
                            adviceSubmenuInitialized = true;
                        }
                        adviceSubmenu.add((IAction)ama);
                    }
                    ++j;
                }
            }
            if (decMarkers != null && decMarkers.length != 0) {
                clickedLine = new Integer(linenumber + 1);
                j = 0;
                while (j < decMarkers.length) {
                    m = decMarkers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        textLabel = (String)m.getAttribute("message");
                        ama = new AJDTMenuAction(textLabel, m);
                        if (!declarationSubmenuInitialized) {
                            declarationSubmenu = new MenuManager(AspectJPlugin.getResourceString("EditorRulerContextMenu.aspectDeclarations"));
                            if (!adviceSubmenuInitialized) {
                                manager.add((IContributionItem)new Separator());
                            }
                            manager.add((IContributionItem)declarationSubmenu);
                            declarationSubmenuInitialized = true;
                        }
                        declarationSubmenu.add((IAction)ama);
                    }
                    ++j;
                }
            }
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Exception whilst extending ruler context menu with advice items", ce);
        }
    }

    class AJDTMenuAction
    extends Action {
        IMarker adviceMarker;

        AJDTMenuAction(String s, IMarker marker) {
            super(s);
            String runtimeTest = AspectJPlugin.getResourceString("AspectJEditor.runtimetest");
            boolean hasRuntimeTest = false;
            if (s.endsWith(runtimeTest)) {
                hasRuntimeTest = true;
            }
            if (s.indexOf(".before(") != -1) {
                if (hasRuntimeTest) {
                    this.setImageDescriptor(AspectJImages.DYNAMIC_BEFORE_ADVICE.getImageDescriptor());
                } else {
                    this.setImageDescriptor(AspectJImages.BEFORE_ADVICE.getImageDescriptor());
                }
            } else if (s.indexOf(".after(") != -1 || s.indexOf(".afterReturning(") != -1 || s.indexOf(".afterThrowing(") != -1) {
                if (hasRuntimeTest) {
                    this.setImageDescriptor(AspectJImages.DYNAMIC_AFTER_ADVICE.getImageDescriptor());
                } else {
                    this.setImageDescriptor(AspectJImages.AFTER_ADVICE.getImageDescriptor());
                }
            } else if (s.indexOf(".around(") != -1) {
                if (hasRuntimeTest) {
                    this.setImageDescriptor(AspectJImages.DYNAMIC_AROUND_ADVICE.getImageDescriptor());
                } else {
                    this.setImageDescriptor(AspectJImages.AROUND_ADVICE.getImageDescriptor());
                }
            } else {
                this.setImageDescriptor(AspectJImages.ITD.getImageDescriptor());
            }
            this.adviceMarker = marker;
        }

        public void run() {
            block7: {
                try {
                    String jumpLocation = (String)this.adviceMarker.getAttribute("sourceLocationOfAdvice");
                    String filepath = jumpLocation.substring(0, jumpLocation.indexOf(":::"));
                    jumpLocation = jumpLocation.substring(jumpLocation.indexOf(":::") + 3);
                    String linenumber = jumpLocation.substring(0, jumpLocation.indexOf(":::"));
                    jumpLocation = jumpLocation.substring(jumpLocation.indexOf(":::") + 3);
                    String endlinenumber = jumpLocation.substring(0, jumpLocation.indexOf(":::"));
                    String columnnumber = jumpLocation.substring(jumpLocation.indexOf(":::") + 3);
                    IResource ir = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(filepath);
                    IMarker jumpMarker = null;
                    if (ir == null) break block7;
                    try {
                        jumpMarker = ir.createMarker("org.eclipse.core.resources.textmarker");
                        jumpMarker.setAttribute("lineNumber", new Integer(linenumber).intValue());
                    }
                    catch (CoreException ce) {
                        AspectJPlugin.getDefault().getErrorHandler().handleError("Unable to build jump marker in AdviceMenuAction run method", ce);
                    }
                    try {
                        IDE.openEditor((IWorkbenchPage)AspectJPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)jumpMarker, (boolean)true);
                    }
                    catch (Exception e) {
                        AspectJPlugin.getDefault().getErrorHandler().handleError("Exception whilst asking editor to jump to advice location", e);
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError("Problem parsing sourceLocationOfAdvice attribute value (probably!)", ioobe);
                }
                catch (CoreException ce) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError("Exception whilst executing AdviceMenuAction run method", ce);
                }
            }
        }
    }
}

