/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.editor.AJSourceViewerConfiguration;
import org.eclipse.ajdt.internal.ui.editor.AspectJContentOutlinePage;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.editor.ContextMenuManipulator;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.visualiser.NodeHolder;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AspectJEditor
extends CompilationUnitEditor {
    private AspectJContentOutlinePage contentOutlinePage;
    private AnnotationAccessWrapper annotationAccessWrapper;
    private boolean markersNeedUpdating = true;
    private static Set activeEditorList = new HashSet();
    static Set modifiedAspectToClass = new HashSet();
    private AJSourceViewerConfiguration fAJSourceViewerConfiguration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getRulerContextMenuId() != null) {
            String id = this.getRulerContextMenuId() != null ? this.getRulerContextMenuId() : "#RulerContext";
            MenuManager manager = new MenuManager(id, id);
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(this.getContextMenuListener());
            Control rulerControl = this.getVerticalRuler().getControl();
            Menu fRulerContextMenu = manager.createContextMenu(rulerControl);
            rulerControl.setMenu(fRulerContextMenu);
            this.getSite().registerContextMenu(this.getRulerContextMenuId(), manager, this.getSelectionProvider());
            manager.addMenuListener((IMenuListener)new ContextMenuManipulator());
        }
    }

    public IEditorInput getEditorInput() {
        IEditorInput input;
        block12: {
            boolean completionProcessing = false;
            RuntimeException caller = new RuntimeException();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            caller.printStackTrace(pw);
            pw.flush();
            String stacktrace = baos.toString();
            if (stacktrace.indexOf("JavaCompletionProcessor") != -1) {
                completionProcessing = true;
            }
            if ((input = super.getEditorInput()) instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                IDocument document = this.getDocumentProvider().getDocument((Object)fileInput);
                if (modifiedAspectToClass.contains(fileInput.getName())) {
                    if (!completionProcessing) {
                        String documentContents = document.get();
                        try {
                            int classindex = this.locateKeyword(documentContents, "class  ");
                            if (classindex == -1) {
                                AJDTEventTrace.generalEvent("CodeAssist:PossibleError: Make sure that " + fileInput.getName() + " is still an aspect!!!");
                                document.replace(0, 0, "");
                                modifiedAspectToClass.remove(fileInput.getName());
                                break block12;
                            }
                            AJDTEventTrace.generalEvent("CodeAssist:" + fileInput.getName() + ": Switching back from 'class  ' to 'aspect ': index " + classindex);
                            document.replace(classindex, 7, "aspect ");
                            modifiedAspectToClass.remove(fileInput.getName());
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else if (completionProcessing) {
                    String documentContents = document.get();
                    int aspectindex = this.locateKeyword(documentContents, "aspect ");
                    int bracketindex = documentContents.indexOf("{");
                    if (aspectindex != -1 && aspectindex < bracketindex) {
                        try {
                            AJDTEventTrace.generalEvent("CodeAssist:" + fileInput.getName() + ": Switching from 'aspect ' to 'class  ': index " + aspectindex);
                            document.replace(aspectindex, 7, "class  ");
                            modifiedAspectToClass.add(fileInput.getName());
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        }
        return input;
    }

    private int locateKeyword(String where, String what) {
        int location = -1;
        int offset = 0;
        String whereCopy = where;
        boolean cont = true;
        try {
            while (cont) {
                int whatIndex = whereCopy.indexOf(what);
                int oneLineComment = whereCopy.indexOf("//");
                int multiLineCommentStart = whereCopy.indexOf("/*");
                int multiLineCommentEnd = whereCopy.indexOf("*/");
                if (whatIndex == -1) {
                    cont = false;
                    break;
                }
                if (multiLineCommentStart == -1 || whatIndex < multiLineCommentStart) {
                    location = whatIndex + offset;
                    cont = false;
                }
                if (multiLineCommentStart == -1) continue;
                if (multiLineCommentEnd == -1) {
                    cont = false;
                    continue;
                }
                offset = offset + multiLineCommentEnd - multiLineCommentStart + 2;
                whereCopy = String.valueOf(whereCopy.substring(0, multiLineCommentStart)) + whereCopy.substring(multiLineCommentEnd + 2);
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
        return location;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.getContentOutlinePage(key);
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.source.IAnnotationAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz2)) {
            Object o = super.getAdapter(key);
            if (o instanceof IAnnotationAccessExtension) {
                if (this.annotationAccessWrapper == null) {
                    this.annotationAccessWrapper = new AnnotationAccessWrapper();
                }
                this.annotationAccessWrapper.setWrapped((IAnnotationAccessExtension)o);
                return this.annotationAccessWrapper;
            }
            return o;
        }
        return super.getAdapter(key);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                MessageDialog.openError((Shell)shell, (String)"CompilationUnitEditor.error.saving.title1", (String)"CompilationUnitEditor.error.saving.message1");
            }
        } else {
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    this.performSave(false, progressMonitor);
                }
            } else {
                this.performSave(false, progressMonitor);
            }
        }
        if (this.contentOutlinePage == null) {
            Object outlinePage;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((outlinePage = this.getContentOutlinePage(clazz)) instanceof AspectJContentOutlinePage) {
                this.contentOutlinePage = (AspectJContentOutlinePage)((Object)outlinePage);
            }
        }
    }

    private Object getContentOutlinePage(Class key) {
        Object outlinePage;
        block7: {
            outlinePage = null;
            if (AspectJPreferences.isAspectJOutlineEnabled()) {
                IEditorInput input = this.getEditorInput();
                if (input instanceof IFileEditorInput) {
                    IFile f = ((IFileEditorInput)input).getFile();
                    IProject p = f.getProject();
                    try {
                        if (p.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                            this.contentOutlinePage = new AspectJContentOutlinePage((AbstractTextEditor)this, f);
                            outlinePage = this.contentOutlinePage;
                            break block7;
                        }
                        outlinePage = super.getAdapter(key);
                    }
                    catch (CoreException cEx) {
                        outlinePage = super.getAdapter(key);
                    }
                } else {
                    outlinePage = super.getAdapter(key);
                }
            } else {
                outlinePage = super.getAdapter(key);
            }
        }
        return outlinePage;
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        SourceViewerConfiguration myConf = this.getSourceViewerConfiguration();
        if (myConf != null && myConf instanceof AJSourceViewerConfiguration && !(configuration instanceof AJSourceViewerConfiguration)) {
            return;
        }
        super.setSourceViewerConfiguration(configuration);
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            AJDTEventTrace.editorOpened(fInput.getFile());
            this.updateAdviceMarkers(fInput);
            activeEditorList.add(this);
            IDocument document = this.getDocumentProvider().getDocument((Object)fInput);
            AspectJTextTools textTools = AspectJPlugin.getDefault().getAspectJTextTools();
            textTools.setupJavaDocumentPartitioner(document, "___java_partitioning");
        }
    }

    public void updateAdviceMarkers() {
        this.updateAdviceMarkers((IFileEditorInput)this.getEditorInput());
    }

    public void forceUpdateOfAdviceMarkers() {
        this.markersNeedUpdating = true;
        this.updateAdviceMarkers((IFileEditorInput)this.getEditorInput());
    }

    public void updateAdviceMarkers(final IFileEditorInput fInput) {
        if (!this.markersNeedUpdating) {
            return;
        }
        if (fInput == null) {
            AJDTEventTrace.generalEvent("AspectJEditor: FileEditorInput is null for editor with title (" + this.getTitle() + "): Cannot update markers on it");
            return;
        }
        if (fInput.getFile() == null) {
            AJDTEventTrace.generalEvent("AspectJEditor: fileeditorinput.getFile() is null: see bugzilla #43662");
            return;
        }
        AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                block2: {
                    try {
                        fInput.getFile().deleteMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
                        fInput.getFile().deleteMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
                        AspectJEditor.this.addNewMarkers(fInput);
                    }
                    catch (CoreException ce) {
                        if (!fInput.getFile().exists()) break block2;
                        AspectJPlugin.getDefault().getErrorHandler().handleError("Advice marker updates failed", ce);
                    }
                }
            }
        });
    }

    private void addNewMarkers(final IFileEditorInput fInput) {
        IProject project = fInput.getFile().getProject();
        try {
            if (project == null || !project.isOpen() || !project.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        String path = fInput.getFile().getRawLocation().toOSString();
        Map m = StructureModelUtil.getLinesToAspectMap(path, true);
        if (m != null) {
            Set keys = m.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                final Integer linenumberInt = (Integer)o;
                final Vector v = (Vector)m.get(o);
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            boolean sameType = true;
                            boolean runtimeTst = false;
                            NodeHolder nh = (NodeHolder)v.get(0);
                            if (v.size() > 1) {
                                NodeHolder first = (NodeHolder)v.get(0);
                                String adviceType = first.node.getAdviceInfo() == null ? null : first.node.getAdviceInfo().getExtraAdviceInformation();
                                Iterator iter = v.iterator();
                                while (iter.hasNext()) {
                                    NodeHolder element = (NodeHolder)iter.next();
                                    boolean bl = runtimeTst = runtimeTst || element.runtimeTest;
                                    if (adviceType != null) {
                                        if (element.node.getAdviceInfo() == null) {
                                            sameType = false;
                                            continue;
                                        }
                                        sameType = sameType && adviceType.equals(element.node.getAdviceInfo().getExtraAdviceInformation());
                                        continue;
                                    }
                                    boolean bl2 = sameType = sameType && element.node.getAdviceInfo() == null;
                                }
                            } else if (v.size() == 1) {
                                runtimeTst = ((NodeHolder)v.get((int)0)).runtimeTest;
                            }
                            boolean runtimeTest = runtimeTst;
                            boolean useDefaultAdviceMarker = !sameType;
                            int j = 0;
                            while (j < v.size()) {
                                NodeHolder noddyHolder = (NodeHolder)v.get(j);
                                IProgramElement sn = noddyHolder.node;
                                IFile ir = fInput.getFile();
                                ISourceLocation sl_sn = sn.getSourceLocation();
                                String label = sn.toLinkLabelString();
                                String adviceType = sn.getName();
                                IMarker marker = AspectJEditor.this.createMarker(linenumberInt, runtimeTest, (IResource)ir, sn, useDefaultAdviceMarker, noddyHolder.runtimeTest);
                                ISourceLocation sLoc2 = sn.getSourceLocation();
                                marker.setAttribute("priority", 2);
                                marker.setAttribute("sourceLocationOfAdvice", (Object)(String.valueOf(sLoc2.getSourceFile().getAbsolutePath()) + ":::" + sLoc2.getLine() + ":::" + sLoc2.getEndLine() + ":::" + sLoc2.getColumn()));
                                ++j;
                            }
                        }
                        catch (CoreException ce) {
                            AspectJPlugin.getDefault().getErrorHandler().handleError("Exception creating advice marker", ce);
                        }
                    }
                };
                try {
                    AspectJPlugin.getWorkspace().run(r, null);
                }
                catch (CoreException cEx) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError("AJDT Error adding advice markers", cEx);
                }
            }
        }
        this.markersNeedUpdating = false;
    }

    public void dispose() {
        AJDTEventTrace.generalEvent("Disposing editor for:" + this.getTitle());
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            AJDTEventTrace.editorClosed(fInput.getFile());
            activeEditorList.remove((Object)this);
        }
        super.dispose();
    }

    public static void forceEditorUpdates(final IProject project) {
        final Iterator editorIter = activeEditorList.iterator();
        AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    while (true) {
                        IFileEditorInput ifei;
                        if (!editorIter.hasNext()) {
                            return;
                        }
                        AspectJEditor ajed = (AspectJEditor)((Object)editorIter.next());
                        IEditorInput iei = ajed.getEditorInput();
                        boolean updateThisEditor = true;
                        if (project != null && iei instanceof IFileEditorInput && !(ifei = (IFileEditorInput)iei).getFile().getProject().getName().equals(project.getName())) {
                            updateThisEditor = false;
                        }
                        if (!updateThisEditor) continue;
                        AJDTEventTrace.generalEvent("Forcing update of outline page for editor: " + ajed.getEditorInput().getName());
                        try {
                            ajed.contentOutlinePage.update();
                        }
                        catch (Throwable t) {
                            AJDTEventTrace.generalEvent("Unexpected exception updating editor outline " + t.toString());
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public void setFocus() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            AspectJPlugin.getDefault().setCurrentProject(fInput.getFile().getProject());
            this.updateAdviceMarkers(fInput);
        }
        super.setFocus();
    }

    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore store = this.getPreferenceStore();
        AspectJTextTools textTools = new AspectJTextTools(store);
        this.fAJSourceViewerConfiguration = new AJSourceViewerConfiguration(textTools, this, "___java_partitioning");
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fAJSourceViewerConfiguration);
    }

    private IMarker createMarker(Integer linenumberInt, boolean runtimeTest, IResource ir, IProgramElement programElement, boolean useDefaultAdviceMarker, boolean nodeRuntimeTest) throws CoreException {
        String label = programElement.toLinkLabelString();
        String adviceType = "";
        if (programElement.getAdviceInfo() != null) {
            adviceType = programElement.getAdviceInfo().getExtraAdviceInformation();
        }
        IMarker marker = useDefaultAdviceMarker ? (runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicadvicemarker") : (adviceType == "" ? ir.createMarker("org.eclipse.ajdt.ui.declarationmarker") : ir.createMarker("org.eclipse.ajdt.ui.advicemarker"))) : (adviceType.equals("before") ? (runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicbeforeadvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.beforeadvicemarker")) : (adviceType.equals("around") ? (runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicaroundadvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.aroundadvicemarker")) : (adviceType.startsWith("after") ? (runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicafteradvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.afteradvicemarker")) : ir.createMarker("org.eclipse.ajdt.ui.itdmarker"))));
        marker.setAttribute("lineNumber", linenumberInt.intValue());
        if (nodeRuntimeTest) {
            label = String.valueOf(label) + " " + AspectJPlugin.getResourceString("AspectJEditor.runtimetest");
        }
        marker.setAttribute("message", (Object)label);
        return marker;
    }

    class AnnotationAccessWrapper
    implements IAnnotationAccessExtension {
        private IAnnotationAccessExtension wrapped;

        AnnotationAccessWrapper() {
        }

        public void setWrapped(IAnnotationAccessExtension w) {
            this.wrapped = w;
        }

        public String getTypeLabel(Annotation annotation) {
            return this.wrapped.getTypeLabel(annotation);
        }

        public int getLayer(Annotation annotation) {
            int x = this.wrapped.getLayer(annotation);
            if ("org.eclipse.jdt.ui.overrideIndicator".equals(annotation.getType())) {
                x += 2;
            }
            return x;
        }

        public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
            this.wrapped.paint(annotation, gc, canvas, bounds);
        }

        public boolean isPaintable(Annotation annotation) {
            return this.wrapped.isPaintable(annotation);
        }

        public boolean isSubtype(Object annotationType, Object potentialSupertype) {
            return this.wrapped.isSubtype(annotationType, potentialSupertype);
        }

        public Object[] getSupertypes(Object annotationType) {
            return this.wrapped.getSupertypes(annotationType);
        }
    }
}

