/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class AspectJPreferences {
    public static final String COMPILER_OPTIONS = "aspectj.compiler.options.flags";
    public static final String ASPECTJ_OUTLINE = "org.eclipse.ajdt.ui.ajoutline";
    public static final String AUTOBUILD_SUPPRESSED = "org.eclipse.ajdt.ui.preferences.autobuildSuppressed";
    public static final String AJDT_PREF_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.ajdtPrefConfigDone";
    public static final String PDE_AUTO_IMPORT_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.pdeAutoImportConfigDone";
    public static final String ASK_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.askPdeAutoImport";
    public static final String DO_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.doPdeAutoImport";
    public static final String OPTION_ReportInvalidAbsoluteTypeName = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public static final String OPTION_ReportInvalidWildcardTypeName = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public static final String OPTION_ReportUnresolvableMember = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public static final String OPTION_ReportTypeNotExposedToWeaver = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public static final String OPTION_ReportShadowNotInStructure = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public static final String OPTION_ReportUnmatchedSuperTypeInCall = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public static final String OPTION_ReportCannotImplementLazyTJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public static final String OPTION_ReportNeedSerialVersionUIDField = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public static final String OPTION_ReportIncompatibleSerialVersion = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public static final String OPTION_ReportNoInterfaceCtorJoinpoint = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    public static final String OPTION_NoWeave = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    public static final String OPTION_XSerializableAspects = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public static final String OPTION_XLazyThisJoinPoint = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    public static final String OPTION_XNoInline = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public static final String OPTION_XReweavable = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    public static final String OPTION_XReweavableCompress = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    private static String[][] lintKeysName = new String[][]{{"org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", "invalidAbsoluteTypeName"}, {"org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", "invalidWildcardTypeName"}, {"org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", "unresolvableMember"}, {"org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", "typeNotExposedToWeaver"}, {"org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", "shadowNotInStructure"}, {"org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", "unmatchedSuperTypeInCall"}, {"org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", "canNotImplementLazyTjp"}, {"org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", "needsSerialVersionUIDField"}, {"org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", "brokeSerialVersionCompatibility"}, {"org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint", "noInterfaceCtorJoinpoint"}};
    private static String XlintProperties = "Xlint.properties";

    public static String getCompilerOptions() {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        return store.getString(COMPILER_OPTIONS);
    }

    public static void setCompilerOptions(String value) {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        store.setValue(COMPILER_OPTIONS, value);
    }

    public static String getLintOptions() {
        File optsFile = AspectJPlugin.getDefault().getStateLocation().append(XlintProperties).toFile();
        if (!optsFile.exists()) {
            AspectJPreferences.writeLintOptionsFile();
        }
        String opts = " -Xlintfile \"" + optsFile + "\" ";
        return opts;
    }

    public static void writeLintOptionsFile() {
        File optsFile = AspectJPlugin.getDefault().getStateLocation().append(XlintProperties).toFile();
        try {
            FileWriter writer = new FileWriter(optsFile);
            IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
            int i = 0;
            while (i < lintKeysName.length) {
                String value = store.getString(lintKeysName[i][0]);
                writer.write(String.valueOf(lintKeysName[i][1]) + " = " + value);
                writer.write(System.getProperty("line.separator"));
                ++i;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getAdvancedOptions() {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        String opts = " ";
        if (store.getBoolean(OPTION_NoWeave)) {
            opts = String.valueOf(opts) + "-XnoWeave ";
        }
        if (store.getBoolean(OPTION_XSerializableAspects)) {
            opts = String.valueOf(opts) + "-XserializableAspects ";
        }
        if (store.getBoolean(OPTION_XLazyThisJoinPoint)) {
            opts = String.valueOf(opts) + "-XlazyTjp ";
        }
        if (store.getBoolean(OPTION_XNoInline)) {
            opts = String.valueOf(opts) + "-XnoInline ";
        }
        if (store.getBoolean(OPTION_XReweavable)) {
            opts = String.valueOf(opts) + "-Xreweavable ";
        }
        if (store.getBoolean(OPTION_XReweavableCompress)) {
            opts = String.valueOf(opts) + "-Xreweavable:compress ";
        }
        return opts;
    }

    public static boolean isAspectJOutlineEnabled() {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASPECTJ_OUTLINE);
    }

    public static boolean isAutobuildSuppressed() {
        return false;
    }

    public static void setAJDTPrefConfigDone(boolean done) {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        store.setValue(AJDT_PREF_CONFIG_DONE, done);
    }

    public static boolean isAJDTPrefConfigDone() {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(AJDT_PREF_CONFIG_DONE);
    }

    public static void setAskPDEAutoImport(boolean ask) {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        store.setValue(ASK_PDE_AUTO_IMPORT, ask);
    }

    public static boolean askPDEAutoImport() {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASK_PDE_AUTO_IMPORT);
    }

    public static void setPDEAutoImportConfigDone(boolean done) {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        store.setValue(PDE_AUTO_IMPORT_CONFIG_DONE, done);
    }

    public static boolean isPDEAutoImportConfigDone() {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PDE_AUTO_IMPORT_CONFIG_DONE);
    }

    public static void setDoPDEAutoImport(boolean doImport) {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        store.setValue(DO_PDE_AUTO_IMPORT, doImport);
    }

    public static boolean doPDEAutoImport() {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DO_PDE_AUTO_IMPORT);
    }
}

