/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter;
import org.eclipse.ajdt.internal.ui.wizards.InPathBlock;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class InPathPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private IProject thisProject;
    protected InPathBlock fInPathBlock;
    private static final String PAGE_SETTINGS = "InPathPropertyPage";
    private static final String INDEX = "pageIndex";
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.thisProject = this.getProject();
        BuildOptionsAdapter.ensurePropertiesInitialized(this.thisProject);
        Control result = this.thisProject == null || !this.isAspectJProject(this.thisProject) ? this.createWithoutJava(parent) : (!this.thisProject.isOpen() ? this.createForClosedProject(parent) : this.createWithJava(parent, this.thisProject));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            IJavaElement elem;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((elem = (IJavaElement)adaptable.getAdapter((Class)clazz)) instanceof IJavaProject) {
                return ((IJavaProject)elem).getProject();
            }
        }
        return null;
    }

    private boolean isAspectJProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.ajdt.ui.ajnature");
        }
        catch (CoreException e) {
            AspectJPlugin.getDefault().getLog().log(e.getStatus());
            return false;
        }
    }

    private Control createWithoutJava(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.getString((String)"BuildPathsPropertyPage.no_java_project.message"));
        this.fInPathBlock = null;
        this.setValid(true);
        return label;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.getString((String)"BuildPathsPropertyPage.closed_project.message"));
        this.fInPathBlock = null;
        this.setValid(true);
        return label;
    }

    protected Control createWithJava(Composite parent, IProject project) {
        this.fInPathBlock = new InPathBlock(this, this.getSettings().getInt(INDEX));
        IClasspathEntry[] initalInpath = null;
        try {
            initalInpath = this.getInitialInpathValue(project);
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getLog().log(ce.getStatus());
            ErrorDialog.openError((Shell)AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("InPathProp.exceptionInitializingInpath.title"), (String)AspectJPlugin.getResourceString("InPathProp.exceptionInitializingInpath.message"), (IStatus)ce.getStatus());
        }
        this.fInPathBlock.init(JavaCore.create((IProject)project), null, initalInpath);
        return this.fInPathBlock.createControl(parent);
    }

    private IClasspathEntry[] getInitialInpathValue(IProject project) throws CoreException {
        ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>();
        String paths = project.getPersistentProperty(BuildOptionsAdapter.INPATH);
        String cKinds = project.getPersistentProperty(BuildOptionsAdapter.INPATH_CON_KINDS);
        String eKinds = project.getPersistentProperty(BuildOptionsAdapter.INPATH_ENT_KINDS);
        if (paths != null && paths.length() > 0 && cKinds != null && cKinds.length() > 0 && eKinds != null && eKinds.length() > 0) {
            StringTokenizer sTokPaths = new StringTokenizer(paths, File.pathSeparator);
            StringTokenizer sTokCKinds = new StringTokenizer(cKinds, File.pathSeparator);
            StringTokenizer sTokEKinds = new StringTokenizer(eKinds, File.pathSeparator);
            if (sTokPaths.countTokens() == sTokCKinds.countTokens() && sTokPaths.countTokens() == sTokEKinds.countTokens()) {
                while (sTokPaths.hasMoreTokens()) {
                    ClasspathEntry entry = new ClasspathEntry(Integer.parseInt(sTokCKinds.nextToken()), Integer.parseInt(sTokEKinds.nextToken()), (IPath)new Path(sTokPaths.nextToken()), new IPath[0], new IPath[0], null, null, null, false);
                    result.add(entry);
                }
            }
        }
        if (result.size() > 0) {
            return result.toArray(new IClasspathEntry[0]);
        }
        return null;
    }

    protected IDialogSettings getSettings() {
        IDialogSettings pathSettings = AspectJPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = pathSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = pathSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 1);
        }
        return pageSettings;
    }

    public boolean performOk() {
        if (this.fInPathBlock != null) {
            this.getSettings().put(INDEX, this.fInPathBlock.getPageIndex());
            Shell shell = this.getControl().getShell();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        InPathPropertyPage.this.fInPathBlock.configureJavaProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
            try {
                new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                String title = PreferencesMessages.getString((String)"BuildPathsPropertyPage.error.title");
                String message = PreferencesMessages.getString((String)"BuildPathsPropertyPage.error.message");
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.build_path_property_page_context");
    }
}

