/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AspectJProjectWizard
extends BasicNewProjectResourceWizard
implements IExecutableExtension {
    private NewJavaProjectWizardPage fJavaPage;
    private WizardNewProjectCreationPage fMainPage;
    private IConfigurationElement fConfigElement;

    public AspectJProjectWizard() {
        this.setDefaultPageImageDescriptor(AspectJImages.W_NEW_AJ_PRJ.getImageDescriptor());
        this.setDialogSettings(AspectJPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.title"));
    }

    public void addPages() {
        this.fMainPage = new WizardNewProjectCreationPage("NewAspectjProjectCreationWizard");
        this.fMainPage.setTitle(AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.title"));
        this.fMainPage.setDescription(AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.description"));
        this.fMainPage.setImageDescriptor(AspectJImages.W_NEW_AJ_PRJ.getImageDescriptor());
        this.addPage((IWizardPage)this.fMainPage);
        IWorkspaceRoot root = AspectJPlugin.getWorkspace().getRoot();
        this.fJavaPage = new NewJavaProjectWizardPage(root, this.fMainPage);
        this.addPage((IWizardPage)this.fJavaPage);
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fJavaPage.getRunnable());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            String title = AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.title");
            String message = AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.message");
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        IProject project = this.fJavaPage.getNewJavaProject().getProject();
        try {
            project.build(6, null);
        }
        catch (CoreException e) {
            System.err.println("Failed initial Java build of new project " + project.getName() + " : " + (Object)((Object)e));
            AspectJPlugin.getDefault().getLog().log(e.getStatus());
        }
        try {
            AJDTUtils.addAspectJNature(project);
        }
        catch (Throwable e) {
            System.out.println("> Error creating new project: " + e);
            e.printStackTrace();
        }
        AspectJPlugin.getDefault().setCurrentProject(project);
        this.selectAndReveal((IResource)project);
        AJDTEventTrace.newProjectCreated(project);
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }
}

