/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class BuildConfigurationCreationPage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;
    private Button includeProjectFilesCheckbox;
    private Button subsectionCheckbox;
    private Button openFileCheckbox;
    private static int nameCounter = 1;

    public BuildConfigurationCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("CreateBuildConfigurationFilePage1", selection);
        this.setTitle(AspectJPlugin.getResourceString("BuildConfig.createLstFile"));
        this.setDescription(AspectJPlugin.getResourceString("BuildConfig.createLstDesc"));
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        GridData data = (GridData)composite.getLayoutData();
        this.setFileName("buildConfig" + nameCounter + ".lst");
        new Label(composite, 0);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(AspectJPlugin.getResourceString("BuildConfig.autoPopulate"));
        group.setLayoutData((Object)new GridData(768));
        this.includeProjectFilesCheckbox = new Button((Composite)group, 32);
        this.includeProjectFilesCheckbox.setText(AspectJPlugin.getResourceString("BuildConfig.includeAllSource"));
        this.includeProjectFilesCheckbox.setSelection(true);
        this.includeProjectFilesCheckbox.addListener(13, (Listener)this);
        new Label(composite, 0);
        this.openFileCheckbox = new Button(composite, 32);
        this.openFileCheckbox.setText(AspectJPlugin.getResourceString("BuildConfig.openForEdit"));
        this.openFileCheckbox.setSelection(true);
        this.setPageComplete(this.validatePage());
    }

    public boolean finish() {
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow;
            IWorkbenchPage page;
            if (this.openFileCheckbox.getSelection() && (page = (dwindow = this.workbench.getActiveWorkbenchWindow()).getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        ++nameCounter;
        AJDTEventTrace.newConfigFileCreated(newFile);
        return true;
    }

    protected InputStream getInitialContents() {
        if (!this.includeProjectFilesCheckbox.getSelection()) {
            return null;
        }
        IProject proj = AspectJPlugin.getDefault().getCurrentProject();
        String containerFullPath = this.getContainerFullPath().makeAbsolute().toOSString();
        List projectFiles = AspectJPlugin.getDefault().getAjdtProjectProperties().getProjectSourceFiles(proj, ProjectProperties.ASPECTJ_SOURCE_FILTER);
        String projectPath = proj.getFullPath().toOSString();
        IPath workspacePath = proj.getLocation();
        workspacePath = workspacePath.removeLastSegments(1);
        String fullPath = String.valueOf(workspacePath.toOSString()) + containerFullPath;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < projectFiles.size()) {
            File file = (File)projectFiles.get(i);
            String filename = file.getAbsolutePath();
            filename = this.getRelativePath(fullPath, filename);
            sb.append(filename);
            sb.append("\n");
            ++i;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private String getRelativePath(String source, String dest) {
        String curfols;
        source = source.replace('/', '\\');
        dest = dest.replace('/', '\\');
        int isource = source.indexOf(92);
        int idest = dest.indexOf(92);
        if (idest != isource || !source.startsWith(dest.substring(0, idest))) {
            return dest;
        }
        source = source.substring(isource + 1).concat("\\");
        dest = dest.substring(idest + 1);
        String relPath = "";
        boolean different = false;
        isource = source.indexOf(92);
        idest = dest.indexOf(92);
        while (isource > 0 && idest > 0) {
            curfols = source.substring(0, isource);
            String curfold = dest.substring(0, idest);
            if (different || !curfols.equals(curfold)) {
                different = true;
                relPath = "..\\".concat(relPath.concat(String.valueOf(curfold) + "\\"));
            }
            source = source.substring(isource + 1);
            dest = dest.substring(idest + 1);
            isource = source.indexOf(92);
            idest = dest.indexOf(92);
        }
        if (idest <= 0) {
            while (isource > 0) {
                curfols = source.substring(0, isource);
                relPath = "..\\".concat(relPath);
                source = source.substring(isource + 1);
                isource = source.indexOf(92);
            }
        }
        return relPath.concat(dest);
    }

    protected String getNewFileLabel() {
        return AspectJPlugin.getResourceString("BuildConfig.newLstFile");
    }
}

