/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNodeFactory;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.AspectJResourceChangeListener;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.internal.ui.ajde.EditorAdapter;
import org.eclipse.ajdt.internal.ui.ajde.ErrorHandler;
import org.eclipse.ajdt.internal.ui.ajde.IdeUIAdapter;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferencePage;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.java.Templates;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AspectJPlugin
extends AbstractUIPlugin
implements ISelectionListener {
    public static String VERSION = "unset";
    public static final String PLUGIN_ID = "org.eclipse.ajdt.ui";
    public static final String ID_BUILDER = "org.eclipse.ajdt.ui.ajbuilder";
    public static final String ID_OUTLINE = "org.eclipse.ajdt.ui.ajoutlineview";
    public static final String ID_NATURE = "org.eclipse.ajdt.ui.ajnature";
    public static final String RUNTIME_PLUGIN_ID = "org.aspectj.ajde";
    private static final String AJDE_VERSION_KEY_CURRENT = "ajde.version";
    private static final String AJDE_VERSION_KEY_PREVIOUS = "ajde.version.at.previous.startup";
    public static final String NON_OS_SPECIFIC_SEPARATOR = "/";
    public static boolean isDebugging = false;
    public static boolean DEBUG_BUILDER = false;
    public static boolean DEBUG_COMPILER = false;
    public static boolean DEBUG_OUTLINE = false;
    private static AspectJPlugin plugin;
    private static Hashtable projectToBuildChoice;
    private ResourceBundle resourceBundle;
    private ProjectProperties ajdtProjectProperties;
    private CompilerMonitor ajdtCompilerMonitor;
    private EditorAdapter ajdtEditorAdapter;
    private org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter ajdtBuildOptions;
    private AspectJImages ajdtImages;
    private AJDTStructureViewNodeFactory ajdtStructureFactory;
    private IdeUIAdapter ajdtUIAdapter;
    private ErrorHandler ajdtErrorHandler;
    private AspectJTextTools aspectJTextTools;
    private IProject currentProject;
    private IResource currentResource;
    private Display display;
    IResourceChangeListener resourceChangeListener;
    private static final String defaultLstShouldBeUsed = "org.eclipse.ajdt.ui.buildConfig.useDefaultLst";
    public static final int PROGRESS_MONITOR_MAX = 100;

    static {
        projectToBuildChoice = new Hashtable();
    }

    public static AspectJPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AspectJPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getFormattedResourceString(String key, String arg) {
        return AspectJPlugin.getFormattedResourceString(key, new String[]{arg});
    }

    public static String getFormattedResourceString(String key, String[] args) {
        return MessageFormat.format(AspectJPlugin.getResourceString(key), args);
    }

    public static void setBuildConfigurationFile(IProject project, IFile buildfile) {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        String propertyName = "org.eclipse.ajdt.ui." + project.getName() + ".lst";
        if (buildfile == null) {
            store.setValue(propertyName, defaultLstShouldBeUsed);
        } else {
            store.setValue(propertyName, buildfile.getLocation().toOSString());
        }
        String cfg = AspectJPlugin.getBuildConfigurationFile(project);
        Ajde.getDefault().getConfigurationManager().setActiveConfigFile(cfg);
        AJDTEventTrace.buildConfigSelected(cfg, project);
    }

    public static void setBuildConfigurationFile(IProject project, IResource buildfile) {
        if (buildfile == null) {
            AspectJPlugin.setBuildConfigurationFile(project, null);
        } else if (buildfile instanceof IFile) {
            AspectJPlugin.setBuildConfigurationFile(project, (IFile)buildfile);
        }
    }

    public static String getBuildConfigurationFile(IProject project) {
        String configFile = String.valueOf(AJDTUtils.getProjectRootDirectory(project)) + File.separator + ".generated.lst";
        return configFile;
    }

    public AspectJPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        PluginVersionIdentifier pvi = descriptor.getVersionIdentifier();
        VERSION = String.valueOf(pvi.getMajorComponent()) + "." + pvi.getMinorComponent() + "." + pvi.getServiceComponent();
        this.initDebugging();
        plugin = this;
        this.ajdtProjectProperties = new ProjectProperties();
        this.ajdtCompilerMonitor = new CompilerMonitor();
        this.ajdtEditorAdapter = new EditorAdapter();
        this.ajdtErrorHandler = new ErrorHandler();
        this.ajdtBuildOptions = new org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter();
        this.ajdtImages = AspectJImages.registry();
        this.ajdtUIAdapter = new IdeUIAdapter();
        this.ajdtStructureFactory = new AJDTStructureViewNodeFactory(this.ajdtImages);
        Ajde.init((org.aspectj.ajde.EditorAdapter)this.ajdtEditorAdapter, (TaskListManager)this.ajdtCompilerMonitor, (BuildProgressMonitor)this.ajdtCompilerMonitor, (ProjectPropertiesAdapter)this.ajdtProjectProperties, (BuildOptionsAdapter)this.ajdtBuildOptions, (StructureViewNodeFactory)this.ajdtStructureFactory, (org.aspectj.ajde.ui.IdeUIAdapter)this.ajdtUIAdapter, (org.aspectj.ajde.ErrorHandler)this.ajdtErrorHandler);
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ajdt.internal.core.resources.AspectJPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        AJDTEventTrace.startup();
        new AspectVisualiserPlugin(descriptor);
        this.checkAspectJVersion();
    }

    private void checkAspectJVersion() {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        String currentAjdeVersion = AspectJPlugin.getResourceString(AJDE_VERSION_KEY_CURRENT);
        String previousAjdeVersion = store.getString(AJDE_VERSION_KEY_PREVIOUS);
        try {
            if (previousAjdeVersion == null || !currentAjdeVersion.equals(previousAjdeVersion)) {
                AJDTEventTrace.generalEvent("New version of AJDE detected (now:" + currentAjdeVersion + ") - checking aspectjrt.jar for each project.");
                IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    IProject current;
                    if (projects[i].isOpen() && (current = projects[i]).hasNature(ID_NATURE)) {
                        AJDTUtils.verifyAjrtVersion(current);
                    }
                    ++i;
                }
                this.checkTemplatesInstalled();
                store.putValue(AJDE_VERSION_KEY_PREVIOUS, currentAjdeVersion);
            }
        }
        catch (CoreException e) {
            AJDTEventTrace.generalEvent("Problem attempting to check aspectjrt.jar for");
            e.printStackTrace();
        }
    }

    private void checkTemplatesInstalled() throws CoreException {
        Templates codeTemplates = Templates.getInstance();
        try {
            URL loc = new URL(this.getDescriptor().getInstallURL(), "aspectj_code_templates.xml");
            Class<?> tc = codeTemplates.getClass();
            Method[] meths = tc.getMethods();
            Method methodToCall = null;
            int i = 0;
            while (i < meths.length) {
                if (meths[i].getName().equals("addFromStream")) {
                    methodToCall = meths[i];
                    break;
                }
                ++i;
            }
            if (methodToCall != null) {
                if (methodToCall.getParameterTypes().length == 4) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = loc.openStream();
                    objectArray[1] = Boolean.FALSE;
                    objectArray[2] = Boolean.FALSE;
                    Object[] args = objectArray;
                    methodToCall.invoke((Object)codeTemplates, args);
                } else if (methodToCall.getParameterTypes().length == 3) {
                    Object[] args = new Object[]{loc.openStream(), Boolean.FALSE, Boolean.FALSE};
                    methodToCall.invoke((Object)codeTemplates, args);
                } else {
                    Object[] args = new Object[]{loc.openStream(), Boolean.FALSE};
                    methodToCall.invoke((Object)codeTemplates, args);
                }
            }
            codeTemplates.save();
        }
        catch (Exception fnf) {
            AJDTEventTrace.generalEvent("Could not load aspectj code templates file");
            fnf.printStackTrace();
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.ajdtErrorHandler;
    }

    public static void logException(Throwable e) {
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        AspectJPlugin.getDefault().getLog().log(status);
    }

    public CompilerMonitor getCompilerMonitor() {
        return this.ajdtCompilerMonitor;
    }

    public ProjectProperties getAjdtProjectProperties() {
        return this.ajdtProjectProperties;
    }

    public org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter getAjdtBuildOptionsAdapter() {
        return this.ajdtBuildOptions;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void startup() throws CoreException {
        super.startup();
        this.display = Display.getDefault();
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new AspectJResourceChangeListener();
            AspectJPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        }
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return plugin.getWorkbench().getActiveWorkbenchWindow();
    }

    public Display getDisplay() {
        return this.display;
    }

    public AspectJTextTools getAspectJTextTools() {
        if (this.aspectJTextTools == null) {
            IPreferenceStore textToolPreferences = JavaPlugin.getDefault().getPreferenceStore();
            this.aspectJTextTools = new AspectJTextTools(textToolPreferences);
        }
        return this.aspectJTextTools;
    }

    public IProject getCurrentProject() {
        IProject current = null;
        if (this.currentProject != null) {
            current = this.currentProject;
        } else {
            IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen()) {
                    current = projects[i];
                    break;
                }
                ++i;
            }
        }
        return current;
    }

    public IResource getCurrentResource() {
        return this.currentResource;
    }

    public void setCurrentProject(IProject project) {
        this.currentProject = project;
    }

    public void setCurrentProject(String projectName) {
        boolean matched = false;
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getName().equals(projectName)) {
                this.currentProject = projects[i];
                matched = true;
                break;
            }
            ++i;
        }
        if (!matched) {
            this.getErrorHandler().handleWarning(String.valueOf(AspectJPlugin.getResourceString("bad.project")) + " " + projectName);
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        AspectJPreferencePage.initDefaults(store);
        AJCompilerPreferencePage.initDefaults(store);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    private void initDebugging() {
        if (this.isDebugging()) {
            System.out.println("AJP START: org.eclipse.ajdt.ui " + VERSION);
            isDebugging = true;
            String option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/builderDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP builderDebug ON");
                DEBUG_BUILDER = true;
            } else {
                System.out.println("AJP builderDebug OFF");
            }
            option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/compilerDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP compilerDebug ON");
                DEBUG_COMPILER = true;
            } else {
                System.out.println("AJP compilerDebug OFF");
            }
            option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/outlineDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP outlineDebug ON");
                DEBUG_OUTLINE = true;
            } else {
                System.out.println("AJP outlineDebug OFF");
            }
        }
    }

    public void selectionChanged(IWorkbenchPart iwp, ISelection is) {
        try {
            if (is instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)is;
                Object o = structuredSelection.getFirstElement();
                if (o != null) {
                    IJavaElement je;
                    if (o instanceof IResource) {
                        this.currentResource = (IResource)o;
                        this.currentProject = this.currentResource.getProject();
                    } else if (o instanceof IJavaElement && (je = (IJavaElement)o).getJavaProject() != null) {
                        this.currentResource = je.getUnderlyingResource();
                        this.currentProject = je.getJavaProject().getProject();
                    }
                }
            } else {
                boolean cfr_ignored_0 = is instanceof ITextSelection;
            }
        }
        catch (JavaModelException jme) {
            this.getErrorHandler().handleError("Exception in AspectJPlugin.selectionChanged processing", jme);
        }
    }

    public List getListOfConfigFilesForCurrentProject() {
        if (this.currentProject == null) {
            return null;
        }
        ArrayList allLstFiles = new ArrayList();
        try {
            IResource[] files = this.currentProject.members();
            this.getLstFiles(files, allLstFiles);
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Exception occurred whilst retrieving all .lst files in a project", ce);
        }
        return allLstFiles;
    }

    private void getLstFiles(IResource[] resource_list, List allLstFiles) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir.getName().endsWith(".lst") && !ir.getName().equals("default.lst")) {
                    allLstFiles.add(ir);
                }
                if (ir instanceof IContainer) {
                    this.getLstFiles(((IContainer)ir).members(), allLstFiles);
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Exception occurred whilst retrieiving all .lst files in a project", ce);
        }
    }
}

