/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.tests.AllAJPluginTests;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;

public class AspectJPluginTest
extends TestCase {
    public AspectJPluginTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetDefault() {
        AspectJPlugin p = AspectJPlugin.getDefault();
        Assert.assertNotNull((String)"AspectJPlugin default must be set", (Object)((Object)p));
        AspectJPlugin p2 = AspectJPlugin.getDefault();
        Assert.assertEquals((String)"AspectJPlugin must be a singleton", (Object)((Object)p), (Object)((Object)p2));
    }

    public void testDescriptor() {
        IPluginDescriptor desc = Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.ajdt.ui");
        Assert.assertNotNull((String)"Plugin descriptor must be available", (Object)desc);
    }

    public void testResourceBundle() {
        String value = AspectJPlugin.getResourceString("test.message");
        Assert.assertEquals((String)"Resource key lookup failed", (String)value, (String)"A test message");
        String key = "missing.key";
        Assert.assertEquals((String)"Missing resource key lookup failed", (String)key, (String)AspectJPlugin.getResourceString(key));
    }

    public void testProjectBuildFile() {
        AspectJPlugin p = AspectJPlugin.getDefault();
        p.setCurrentProject("Examples");
        IProject project = p.getCurrentProject();
        Assert.assertEquals((String)"Project should be set to 'Examples'", (String)"Examples", (String)project.getName());
        p.setCurrentProject("The unknown project");
        Assert.assertTrue((boolean)AllAJPluginTests.confirmWithUser("Did you see a warning dialog for the unknown project?\n(look behind this dialog! ;-))"));
        project = p.getCurrentProject();
        Assert.assertEquals((String)"Project should be set to 'Examples'", (String)"Examples", (String)project.getName());
    }

    public void testMultiBuildFilesInSingleProject() {
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        Assert.assertTrue((String)"Must be at least one project in workspace for this test", (projects.length > 0 ? 1 : 0) != 0);
        IProject p = projects[0];
        Assert.assertEquals((String)"Project should be set to 'Examples'", (String)"Examples", (String)p.getName());
        IResource defaultConfig = this.findRequiredResource(p, ".generated.lst");
        IResource customConfig1 = this.findRequiredResource(p, "custom1.lst");
        IResource customConfig2 = this.findRequiredResource(p, "custom2.lst");
        AspectJPlugin plugin = AspectJPlugin.getDefault();
        AspectJPlugin.setBuildConfigurationFile(p, defaultConfig);
        String config = AspectJPlugin.getBuildConfigurationFile(p);
        String workspaceLoc = AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String defaultConfigLoc = String.valueOf(workspaceLoc) + defaultConfig.getFullPath().toOSString();
        Assert.assertEquals((String)"Project should be using default config", (String)config, (String)defaultConfigLoc);
        AspectJPlugin.setBuildConfigurationFile(p, customConfig1);
        config = AspectJPlugin.getBuildConfigurationFile(p);
        Assert.assertEquals((String)"Project should be using custom1.lst", (String)config, (String)(String.valueOf(workspaceLoc) + customConfig1.getFullPath().toOSString()));
        AspectJPlugin.setBuildConfigurationFile(p, customConfig2);
        config = AspectJPlugin.getBuildConfigurationFile(p);
        Assert.assertEquals((String)"Project should be using custom2.lst", (String)config, (String)(String.valueOf(workspaceLoc) + customConfig2.getFullPath().toOSString()));
    }

    public void testMultiBuildFilesInMultiProjects() {
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        Assert.assertTrue((String)"Must be at least two projects in workspace for this test", (projects.length >= 2 ? 1 : 0) != 0);
        IProject p1 = projects[0];
        Assert.assertEquals((String)"Project one should be set to 'Examples'", (String)"Examples", (String)p1.getName());
        IProject p2 = projects[1];
        Assert.assertEquals((String)"Project one should be set to 'More Examples'", (String)"More Examples", (String)p2.getName());
        IResource customConfig1 = this.findRequiredResource(p1, "custom1.lst");
        IResource customConfig3 = this.findRequiredResource(p2, "custom3.lst");
        AspectJPlugin plugin = AspectJPlugin.getDefault();
        AspectJPlugin.setBuildConfigurationFile(p1, customConfig1);
        String config = AspectJPlugin.getBuildConfigurationFile(p1);
        String workspaceLoc = AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String configLoc = String.valueOf(workspaceLoc) + customConfig1.getFullPath().toOSString();
        Assert.assertEquals((String)"Project should be using custom config1", (String)config, (String)configLoc);
        AspectJPlugin.setBuildConfigurationFile(p2, customConfig3);
        config = AspectJPlugin.getBuildConfigurationFile(p2);
        configLoc = String.valueOf(workspaceLoc) + customConfig3.getFullPath().toOSString();
        Assert.assertEquals((String)"Project should be using custom config3", (String)config, (String)configLoc);
        config = AspectJPlugin.getBuildConfigurationFile(p1);
        configLoc = String.valueOf(workspaceLoc) + customConfig1.getFullPath().toOSString();
        Assert.assertEquals((String)"Project should be using custom config1", (String)config, (String)configLoc);
    }

    private IResource findRequiredResource(IProject p, String fName) {
        IResource retVal = null;
        IResource[] projectMembers = null;
        try {
            projectMembers = p.members();
        }
        catch (CoreException cEx) {
            Assert.fail((String)("Exception listing project contents: " + cEx.getMessage()));
        }
        int i = 0;
        while (i < projectMembers.length) {
            IResource resource = projectMembers[i];
            if (resource.getName().endsWith(fName)) {
                retVal = resource;
                break;
            }
            ++i;
        }
        if (retVal == null) {
            Assert.fail((String)("Missing required project resource: " + fName + "in project " + p.getName()));
        }
        return retVal;
    }
}

