/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.visualiser.AJDTMarkupProvider;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMember;
import org.eclipse.contribution.visualiser.jdtimpl.JDTContentProvider;
import org.eclipse.contribution.visualiser.jdtimpl.JDTGroup;
import org.eclipse.contribution.visualiser.jdtimpl.JDTMember;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class AJDTContentProvider
extends JDTContentProvider {
    List currentGroups;
    List currentMembers;

    public List getAllGroups() {
        if (this.currentGroups != null) {
            return this.currentGroups;
        }
        this.updateData();
        return this.currentGroups;
    }

    public List getAllMembers() {
        if (this.currentMembers != null) {
            return this.currentMembers;
        }
        this.updateData();
        return this.currentMembers;
    }

    public void selectionChanged(IWorkbenchPart iwp, ISelection is) {
        IStructuredSelection structuredSelection;
        Object o;
        if (!ProviderManager.getContentProvider().equals((Object)this)) {
            return;
        }
        boolean updateRequired = false;
        if (is instanceof IStructuredSelection && (o = (structuredSelection = (IStructuredSelection)is).getFirstElement()) != null && o instanceof IJavaElement) {
            IJavaElement je = (IJavaElement)o;
            if (this.currentlySelectedJE == je) {
                return;
            }
            this.currentlySelectedJE = je;
            updateRequired = true;
            if (je.getJavaProject() != null) {
                this.setCurrentProject(je.getJavaProject());
            }
        }
        if (updateRequired) {
            AJDTEventTrace.generalEvent("AJDTContentProvider.selectionChanged(): Marking visualiser content as out of date");
            this.currentGroups = null;
            this.currentMembers = null;
            VisualiserPlugin.refresh();
        }
    }

    private void updateData() {
        if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
            ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetMarkups();
        }
        long stime = System.currentTimeMillis();
        this.currentGroups = new ArrayList();
        this.currentMembers = new ArrayList();
        try {
            if (this.currentlySelectedJE instanceof IJavaProject) {
                IPackageFragment[] packageFragments = ((IJavaProject)this.currentlySelectedJE).getPackageFragments();
                int i = 0;
                while (i < packageFragments.length) {
                    if (!packageFragments[i].isReadOnly()) {
                        boolean defaultPackage = packageFragments[i].isDefaultPackage();
                        JDTGroup group = new JDTGroup(packageFragments[i].getElementName());
                        if (defaultPackage) {
                            group.setName("(default package)");
                            group.setTooltip("(default package)");
                        }
                        List classes = AspectVisualiserPlugin.getDefault().getAllClasses(packageFragments[i]);
                        Iterator iter = classes.iterator();
                        while (iter.hasNext()) {
                            Object[] info = (Object[])iter.next();
                            IResource res = (IResource)info[0];
                            IJavaElement jEl = JavaCore.create((IResource)res);
                            if (res == null) continue;
                            String name = res.getName();
                            name = name.substring(0, name.lastIndexOf("."));
                            JDTMember member = new JDTMember(name, jEl);
                            member.setSize(((Integer)info[1]).intValue());
                            group.add((IMember)member);
                            this.currentMembers.add(member);
                            if (!defaultPackage) continue;
                            ((SimpleMember)member).setFullName(member.getName());
                        }
                        if (group.getSize() > 0) {
                            this.currentGroups.add(group);
                        }
                    }
                    ++i;
                }
            } else if (this.currentlySelectedJE instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)this.currentlySelectedJE;
                boolean defaultPackage = packageFragment.isDefaultPackage();
                JDTGroup group = new JDTGroup(packageFragment.getElementName());
                if (defaultPackage) {
                    group.setName("(default package)");
                    group.setTooltip("(default package)");
                }
                List classes = AspectVisualiserPlugin.getDefault().getAllClasses(packageFragment);
                Iterator iter = classes.iterator();
                while (iter.hasNext()) {
                    Object[] info = (Object[])iter.next();
                    IResource res = (IResource)info[0];
                    IJavaElement jEl = JavaCore.create((IResource)res);
                    String name = res.getName();
                    name = name.substring(0, name.lastIndexOf("."));
                    JDTMember member = new JDTMember(name, jEl);
                    member.setSize(((Integer)info[1]).intValue());
                    group.add((IMember)member);
                    this.currentMembers.add(member);
                    if (!defaultPackage) continue;
                    ((SimpleMember)member).setFullName(member.getName());
                }
                if (group.getSize() > 0) {
                    this.currentGroups.add(group);
                }
            } else if (this.currentlySelectedJE instanceof ICompilationUnit) {
                List classes = AspectVisualiserPlugin.getDefault().getAllClasses((ICompilationUnit)this.currentlySelectedJE);
                IPackageFragment packageFrag = (IPackageFragment)((ICompilationUnit)this.currentlySelectedJE).getParent();
                boolean defaultPackage = packageFrag.isDefaultPackage();
                JDTGroup group = new JDTGroup(packageFrag.getElementName());
                if (defaultPackage) {
                    group.setName("(default package)");
                    group.setTooltip("(default package)");
                }
                Iterator iter = classes.iterator();
                while (iter.hasNext()) {
                    Object[] info = (Object[])iter.next();
                    IResource res = (IResource)info[0];
                    IJavaElement jEl = JavaCore.create((IResource)res);
                    String name = res.getName();
                    name = name.substring(0, name.lastIndexOf("."));
                    JDTMember member = new JDTMember(name, jEl);
                    member.setSize(((Integer)info[1]).intValue());
                    group.add((IMember)member);
                    this.currentMembers.add(member);
                    if (!defaultPackage) continue;
                    ((SimpleMember)member).setFullName(member.getName());
                }
                if (group.getSize() > 0) {
                    this.currentGroups.add(group);
                }
            }
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        long etime = System.currentTimeMillis();
        AJDTEventTrace.generalEvent("AJDTContentProvider.updateData() executed - took " + (etime - stime) + "ms");
    }

    protected void setCurrentProject(IJavaProject newProject) {
        if (this.currentProject == null || !this.currentProject.equals(newProject)) {
            if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
                ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetColours();
            }
            this.currentProject = newProject;
        }
    }

    public void reset() {
        this.currentGroups = null;
        this.currentMembers = null;
    }
}

