/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.ajdt.ui.visualiser.AJDTContentProvider;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.ajdt.ui.visualiser.NewVisualiserUtils;
import org.eclipse.contribution.visualiser.core.MarkupUtils;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.jdtimpl.JDTMember;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class AJDTMarkupProvider
extends SimpleMarkupProvider {
    public List getMemberMarkups(IMember member) {
        IJavaProject jp;
        List markupList;
        if (this.markups != null && this.markups.containsKey(member.getFullname()) && (markupList = (List)this.markups.get(member.getFullname())) != null) {
            return markupList;
        }
        long stime = System.currentTimeMillis();
        ArrayList<Stripe> stripeList = new ArrayList<Stripe>();
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider && (jp = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject()) != null) {
            List list = NewVisualiserUtils.getMarkupInfo(member, jp.getProject());
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Map map = (Map)iter.next();
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer lineNum = (Integer)iterator.next();
                    List aspects = (List)map.get(lineNum);
                    Stripe stripe = new Stripe(aspects, lineNum.intValue(), 1);
                    stripeList.add(stripe);
                    this.addMarkup(member.getFullname(), stripe);
                }
            }
        }
        long mtime = System.currentTimeMillis();
        MarkupUtils.processStripes(stripeList);
        long etime = System.currentTimeMillis();
        return stripeList;
    }

    public SortedSet getAllMarkupKinds() {
        IJavaProject jp;
        TreeSet<String> kinds = new TreeSet<String>();
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider && (jp = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject()) != null) {
            Set aspects = AspectVisualiserPlugin.getDefault().getAllAspects(jp);
            Iterator iter = aspects.iterator();
            while (iter.hasNext()) {
                IResource aspectRes = (IResource)iter.next();
                String name = aspectRes.getName();
                name = name.substring(0, name.lastIndexOf("."));
                kinds.add(name);
            }
        }
        if (kinds.size() > 0) {
            return kinds;
        }
        return null;
    }

    public boolean processMouseclick(IMember member, Stripe stripe, String exactKind, int buttonClicked) {
        if (buttonClicked == 1) {
            IJavaElement jEl;
            if (member instanceof JDTMember && (jEl = ((JDTMember)member).getResource()) != null) {
                JDTUtils.openInEditor((IResource)jEl.getResource(), (int)stripe.getOffset());
            }
            return false;
        }
        return true;
    }

    protected void resetMarkups() {
        this.markups = new Hashtable();
    }
}

