/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.ajdt.ui.visualiser.menu.Menu;
import org.eclipse.ajdt.ui.visualiser.views.AV;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class AspectVisualiserPlugin {
    private static AspectVisualiserPlugin plugin;
    private ResourceBundle resourceBundle;
    public AV visualiser;
    public Menu menu;
    String lastLoadedConfigFile = null;
    IProject project;

    public AspectVisualiserPlugin(IPluginDescriptor descriptor) {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("aspectVisualiser.aspectVisualiserPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static AspectVisualiserPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AspectVisualiserPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void refreshView() {
        if (this.visualiser != null) {
            IJavaProject p = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
            this.visualiser.refresh(p);
        }
    }

    public void setVisualiser(AV visualiser) {
        this.visualiser = visualiser;
    }

    public void removeVisualiser() {
        this.visualiser = null;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public void removeMenu() {
        this.menu = null;
    }

    public Set getAllAspects(IJavaProject JP) {
        this.project = JP.getProject();
        this.initialiseAJDE();
        List packages = StructureModelUtil.getPackagesInModel();
        HashSet aspects = new HashSet();
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] progNodes = (Object[])it.next();
            IProgramElement packageNode = (IProgramElement)progNodes[0];
            Set temp = StructureModelUtil.getAspectsAffectingPackage(packageNode);
            aspects.addAll(temp);
        }
        return this.changeSet(aspects);
    }

    public List getAllClasses(IJavaProject JP) {
        LinkedList<Object[]> returningClasses = new LinkedList<Object[]>();
        this.project = JP.getProject();
        this.initialiseAJDE();
        List unsortedPackages = StructureModelUtil.getPackagesInModel();
        List packages = this.sortArray(unsortedPackages);
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            IProgramElement packageNode = (IProgramElement)o[0];
            List unsortedFiles = StructureModelUtil.getFilesInPackage(packageNode);
            List files = this.sortElements(unsortedFiles);
            Iterator it2 = files.iterator();
            while (it2.hasNext()) {
                IProgramElement progNode = (IProgramElement)it2.next();
                try {
                    ISourceLocation isl = progNode.getSourceLocation();
                    String fullpath = isl.getSourceFile().getAbsolutePath();
                    Map lineAdviceMap = StructureModelUtil.getLinesToAspectMap(fullpath);
                    Object[] entry = new Object[3];
                    IResource res = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(fullpath);
                    int endLine = isl.getEndLine();
                    entry[0] = res;
                    entry[1] = new Integer(endLine);
                    entry[2] = this.changeMap(lineAdviceMap, 0);
                    returningClasses.add(entry);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return returningClasses;
    }

    public List getAllClasses(IPackageFragment PF) {
        IJavaProject JP = PF.getJavaProject();
        this.project = JP.getProject();
        this.initialiseAJDE();
        LinkedList<Object[]> returningClasses = new LinkedList<Object[]>();
        List packages = StructureModelUtil.getPackagesInModel();
        String pf_string = PF.toString();
        boolean defaultPackage = false;
        String test = "";
        if (pf_string.startsWith("<default>")) {
            defaultPackage = true;
        } else {
            int end = pf_string.indexOf("[");
            test = PF.toString().substring(0, end - 1);
            if (test.indexOf("(not open)") != -1) {
                test = test.substring(0, test.length() - 10).trim();
            }
        }
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            if ((!defaultPackage || !o[1].equals("<default>")) && !test.equals(o[1])) continue;
            IProgramElement packageNode = (IProgramElement)o[0];
            List unsortedFiles = StructureModelUtil.getFilesInPackage(packageNode);
            List files = this.sortElements(unsortedFiles);
            int j = 0;
            while (j < files.size()) {
                try {
                    IProgramElement fileNode = (IProgramElement)files.get(j);
                    ISourceLocation isl = fileNode.getSourceLocation();
                    String fullpath = isl.getSourceFile().getAbsolutePath();
                    Map lineAdviceMap = StructureModelUtil.getLinesToAspectMap(fullpath);
                    Object[] entry = new Object[3];
                    IResource res = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(fullpath);
                    int endLine = isl.getEndLine();
                    entry[0] = res;
                    entry[1] = new Integer(endLine);
                    entry[2] = this.changeMap(lineAdviceMap, 0);
                    returningClasses.add(entry);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                ++j;
            }
        }
        return returningClasses;
    }

    public List getAllClasses(ICompilationUnit CU) {
        this.project = CU.getJavaProject().getProject();
        this.initialiseAJDE();
        LinkedList<Object[]> returningClasses = new LinkedList<Object[]>();
        List packages = StructureModelUtil.getPackagesInModel();
        String cu_parent = CU.getParent().toString();
        int end = cu_parent.startsWith("<default>") ? cu_parent.substring(1).indexOf("[") + 1 : cu_parent.indexOf("[");
        String test = cu_parent.substring(0, end - 1);
        if (test.indexOf("(not open)") != -1) {
            test = test.substring(0, test.length() - 10).trim();
        }
        String path = CU.getPath().toString();
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            if (!test.equals(o[1])) continue;
            IProgramElement packageNode = (IProgramElement)o[0];
            List files = StructureModelUtil.getFilesInPackage(packageNode);
            Iterator it2 = files.iterator();
            while (it2.hasNext()) {
                IProgramElement file = (IProgramElement)it2.next();
                ISourceLocation isl = file.getSourceLocation();
                String testpath = isl.getSourceFile().getAbsolutePath();
                if (!(testpath = testpath.replace('\\', '/')).endsWith(path)) continue;
                try {
                    String fullpath = isl.getSourceFile().getAbsolutePath();
                    Map lineAdviceMap = StructureModelUtil.getLinesToAspectMap(fullpath);
                    Object[] entry = new Object[3];
                    IResource res = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(fullpath);
                    int endLine = isl.getEndLine();
                    entry[0] = res;
                    entry[1] = new Integer(endLine);
                    entry[2] = this.changeMap(lineAdviceMap, 0);
                    returningClasses.add(entry);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return returningClasses;
    }

    public List getAllPackages(IJavaProject JP) {
        this.project = JP.getProject();
        this.initialiseAJDE();
        LinkedList<Object[]> returningPackages = new LinkedList<Object[]>();
        List packages = StructureModelUtil.getPackagesInModel();
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            IProgramElement progNode = (IProgramElement)o[0];
            int start = 0;
            HashMap map = new HashMap();
            List files = StructureModelUtil.getFilesInPackage(progNode);
            files = this.sortElements(files);
            String path = null;
            int j = 0;
            while (j < files.size()) {
                IProgramElement file = (IProgramElement)files.get(j);
                ISourceLocation isl = file.getSourceLocation();
                path = isl.getSourceFile().getAbsolutePath();
                Map fileMap = StructureModelUtil.getLinesToAspectMap(path);
                fileMap = this.changeMap(fileMap, start);
                map.putAll(fileMap);
                start += isl.getEndLine();
                ++j;
            }
            if (path == null) continue;
            Object[] packageObj = new Object[3];
            int last = path.lastIndexOf(File.separator);
            path = new String(path.substring(0, last));
            IResource resource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(path);
            packageObj[0] = resource;
            packageObj[1] = new Integer(start);
            packageObj[2] = map;
            returningPackages.add(packageObj);
        }
        return returningPackages;
    }

    public List getAllPackages(IPackageFragment PF) {
        IJavaProject JP = PF.getJavaProject();
        this.project = JP.getProject();
        this.initialiseAJDE();
        LinkedList<Object[]> returningPackages = new LinkedList<Object[]>();
        List packages = StructureModelUtil.getPackagesInModel();
        int end = PF.toString().indexOf("[");
        String test = PF.toString().substring(0, end - 1);
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] Obj = (Object[])it.next();
            String testpackage = (String)Obj[1];
            if (!test.equals(testpackage)) continue;
            IProgramElement progNode = (IProgramElement)Obj[0];
            int start = 0;
            HashMap map = new HashMap();
            List files = StructureModelUtil.getFilesInPackage(progNode);
            files = this.sortElements(files);
            String path = null;
            int j = 0;
            while (j < files.size()) {
                IProgramElement file = (IProgramElement)files.get(j);
                ISourceLocation isl = file.getSourceLocation();
                path = isl.getSourceFile().getAbsolutePath();
                Map fileMap = StructureModelUtil.getLinesToAspectMap(path);
                fileMap = this.changeMap(fileMap, start);
                map.putAll(fileMap);
                start += isl.getEndLine();
                ++j;
            }
            if (path == null) continue;
            Object[] packageObj = new Object[3];
            int last = path.lastIndexOf(File.separator);
            path = new String(path.substring(0, last));
            IResource resource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(path);
            packageObj[0] = resource;
            packageObj[1] = new Integer(start);
            packageObj[2] = map;
            returningPackages.add(packageObj);
        }
        return returningPackages;
    }

    public List getSelectedClasses(List packages) {
        ProjectProperties prop = AspectJPlugin.getDefault().getAjdtProjectProperties();
        LinkedList<Object[]> returningClasses = new LinkedList<Object[]>();
        Iterator it = packages.iterator();
        block4: while (it.hasNext()) {
            try {
                IResource res = (IResource)it.next();
                IJavaProject JP = JavaCore.create((IProject)res.getProject());
                IClasspathEntry[] classpathArray = JP.getRawClasspath();
                IClasspathEntry classpath = classpathArray[0];
                String clazzpath = classpath.toString();
                int index = clazzpath.indexOf(91);
                clazzpath = new String(clazzpath.substring(0, index));
                String respath = res.getFullPath().toString();
                String path = clazzpath.endsWith("/") ? respath.substring(clazzpath.length()) : respath.substring(clazzpath.length() + 1);
                String packagename = new String(path.replace('/', '.'));
                List modelpackages = StructureModelUtil.getPackagesInModel();
                Iterator it2 = modelpackages.iterator();
                while (it2.hasNext()) {
                    Object[] o = (Object[])it2.next();
                    String testname = (String)o[1];
                    if (!testname.equals(packagename)) continue;
                    IProgramElement packageNode = (IProgramElement)o[0];
                    List unsortedFiles = StructureModelUtil.getFilesInPackage(packageNode);
                    List files = this.sortElements(unsortedFiles);
                    int j = 0;
                    while (j < files.size()) {
                        try {
                            IProgramElement fileNode = (IProgramElement)files.get(j);
                            ISourceLocation isl = fileNode.getSourceLocation();
                            String fullpath = isl.getSourceFile().getAbsolutePath();
                            Map lineAdviceMap = StructureModelUtil.getLinesToAspectMap(fullpath);
                            Object[] entry = new Object[3];
                            IResource resource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(fullpath);
                            int endLine = isl.getEndLine();
                            entry[0] = resource;
                            entry[1] = new Integer(endLine);
                            entry[2] = this.changeMap(lineAdviceMap, 0);
                            returningClasses.add(entry);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        ++j;
                    }
                    continue block4;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return returningClasses;
    }

    public List getSelectedPackages(List classes) {
        LinkedList<Object[]> returningPackages = new LinkedList<Object[]>();
        TreeSet<String> temp = new TreeSet<String>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            try {
                IResource res = (IResource)it.next();
                IJavaProject JP = JavaCore.create((IProject)res.getProject());
                IClasspathEntry[] classpathArray = JP.getRawClasspath();
                IClasspathEntry classpath = classpathArray[0];
                String clazzpath = classpath.toString();
                int index = clazzpath.indexOf(91);
                clazzpath = new String(clazzpath.substring(0, index));
                IPath respath = res.getFullPath();
                respath = respath.removeLastSegments(1);
                String path = clazzpath.endsWith("/") ? respath.toString().substring(clazzpath.length()) : respath.toString().substring(clazzpath.length() + 1);
                String packagename = new String(path.replace('/', '.'));
                temp.add(packagename);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        List packagez = StructureModelUtil.getPackagesInModel();
        Iterator it2 = packagez.iterator();
        while (it2.hasNext()) {
            Object[] Obj = (Object[])it2.next();
            String testpackage = (String)Obj[1];
            if (!temp.contains(testpackage)) continue;
            IProgramElement progNode = (IProgramElement)Obj[0];
            int start = 0;
            HashMap map = new HashMap();
            List files = StructureModelUtil.getFilesInPackage(progNode);
            files = this.sortElements(files);
            String path = null;
            int j = 0;
            while (j < files.size()) {
                IProgramElement file = (IProgramElement)files.get(j);
                ISourceLocation isl = file.getSourceLocation();
                path = isl.getSourceFile().getAbsolutePath();
                Map fileMap = StructureModelUtil.getLinesToAspectMap(path);
                fileMap = this.changeMap(fileMap, start);
                map.putAll(fileMap);
                start += isl.getEndLine();
                ++j;
            }
            if (path == null) continue;
            Object[] packageObj = new Object[3];
            int last = path.lastIndexOf(File.separator);
            path = new String(path.substring(0, last));
            IResource resource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(path);
            packageObj[0] = resource;
            packageObj[1] = new Integer(start);
            packageObj[2] = map;
            returningPackages.add(packageObj);
        }
        return returningPackages;
    }

    private Set changeSet(Set oldset) {
        HashSet<IResource> newset = new HashSet<IResource>();
        Iterator it = oldset.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            List aspects = (List)obj;
            Iterator iterator2 = aspects.iterator();
            while (iterator2.hasNext()) {
                Object progNodes = iterator2.next();
                IProgramElement progNode = (IProgramElement)progNodes;
                String path = progNode.getSourceLocation().getSourceFile().getAbsolutePath();
                IResource resource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(path);
                newset.add(resource);
            }
        }
        return newset;
    }

    private Map changeMap(Map oldmap, int startline) {
        HashMap newmap = new HashMap();
        Set keys = oldmap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Integer line = (Integer)it.next();
            Object o = oldmap.get(line);
            List oldaspects = (List)o;
            LinkedList<String> newaspects = new LinkedList<String>();
            Iterator iterator2 = oldaspects.iterator();
            while (iterator2.hasNext()) {
                IProgramElement theaspect = (IProgramElement)iterator2.next();
                String fullpath = theaspect.getSourceLocation().getSourceFile().getAbsolutePath();
                Path path = new Path(fullpath);
                String aspectname = path.removeFileExtension().lastSegment();
                newaspects.add(aspectname);
            }
            if (newaspects.isEmpty()) continue;
            line = new Integer(line + startline);
            newmap.put(line, newaspects);
        }
        return newmap;
    }

    private void initialiseAJDE() {
        String configFile = AspectJPlugin.getBuildConfigurationFile(this.project);
        if (!configFile.equals(this.lastLoadedConfigFile)) {
            AJDTEventTrace.generalEvent("initialiseAJDE: switching configs - from:" + this.lastLoadedConfigFile + " to:" + configFile);
            Ajde.getDefault().getConfigurationManager().setActiveConfigFile(configFile);
            this.lastLoadedConfigFile = configFile;
        }
    }

    private List sortElements(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortingComparator comparator = new SortingComparator();
        Arrays.sort(temp, comparator);
        List<Object> newResources = Arrays.asList(temp);
        return newResources;
    }

    private List sortArray(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortArrayComparator comparator = new SortArrayComparator();
        Arrays.sort(temp, comparator);
        List<Object> newElements = Arrays.asList(temp);
        return newElements;
    }

    private class SortingComparator
    implements Comparator {
        SortingComparator() {
        }

        public int compare(Object o1, Object o2) {
            IProgramElement p1 = (IProgramElement)o1;
            IProgramElement p2 = (IProgramElement)o2;
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }

    private class SortArrayComparator
    implements Comparator {
        SortArrayComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object[] array1 = (Object[])o1;
            Object[] array2 = (Object[])o2;
            IProgramElement p1 = (IProgramElement)array1[0];
            IProgramElement p2 = (IProgramElement)array2[0];
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }
}

