/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;

public class NewVisualiserUtils {
    private static IProject project;
    private static Object lastLoadedConfigFile;

    public static List getMarkupInfo(IMember member, IProject project) {
        NewVisualiserUtils.project = project;
        LinkedList<Map> returningList = new LinkedList<Map>();
        List packages = StructureModelUtil.getPackagesInModel();
        String parent = member.getContainingGroup().getFullname();
        boolean defaultPackage = parent.startsWith("(default");
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            if (!parent.equals(o[1]) && (!defaultPackage || !o[1].equals("<default>"))) continue;
            IProgramElement packageNode = (IProgramElement)o[0];
            List files = StructureModelUtil.getFilesInPackage(packageNode);
            Iterator it2 = files.iterator();
            while (it2.hasNext()) {
                IProgramElement file = (IProgramElement)it2.next();
                ISourceLocation isl = file.getSourceLocation();
                String testpath = isl.getSourceFile().getAbsolutePath();
                if (testpath.endsWith(".java")) {
                    testpath = testpath.substring(0, testpath.length() - 5);
                } else if (testpath.endsWith(".aj")) {
                    testpath = testpath.substring(0, testpath.length() - 3);
                }
                if (!testpath.endsWith(String.valueOf(File.separator) + member.getName())) continue;
                try {
                    String fullpath = isl.getSourceFile().getAbsolutePath();
                    Map lineAdviceMap = StructureModelUtil.getLinesToAspectMap(fullpath);
                    Map map = NewVisualiserUtils.changeMap(lineAdviceMap, 0);
                    returningList.add(map);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return returningList;
    }

    private static Map changeMap(Map oldmap, int startline) {
        HashMap newmap = new HashMap();
        Set keys = oldmap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Integer line = (Integer)it.next();
            Object o = oldmap.get(line);
            List oldaspects = (List)o;
            LinkedList<String> newaspects = new LinkedList<String>();
            Iterator iterator2 = oldaspects.iterator();
            while (iterator2.hasNext()) {
                IProgramElement theaspect = (IProgramElement)iterator2.next();
                String fullpath = theaspect.getSourceLocation().getSourceFile().getAbsolutePath();
                Path path = new Path(fullpath);
                String aspectname = path.removeFileExtension().lastSegment();
                newaspects.add(aspectname);
            }
            if (newaspects.isEmpty()) continue;
            line = new Integer(line + startline);
            newmap.put(line, newaspects);
        }
        return newmap;
    }
}

