/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class Menu
extends ViewPart {
    Button[] buttons;
    Button[] checkboxes;
    Label[] labels;
    Shell[] shells;
    ColorDialog[] colorDialogs;
    Image[] images;
    Color[] colors;
    SelectionAdapter selectionListener;
    MouseListener mouseListener;
    MouseListener labelListener;
    Composite canvas;
    ScrolledComposite scrollpane;
    GridLayout layout = new GridLayout(3, false);
    AspectVisualiserPlugin plugin = AspectVisualiserPlugin.getDefault();
    private static Map colourMemory = new HashMap();
    private static Map availableColours = new HashMap();

    public Menu() {
        this.plugin.setMenu(this);
    }

    private void drawImage(Image image, Color color) {
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        Rectangle bounds = image.getBounds();
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        gc.dispose();
    }

    public void createPartControl(Composite parent) {
        this.scrollpane = new ScrolledComposite(parent, 2816);
        this.canvas = new Composite((Composite)this.scrollpane, 0);
        this.scrollpane.setContent((Control)this.canvas);
        this.canvas.setLayout((Layout)this.layout);
        this.labelListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                int i = 0;
                while (i < Menu.this.labels.length) {
                    if ((Label)e.getSource() == Menu.this.labels[i]) {
                        Menu.this.plugin.visualiser.openAspectSource(i);
                        return;
                    }
                    ++i;
                }
            }
        };
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    Button button = (Button)e.getSource();
                    int location = 0;
                    int j = 0;
                    while (j < Menu.this.buttons.length) {
                        if (Menu.this.buttons[j].equals(button)) {
                            location = j;
                        }
                        ++j;
                    }
                    RGB rgb = Menu.this.colorDialogs[location].open();
                    if (rgb == null) {
                        return;
                    }
                    Menu.this.colors[location] = new Color((Device)Menu.this.buttons[location].getDisplay(), rgb);
                    Image image = Menu.this.buttons[location].getImage();
                    Menu.this.drawImage(image, Menu.this.colors[location]);
                    Menu.this.buttons[location].setImage(image);
                    if (Menu.this.plugin.visualiser != null) {
                        Color[] addColors = new Color[Menu.this.colors.length];
                        int i = 0;
                        while (i < Menu.this.colors.length) {
                            if (Menu.this.checkboxes[i].getSelection()) {
                                addColors[i] = Menu.this.colors[i];
                            }
                            ++i;
                        }
                        Menu.this.plugin.visualiser.draw(addColors);
                    }
                }
            }
        };
        this.mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (Menu.this.plugin.visualiser != null) {
                    Color[] addColors = new Color[Menu.this.colors.length];
                    int i = 0;
                    while (i < Menu.this.colors.length) {
                        if (Menu.this.checkboxes[i].getSelection()) {
                            addColors[i] = Menu.this.colors[i];
                        }
                        ++i;
                    }
                    Menu.this.plugin.visualiser.draw(addColors);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
    }

    public void addAspects(IJavaProject project, Vector aspects) {
        this.clearCanvas();
        this.buttons = new Button[aspects.size()];
        this.checkboxes = new Button[aspects.size()];
        this.labels = new Label[aspects.size()];
        this.shells = new Shell[aspects.size()];
        this.images = new Image[aspects.size()];
        this.colorDialogs = new ColorDialog[aspects.size()];
        this.colors = new Color[aspects.size()];
        int i = 0;
        while (i < aspects.size()) {
            int imageSize = 12;
            this.colors[i] = this.getColorFor(project, (String)aspects.elementAt(i));
            this.buttons[i] = new Button(this.canvas, 8);
            this.shells[i] = this.buttons[i].getShell();
            this.colorDialogs[i] = new ColorDialog(this.shells[i]);
            Display display = this.shells[i].getDisplay();
            this.images[i] = new Image((Device)display, imageSize, imageSize);
            this.buttons[i].setImage(this.images[i]);
            this.buttons[i].addSelectionListener((SelectionListener)this.selectionListener);
            Image image = this.buttons[i].getImage();
            this.drawImage(image, this.colors[i]);
            this.buttons[i].setImage(image);
            this.checkboxes[i] = new Button(this.canvas, 32);
            this.checkboxes[i].addMouseListener(this.mouseListener);
            this.checkboxes[i].setSelection(true);
            this.labels[i] = new Label(this.canvas, 0);
            this.labels[i].setText((String)aspects.elementAt(i));
            this.labels[i].addMouseListener(this.labelListener);
            ++i;
        }
        this.canvas.layout();
        this.canvas.setSize(this.canvas.computeSize(-1, -1, true));
        if (this.plugin.visualiser != null) {
            this.plugin.visualiser.draw(this.colors);
        }
    }

    private Color getColor(int i) {
        switch (i) {
            case 0: {
                return ColorConstants.red;
            }
            case 1: {
                return ColorConstants.blue;
            }
            case 2: {
                return ColorConstants.yellow;
            }
            case 3: {
                return ColorConstants.green;
            }
            case 4: {
                return ColorConstants.darkBlue;
            }
            case 5: {
                return ColorConstants.cyan;
            }
            case 6: {
                return ColorConstants.orange;
            }
            case 7: {
                return ColorConstants.lightBlue;
            }
            case 8: {
                return ColorConstants.darkGreen;
            }
            case 9: {
                return ColorConstants.darkGray;
            }
        }
        return ColorConstants.gray;
    }

    private Color getColorFor(IJavaProject p, String aspect) {
        Color aspectColour;
        String key = new String(p + ":" + aspect);
        if (colourMemory.containsKey(key)) {
            aspectColour = (Color)colourMemory.get(key);
        } else {
            aspectColour = this.getNextColourFor(p);
            colourMemory.put(key, aspectColour);
        }
        return aspectColour;
    }

    private Color getNextColourFor(IJavaProject p) {
        List colours;
        Color c = ColorConstants.gray;
        if (!availableColours.containsKey(p.toString())) {
            ArrayList<Color> colourList = new ArrayList<Color>();
            colourList.add(ColorConstants.red);
            colourList.add(ColorConstants.blue);
            colourList.add(ColorConstants.yellow);
            colourList.add(ColorConstants.green);
            colourList.add(ColorConstants.darkBlue);
            colourList.add(ColorConstants.cyan);
            colourList.add(ColorConstants.orange);
            colourList.add(ColorConstants.lightBlue);
            colourList.add(ColorConstants.darkGreen);
            colourList.add(ColorConstants.darkGray);
            availableColours.put(p.toString(), colourList);
        }
        if (!(colours = (List)availableColours.get(p.toString())).isEmpty()) {
            c = (Color)colours.get(0);
            colours.remove(0);
        }
        return c;
    }

    private void clearCanvas() {
        Control[] children = this.canvas.getChildren();
        if (children.length > 0) {
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.plugin.removeMenu();
    }
}

