/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser.views;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.ajdt.ui.visualiser.views.AspectDrawing;
import org.eclipse.ajdt.ui.visualiser.views.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class AV
extends ViewPart
implements ISelectionListener {
    AspectVisualiserPlugin plugin = AspectVisualiserPlugin.getDefault();
    AspectDrawing aspectDrawing = new AspectDrawing();
    private Action package_view;
    private Action class_view;
    private Action sub_select;
    private Action doubleClickAction;
    private Action limit;
    private Action zoom_in;
    private Action zoom_out;
    private IWorkbenchPart part;
    private ISelection sel;
    boolean in_package_view = false;
    boolean in_sub_select_mode = false;
    boolean limit_mode = false;
    private Object nowShowing = null;
    Canvas canvas;
    Vector vector;
    Vector elements;
    Vector aspects;
    Color[] colors;
    Vector names;
    Vector tooltips;
    Map[] map;
    public boolean justOpenedFile = false;
    Listener canvasListener;
    Set aspectSet;
    List list;
    Rectangle viewsize;

    public AV() {
        this.plugin.setVisualiser(this);
    }

    public void createPartControl(Composite parent) {
        this.canvas = new Canvas(parent, 0);
        this.vector = new Vector();
        this.elements = new Vector();
        this.aspects = new Vector();
        this.names = new Vector();
        this.tooltips = new Vector();
        this.makeActions();
        this.class_view.setChecked(true);
        this.zoom_out.setEnabled(false);
        this.hookContextMenu();
        this.contributeToActionBars();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.canvasListener = new Listener(){

            public void handleEvent(Event e) {
                int location = AV.this.aspectDrawing.location;
                if (!AV.this.in_package_view) {
                    IMarker marker = location != -1 ? AV.this.getMarker(location) : AV.this.getMarker(AV.this.aspectDrawing.classNum, AV.this.aspectDrawing.lineNum);
                    if (marker != null) {
                        try {
                            IDE.openEditor((IWorkbenchPage)AV.this.part.getSite().getWorkbenchWindow().getActivePage(), (IMarker)marker, (boolean)true);
                        }
                        catch (Exception ex) {
                            System.err.println(ex);
                        }
                    }
                } else if (location >= 0) {
                    AV.this.in_package_view = false;
                    AV.this.class_view.setChecked(true);
                    AV.this.package_view.setChecked(false);
                    AV.this.in_package_view = false;
                    AV.this.in_sub_select_mode = true;
                    AV.this.sub_select.setChecked(true);
                    Vector v = new Vector();
                    v.add(AV.this.elements.elementAt(location));
                    AV.this.list = AV.this.plugin.getSelectedClasses(v);
                    AV.this.vector.removeAllElements();
                    AV.this.elements.removeAllElements();
                    AV.this.aspects.removeAllElements();
                    AV.this.names.removeAllElements();
                    AV.this.tooltips.removeAllElements();
                    AV.this.map = new Map[AV.this.list.size()];
                    int i = 0;
                    while (i < AV.this.list.size()) {
                        Object[] info = new Object[3];
                        info = (Object[])AV.this.list.get(i);
                        AV.this.addToVectors((Integer)info[1], (IResource)info[0]);
                        AV.this.map[i] = (Map)info[2];
                        ++i;
                    }
                    IJavaProject jp = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
                    AV.this.aspectStuff(jp);
                }
            }
        };
        this.aspectDrawing.addListener(this.canvasListener);
        this.selectionChanged(null, this.getSite().getPage().getSelection());
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (AV.this.in_sub_select_mode) {
                    AV.this.selectionChanged(AV.this.part, AV.this.sel);
                } else if (AV.this.part != null && AV.this.sel != null) {
                    AV.this.aspectDrawing.draw(AV.this.names, AV.this.tooltips, AV.this.vector, AV.this.aspects, AV.this.map, AV.this.colors, AV.this.canvas);
                }
            }
        });
    }

    public void draw(Color[] colors) {
        this.colors = colors;
        if (this.map != null && this.aspects != null) {
            this.aspectDrawing.draw(this.names, this.tooltips, this.vector, this.aspects, this.map, colors, this.canvas);
        } else {
            this.aspectDrawing.draw(this.names, this.tooltips, this.vector, this.canvas);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        this.part = part;
        this.sel = sel;
        if (this.in_sub_select_mode) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)sel;
        Object o = structured.getFirstElement();
        if (o instanceof IJavaElement) {
            this.nowShowing = o;
            this.updateDisplay();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDisplay() {
        if (this.nowShowing == null) {
            this.nowShowing = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
        }
        if (this.in_package_view) {
            if (this.nowShowing instanceof IPackageFragment) {
                this.clearVectors();
                IPackageFragment PF = (IPackageFragment)this.nowShowing;
                this.list = this.plugin.getAllPackages(PF);
                this.map = new Map[this.list.size()];
                int i = 0;
                while (i < this.list.size()) {
                    Object[] info = new Object[3];
                    info = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)info[1]), (IResource)info[0]);
                    this.map[i] = (Map)info[2];
                    ++i;
                }
                this.aspectStuff(PF.getJavaProject());
                return;
            } else if (this.nowShowing instanceof IJavaProject) {
                this.clearVectors();
                IJavaProject JP = (IJavaProject)this.nowShowing;
                this.aspectSet = this.plugin.getAllAspects(JP);
                this.list = this.plugin.getAllPackages(JP);
                this.map = new Map[this.list.size()];
                int i = 0;
                while (i < this.list.size()) {
                    Object[] info = new Object[3];
                    info = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)info[1]), (IResource)info[0]);
                    this.map[i] = (Map)info[2];
                    ++i;
                }
                this.aspectStuff(JP.getJavaProject());
                return;
            } else {
                if (!(this.nowShowing instanceof ICompilationUnit)) return;
                this.clearVectors();
                this.in_package_view = false;
                this.package_view.setChecked(false);
                this.class_view.setChecked(true);
                ICompilationUnit CU = (ICompilationUnit)this.nowShowing;
                this.aspectSet = this.plugin.getAllAspects(CU.getJavaProject());
                this.list = this.plugin.getAllClasses(CU);
                this.map = new Map[this.list.size()];
                int i = 0;
                while (i < this.list.size()) {
                    Object[] info = new Object[3];
                    info = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)info[1]), (IResource)info[0]);
                    this.map[i] = (Map)info[2];
                    ++i;
                }
                this.aspectStuff(CU.getJavaProject());
            }
            return;
        } else {
            Object[] info;
            int i;
            if (this.in_package_view) return;
            if (this.nowShowing instanceof ICompilationUnit) {
                this.clearVectors();
                ICompilationUnit CU = (ICompilationUnit)this.nowShowing;
                this.aspectSet = this.plugin.getAllAspects(CU.getJavaProject());
                this.list = this.plugin.getAllClasses(CU);
                this.map = new Map[this.list.size()];
                i = 0;
                while (i < this.list.size()) {
                    info = new Object[3];
                    info = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)info[1]), (IResource)info[0]);
                    this.map[i] = (Map)info[2];
                    ++i;
                }
                this.aspectStuff(CU.getJavaProject());
            }
            if (this.nowShowing instanceof IPackageFragment) {
                this.clearVectors();
                IPackageFragment PF = (IPackageFragment)this.nowShowing;
                this.list = this.plugin.getAllClasses(PF);
                this.aspectSet = this.plugin.getAllAspects(PF.getJavaProject());
                this.map = new Map[this.list.size()];
                i = 0;
                while (i < this.list.size()) {
                    info = new Object[3];
                    info = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)info[1]), (IResource)info[0]);
                    this.map[i] = (Map)info[2];
                    ++i;
                }
                this.aspectStuff(PF.getJavaProject());
                return;
            } else {
                if (!(this.nowShowing instanceof IJavaProject)) return;
                this.clearVectors();
                IJavaProject JP = (IJavaProject)this.nowShowing;
                this.aspectSet = this.plugin.getAllAspects(JP);
                this.list = this.plugin.getAllClasses(JP);
                this.map = new Map[this.list.size()];
                i = 0;
                while (i < this.list.size()) {
                    info = new Object[3];
                    info = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)info[1]), (IResource)info[0]);
                    this.map[i] = (Map)info[2];
                    ++i;
                }
                this.aspectStuff(JP);
            }
        }
    }

    private void clearVectors() {
        this.map = null;
        this.vector.removeAllElements();
        this.elements.removeAllElements();
        this.aspects.removeAllElements();
        this.names.removeAllElements();
        this.tooltips.removeAllElements();
    }

    private void aspectStuff(IJavaProject project) {
        if (this.aspectSet != null) {
            int num = this.aspectSet.size();
            Object[] aspectArray = this.aspectSet.toArray();
            IPath[] aspectPaths = new IPath[num];
            int k = 0;
            while (k < num) {
                if (aspectArray[k] instanceof IResource) {
                    aspectPaths[k] = ((IResource)aspectArray[k]).getLocation();
                    aspectPaths[k] = aspectPaths[k].removeFileExtension();
                    this.aspects.add(aspectPaths[k].lastSegment());
                }
                ++k;
            }
        }
        if (this.plugin.menu != null) {
            this.plugin.menu.addAspects(project, this.aspects);
        }
        if (this.map != null && this.aspects != null) {
            this.aspectDrawing.draw(this.names, this.tooltips, this.vector, this.aspects, this.map, this.colors, this.canvas);
        }
    }

    public void openAspectSource(int index) {
        Iterator iterator = this.aspectSet.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            IResource ir = (IResource)iterator.next();
            if (index == count) {
                if (ir != null) {
                    try {
                        IMarker marker = ir.createMarker("org.eclipse.core.resources.marker");
                        if (marker != null) {
                            IDE.openEditor((IWorkbenchPage)this.part.getSite().getWorkbenchWindow().getActivePage(), (IMarker)marker, (boolean)true);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                    return;
                }
            } else {
                ++count;
            }
            this.selectionChanged(this.part, this.sel);
        }
    }

    private IMarker getMarker(int location) {
        IResource ir;
        IMarker marker = null;
        if (this.elements.elementAt(location) instanceof IResource && (ir = (IResource)this.elements.elementAt(location)) != null) {
            try {
                marker = ir.createMarker("org.eclipse.core.resources.marker");
            }
            catch (CoreException coreEx) {
                System.err.println((Object)coreEx);
            }
        }
        return marker;
    }

    private IMarker getMarker(int location, int lineNum) {
        IResource ir;
        IMarker marker = null;
        if (this.elements.elementAt(location) instanceof IResource && (ir = (IResource)this.elements.elementAt(location)) != null) {
            try {
                marker = ir.createMarker("org.eclipse.core.resources.marker");
                marker.setAttribute("lineNumber", lineNum);
            }
            catch (CoreException coreEx) {
                System.err.println((Object)coreEx);
            }
        }
        return marker;
    }

    private void addToVectors(int size, IJavaElement javaElement) {
        if (size > 0 && javaElement != null) {
            Integer Isize = new Integer(size);
            this.vector.addElement(Isize);
            this.elements.addElement(javaElement);
            this.names.addElement(javaElement.getElementName());
            this.tooltips.addElement(javaElement.getPath().toString());
        }
    }

    private void addToVectors(int size, IResource resource) {
        if (size > 0 && resource != null) {
            Integer Isize = new Integer(size);
            this.vector.addElement(Isize);
            this.elements.addElement(resource);
            if (this.in_package_view) {
                try {
                    IJavaProject JP = JavaCore.create((IProject)resource.getProject());
                    IClasspathEntry[] classpathArray = JP.getRawClasspath();
                    IClasspathEntry classpath = classpathArray[0];
                    String classpathS = classpath.toString();
                    int index = classpathS.indexOf(91);
                    classpathS = new String(classpathS.substring(0, index));
                    String resourcePath = resource.getFullPath().toString();
                    String path = classpathS.endsWith("/") ? resourcePath.substring(classpathS.length()) : resourcePath.substring(classpathS.length() + 1);
                    String string = new String(path.replace('/', '.'));
                    this.names.addElement(string);
                }
                catch (JavaModelException e) {
                    System.err.println((Object)e);
                }
            } else {
                this.names.addElement(resource.getName());
            }
            this.tooltips.addElement(resource.getFullPath().toString());
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AV.this.fillContextMenu(manager);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.zoom_in);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.zoom_out);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.limit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sub_select);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.package_view);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.class_view);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.zoom_in);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.zoom_out);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.limit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sub_select);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.package_view);
        manager.add((IContributionItem)new Separator("Additions"));
        manager.add((IAction)this.class_view);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.zoom_in);
        manager.add((IAction)this.zoom_out);
        manager.add((IAction)this.limit);
        manager.add((IAction)this.sub_select);
        manager.add((IAction)this.package_view);
        manager.add((IAction)this.class_view);
    }

    private void makeActions() {
        this.zoom_in = new Action(){

            public void run() {
                AV.this.zoom_out.setEnabled(true);
                boolean zoom = AV.this.aspectDrawing.zoomIn(AV.this.canvas);
                this.setEnabled(zoom);
            }
        };
        this.zoom_in.setText(Messages.getString("Zoom_In_3"));
        this.zoom_in.setToolTipText(Messages.getString("Zooms_in_on_visualisation_4"));
        ImageDescriptor Zoom_inID = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)Messages.getString("zoomIn.gif_5"));
        this.zoom_in.setImageDescriptor(Zoom_inID);
        this.zoom_out = new Action(){

            public void run() {
                boolean zoom = AV.this.aspectDrawing.zoomOut(AV.this.canvas);
                this.setEnabled(zoom);
                AV.this.zoom_in.setEnabled(true);
            }
        };
        this.zoom_out.setText(Messages.getString("Zoom_Out_6"));
        this.zoom_out.setToolTipText(Messages.getString("Zooms_out_7"));
        ImageDescriptor Zoom_outID = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)Messages.getString("zoomOut.gif_8"));
        this.zoom_out.setImageDescriptor(Zoom_outID);
        this.limit = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (!AV.this.limit_mode) {
                    AV.this.limit_mode = true;
                    AV.this.aspectDrawing.Limit(AV.this.canvas, AV.this.limit_mode);
                    Vector newVector = AV.this.aspectDrawing.lengths;
                    Vector newElements = new Vector();
                    int index = 0;
                    int i = 0;
                    while (i < AV.this.vector.size()) {
                        if (index < newVector.size() && AV.this.vector.elementAt(i).equals(newVector.elementAt(index))) {
                            newElements.add(AV.this.elements.elementAt(i));
                            ++index;
                        }
                        ++i;
                    }
                    AV.this.elements = newElements;
                    AV.this.vector = newVector;
                    AV.this.names = AV.this.aspectDrawing.names;
                    AV.this.tooltips = AV.this.aspectDrawing.tooltips;
                } else {
                    AV.this.limit_mode = false;
                    AV.this.aspectDrawing.Limit(AV.this.canvas, AV.this.limit_mode);
                }
            }
        };
        this.limit.setText(Messages.getString("Limit_view_9"));
        this.limit.setToolTipText(Messages.getString("Limits_visualisation_to_affected_bars_only_10"));
        ImageDescriptor LimitID = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"graph_mode.gif");
        this.limit.setImageDescriptor(LimitID);
        this.package_view = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (AV.this.in_sub_select_mode) {
                    if (!AV.this.in_package_view) {
                        this.setChecked(true);
                        AV.this.class_view.setChecked(false);
                        AV.this.in_package_view = true;
                        AV.this.list = AV.this.plugin.getSelectedPackages(AV.this.elements);
                        AV.this.vector.removeAllElements();
                        AV.this.elements.removeAllElements();
                        AV.this.aspects.removeAllElements();
                        AV.this.names.removeAllElements();
                        AV.this.tooltips.removeAllElements();
                        AV.this.map = null;
                        AV.this.map = new Map[AV.this.list.size()];
                        int i = 0;
                        while (i < AV.this.list.size()) {
                            Object[] info = new Object[3];
                            info = (Object[])AV.this.list.get(i);
                            AV.this.addToVectors((Integer)info[1], (IResource)info[0]);
                            AV.this.map[i] = (Map)info[2];
                            ++i;
                        }
                        IJavaProject jp = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
                        AV.this.aspectStuff(jp);
                    } else {
                        this.setChecked(true);
                    }
                } else {
                    this.setChecked(true);
                }
                AV.this.class_view.setChecked(false);
                AV.this.in_package_view = true;
                AV.this.selectionChanged(AV.this.part, AV.this.sel);
            }
        };
        this.package_view.setText(Messages.getString("Package_View_12"));
        this.package_view.setToolTipText(Messages.getString("Changes_to_package_view_13"));
        ImageDescriptor PackageID = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"packages.gif");
        this.package_view.setImageDescriptor(PackageID);
        this.class_view = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (AV.this.in_sub_select_mode && AV.this.in_package_view) {
                    AV.this.list = AV.this.plugin.getSelectedClasses(AV.this.elements);
                    AV.this.vector.removeAllElements();
                    AV.this.elements.removeAllElements();
                    AV.this.aspects.removeAllElements();
                    AV.this.names.removeAllElements();
                    AV.this.tooltips.removeAllElements();
                    AV.this.map = new Map[AV.this.list.size()];
                    int i = 0;
                    while (i < AV.this.list.size()) {
                        Object[] info = new Object[3];
                        info = (Object[])AV.this.list.get(i);
                        AV.this.addToVectors((Integer)info[1], (IResource)info[0]);
                        AV.this.map[i] = (Map)info[2];
                        ++i;
                    }
                    IJavaProject jp = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
                    AV.this.aspectStuff(jp);
                }
                this.setChecked(true);
                AV.this.package_view.setChecked(false);
                AV.this.in_package_view = false;
                AV.this.selectionChanged(AV.this.part, AV.this.sel);
            }
        };
        this.class_view.setText(Messages.getString("Class_View_15"));
        this.class_view.setToolTipText(Messages.getString("Changes_to_class_view_16"));
        ImageDescriptor ClassID = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"class_obj.gif");
        this.class_view.setImageDescriptor(ClassID);
        this.sub_select = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                boolean sub = AV.this.aspectDrawing.subSelect(AV.this.canvas);
                AV.this.sub_select.setChecked(sub);
                AV.this.in_sub_select_mode = sub;
                if (!sub) {
                    AV.this.selectionChanged(null, AV.this.getSite().getPage().getSelection());
                } else {
                    Vector newVector = AV.this.aspectDrawing.lengths;
                    Vector newElements = new Vector();
                    int index = 0;
                    int i = 0;
                    while (i < AV.this.vector.size()) {
                        if (index < newVector.size() && AV.this.vector.elementAt(i).equals(newVector.elementAt(index))) {
                            newElements.add(AV.this.elements.elementAt(i));
                            ++index;
                        }
                        ++i;
                    }
                    AV.this.elements = newElements;
                    AV.this.vector = newVector;
                    AV.this.names = AV.this.aspectDrawing.names;
                    AV.this.tooltips = AV.this.aspectDrawing.tooltips;
                }
            }
        };
        this.sub_select.setText(Messages.getString("Subselect_18"));
        this.sub_select.setToolTipText(Messages.getString("Subselects_chosen_packages/classes_19"));
        ImageDescriptor SubselectID = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"next_nav.gif");
        this.sub_select.setImageDescriptor(SubselectID);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.aspectDrawing.removeListener(this.canvasListener);
        this.plugin.removeVisualiser();
    }

    public void refresh(IJavaProject p) {
        this.updateDisplay();
    }
}

