/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser.views;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AspectDrawing {
    int spacing = 3;
    int maxBarWidth = 60;
    int minBarWidth = 20;
    int highlightDepth = 3;
    int location = -1;
    int classNum = -1;
    int lineNum = -1;
    float zoom = 1.0f;
    float max_zoom = 4.0f;
    float scale;
    Shape[] rectangles;
    Vector[] highlights;
    Vector[] lineNums;
    Vector lengths;
    Vector names;
    Vector tooltips;
    Vector aspects;
    Map[] map;
    IFigure panel = new Figure();
    MouseListener mouseListener = new MouseListener(){

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDoubleClicked(MouseEvent e) {
            if (e.getSource() instanceof RectangleFigure) {
                AspectDrawing.this.location = -1;
                RectangleFigure rectangle = (RectangleFigure)e.getSource();
                int j = 0;
                while (j < AspectDrawing.this.lengths.size()) {
                    if (((RectangleFigure)AspectDrawing.this.rectangles[j]).equals(rectangle)) {
                        AspectDrawing.this.location = j;
                        AspectDrawing.this.listener.handleEvent(new Event());
                        return;
                    }
                    ++j;
                }
                if (AspectDrawing.this.location == -1) {
                    int i = 0;
                    while (i < AspectDrawing.this.highlights.length) {
                        int k = 0;
                        while (k < AspectDrawing.this.highlights[i].size()) {
                            if (((RectangleFigure)AspectDrawing.this.highlights[i].elementAt(k)).equals(rectangle)) {
                                AspectDrawing.this.classNum = i;
                                Point point = rectangle.getLocation();
                                AspectDrawing.this.lineNum = (Integer)AspectDrawing.this.lineNums[i].elementAt(k);
                                AspectDrawing.this.listener.handleEvent(new Event());
                                return;
                            }
                            ++k;
                        }
                        ++i;
                    }
                }
            }
        }
    };
    Button[] buttons;
    Color[] colors;
    Listener listener;
    boolean limit_mode = false;
    public Rectangle viewsize;

    public void addListener(Listener listener) {
        this.listener = listener;
    }

    public void removeListener(Listener listener) {
        if (this.listener == listener) {
            this.listener = null;
        }
    }

    public void draw(Vector names, Vector tooltips, Vector lengths, Vector aspects, Map[] map, Color[] colors, Canvas canvas) {
        this.clearPanel();
        this.lengths = lengths;
        this.names = names;
        this.tooltips = tooltips;
        this.map = map;
        this.colors = colors;
        this.aspects = aspects;
        int size = names.size();
        this.rectangles = new Shape[size];
        this.highlights = new Vector[size];
        this.lineNums = new Vector[size];
        this.panel = new Figure();
        FlowLayout layout = new FlowLayout();
        layout.setMinorSpacing(this.spacing);
        this.panel.setLayoutManager((LayoutManager)layout);
        ScrollPane scrollpane = new ScrollPane();
        this.panel.setBorder((Border)new LineBorder(ColorConstants.menuBackground, 5));
        this.viewsize = canvas.getClientArea();
        if (this.zoom > 1.0f) {
            this.viewsize.width = (int)((float)this.viewsize.width * this.zoom);
            this.viewsize.height = (int)((float)this.viewsize.height * this.zoom);
        }
        int max_depth = this.viewsize.height - 30;
        LightweightSystem lws = new LightweightSystem(canvas);
        scrollpane.setView(this.panel);
        lws.setContents((IFigure)scrollpane);
        this.addShapes(max_depth, size, this.viewsize);
        scrollpane.setBounds(this.panel.getBounds());
        scrollpane.add(this.panel);
    }

    public void draw(Vector names, Vector tooltips, Vector lengths, Canvas canvas) {
        this.clearPanel();
        this.lengths = lengths;
        this.names = names;
        this.tooltips = tooltips;
        int size = lengths.size();
        this.rectangles = new Shape[size];
        this.highlights = new Vector[size];
        this.lineNums = new Vector[size];
        FlowLayout layout = new FlowLayout();
        layout.setMinorSpacing(this.spacing);
        this.panel.setLayoutManager((LayoutManager)layout);
        this.panel.setBorder((Border)new LineBorder(ColorConstants.menuBackground, 5));
        ScrollPane scrollpane = new ScrollPane();
        this.viewsize = canvas.getClientArea();
        if (this.zoom > 1.0f) {
            this.viewsize.width = (int)((float)this.viewsize.width * this.zoom - 30.0f);
            this.viewsize.height = (int)((float)this.viewsize.height * this.zoom - 30.0f);
        }
        int max_depth = this.viewsize.height - 30;
        LightweightSystem lws = new LightweightSystem(canvas);
        scrollpane.setView(this.panel);
        lws.setContents((IFigure)scrollpane);
        this.addShapes(max_depth, size, this.viewsize);
        scrollpane.setBounds(this.panel.getBounds());
        scrollpane.add(this.panel);
    }

    private void addShapes(int max_depth, int size, Rectangle viewsize) {
        Iterator<Object> iterator;
        int width = 0;
        boolean hScrollBar = false;
        int maximum = 0;
        int num = 0;
        Point[] points = new Point[size];
        this.buttons = new Button[size];
        int i = 0;
        while (i < size) {
            if (this.limit_mode) {
                if (!this.map[i].isEmpty()) {
                    Collection col = this.map[i].values();
                    boolean selected = false;
                    iterator = col.iterator();
                    while (iterator.hasNext()) {
                        if (this.getColor((String)((List)iterator.next()).get(0)) == null) continue;
                        selected = true;
                    }
                    if (selected) {
                        ++num;
                        if ((Integer)this.lengths.elementAt(i) > maximum) {
                            maximum = (Integer)this.lengths.elementAt(i);
                        }
                    }
                }
            } else if ((Integer)this.lengths.elementAt(i) > maximum) {
                maximum = (Integer)this.lengths.elementAt(i);
            }
            ++i;
        }
        if (!this.limit_mode) {
            num = size;
        }
        if (num * (this.minBarWidth + this.spacing) > viewsize.width - 10) {
            width = this.minBarWidth;
            hScrollBar = true;
        } else {
            width = num * (this.maxBarWidth + this.spacing) < viewsize.width - 10 ? this.maxBarWidth : (int)((float)viewsize.width - 10.0f) / num - this.spacing;
        }
        if (hScrollBar) {
            max_depth -= 20;
        }
        this.scale = (float)max_depth / (float)maximum;
        i = 0;
        while (i < size) {
            this.rectangles[i] = new RectangleFigure();
            this.highlights[i] = new Vector();
            this.lineNums[i] = new Vector();
            this.rectangles[i].setSize(width, (int)((float)((Integer)this.lengths.elementAt(i)).intValue() * this.scale) + 20);
            this.rectangles[i].addMouseListener(this.mouseListener);
            this.rectangles[i].setToolTip((IFigure)new Label((String)this.tooltips.elementAt(i)));
            this.buttons[i] = new Button((String)this.names.elementAt(i));
            this.buttons[i].setBackgroundColor(ColorConstants.buttonDarker);
            this.buttons[i].setSize(this.rectangles[i].getSize().width, 20);
            this.buttons[i].setStyle(Clickable.STYLE_TOGGLE);
            this.rectangles[i].add((IFigure)this.buttons[i]);
            Point point = this.rectangles[i].getLocation();
            if (this.map != null) {
                Set mapSet = this.map[i].entrySet();
                this.rectangles[i].setBackgroundColor(ColorConstants.buttonDarkest);
                if (!mapSet.isEmpty()) {
                    iterator = mapSet.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry mapEntry = (Map.Entry)iterator.next();
                        List aspectList = (List)mapEntry.getValue();
                        int numStripes = 0;
                        int first = -1;
                        int k = 0;
                        while (k < aspectList.size()) {
                            Color newColor = this.getColor((String)aspectList.get(k));
                            if (newColor != null) {
                                if (first == -1) {
                                    first = k;
                                }
                                ++numStripes;
                            }
                            ++k;
                        }
                        if (first == -1) continue;
                        Color newColor = this.getColor((String)aspectList.get(first));
                        if (this.rectangles[i].getBackgroundColor() != ColorConstants.white) {
                            this.rectangles[i].setBackgroundColor(ColorConstants.white);
                        }
                        Integer lineNum = (Integer)mapEntry.getKey();
                        RectangleFigure f = new RectangleFigure();
                        f.setLocation(new Point((double)(point.x + 1), (double)((float)lineNum.intValue() * this.scale + 20.0f + (float)point.y)));
                        if (f.getLocation().y + this.highlightDepth >= this.rectangles[i].getLocation().y + this.rectangles[i].getSize().height) {
                            f.setLocation(new Point(point.x + 1, this.rectangles[i].getLocation().y + this.rectangles[i].getSize().height - this.highlightDepth - 1));
                        }
                        if (this.rectangles[i].findFigureAt(f.getLocation()) != this.rectangles[i] || this.rectangles[i].findFigureAt(f.getLocation().x, f.getLocation().y + this.highlightDepth - 1) != this.rectangles[i]) {
                            f.setSize(width - 2, this.highlightDepth * 2 / 3);
                        } else {
                            f.setSize(width - 2, this.highlightDepth);
                        }
                        f.setOutline(false);
                        f.setBackgroundColor(newColor);
                        f.addMouseListener(this.mouseListener);
                        this.rectangles[i].add((IFigure)f);
                        this.highlights[i].add(f);
                        this.lineNums[i].add(lineNum);
                        if (numStripes < 1) continue;
                        int stripeNum = 1;
                        int j = first;
                        while (j < aspectList.size()) {
                            Color color = this.getColor((String)aspectList.get(j));
                            if (color != null) {
                                RectangleFigure stripe = new RectangleFigure();
                                stripe.setBackgroundColor(color);
                                stripe.setLocation(new Point(f.getLocation().x + f.getSize().width / numStripes * (stripeNum - 1), f.getLocation().y));
                                stripe.setSize(f.getSize().width / numStripes, f.getSize().height);
                                stripe.setOutline(false);
                                f.add((IFigure)stripe);
                                ++stripeNum;
                            }
                            ++j;
                        }
                    }
                }
            }
            if (this.limit_mode) {
                if (this.rectangles[i].getBackgroundColor() == ColorConstants.white) {
                    this.panel.add((IFigure)this.rectangles[i]);
                }
            } else {
                this.panel.add((IFigure)this.rectangles[i]);
            }
            ++i;
        }
    }

    public boolean subSelect(Canvas canvas) {
        if (this.map != null) {
            int count = 0;
            int i = 0;
            while (i < this.lengths.size()) {
                if (this.buttons[i].isSelected()) {
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                return false;
            }
            Vector vectorSelection = new Vector();
            Vector elementSelection = new Vector();
            Vector tooltipSelection = new Vector();
            Map[] mapSelection = new Map[count];
            count = 0;
            int i2 = 0;
            while (i2 < this.lengths.size()) {
                if (this.buttons[i2].isSelected()) {
                    vectorSelection.add(this.lengths.elementAt(i2));
                    elementSelection.add(this.names.elementAt(i2));
                    tooltipSelection.add(this.tooltips.elementAt(i2));
                    mapSelection[count] = this.map[i2];
                    ++count;
                }
                ++i2;
            }
            this.draw(elementSelection, tooltipSelection, vectorSelection, this.aspects, mapSelection, this.colors, canvas);
            return true;
        }
        int count = 0;
        int i = 0;
        while (i < this.lengths.size()) {
            if (this.buttons[i].isSelected()) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return false;
        }
        Vector vectorSelection = new Vector();
        Vector elementSelection = new Vector();
        Vector tooltipSelection = new Vector();
        count = 0;
        int i3 = 0;
        while (i3 < this.lengths.size()) {
            if (this.buttons[i3].isSelected()) {
                vectorSelection.add(this.lengths.elementAt(i3));
                elementSelection.add(this.names.elementAt(i3));
                tooltipSelection.add(this.tooltips.elementAt(i3));
                ++count;
            }
            ++i3;
        }
        this.draw(elementSelection, tooltipSelection, vectorSelection, canvas);
        return true;
    }

    public void Limit(Canvas canvas, boolean limit_mode) {
        this.limit_mode = limit_mode;
        this.draw(this.names, this.tooltips, this.lengths, this.aspects, this.map, this.colors, canvas);
    }

    private void clearPanel() {
        List children = this.panel.getChildren();
        if (children.size() > 0) {
            int i = 0;
            while (i < children.size()) {
                this.panel.remove((IFigure)children.get(i));
            }
        }
    }

    public boolean zoomIn(Canvas canvas) {
        if (this.zoom + 0.5f <= this.max_zoom) {
            float old_zoom = this.zoom;
            this.zoom += 0.5f;
            this.maxBarWidth = (int)((float)this.maxBarWidth / old_zoom * this.zoom);
            this.minBarWidth = (int)((float)this.minBarWidth / old_zoom * this.zoom);
            this.highlightDepth = (int)((float)this.highlightDepth / old_zoom * this.zoom);
            this.draw(this.names, this.tooltips, this.lengths, this.aspects, this.map, this.colors, canvas);
        }
        return this.zoom + 0.5f <= this.max_zoom;
    }

    public boolean zoomOut(Canvas canvas) {
        if (this.zoom - 0.5f <= 1.0f) {
            this.zoom = 1.0f;
            this.maxBarWidth = 60;
            this.minBarWidth = 20;
            this.highlightDepth = 3;
        } else {
            float old_zoom = this.zoom;
            this.zoom -= 0.5f;
            this.maxBarWidth = (int)((float)this.maxBarWidth / old_zoom * this.zoom);
            this.minBarWidth = (int)((float)this.minBarWidth / old_zoom * this.zoom);
            this.highlightDepth = (int)((float)this.highlightDepth / old_zoom * this.zoom);
        }
        this.draw(this.names, this.tooltips, this.lengths, this.aspects, this.map, this.colors, canvas);
        return this.zoom > 1.0f;
    }

    private Color getColor(String aspect) {
        if (this.aspects != null && this.colors != null) {
            int i = 0;
            while (i < this.aspects.size()) {
                if (aspect.equals((String)this.aspects.elementAt(i)) && this.colors.length >= i) {
                    return this.colors[i];
                }
                ++i;
            }
        }
        return null;
    }
}

