/**********************************************************************
Copyright (c) 2002 IBM Corporation and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html
Contributors:
Adrian Colyer - initial version
...
**********************************************************************/
package org.eclipse.ajdt.internal.core;

import java.util.List;

import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AJDTStructureViewNodeAdapter implements IWorkbenchAdapter {

	private static AJDTStructureViewNodeAdapter instance = null;		

	public static AJDTStructureViewNodeAdapter getDefault( ) {
		if ( instance == null ) { instance = new AJDTStructureViewNodeAdapter( ); }
		return instance;	
	}

	/**
	 * Constructor for AJDTStructureViewNodeAdapter.
	 */
	private AJDTStructureViewNodeAdapter() {
		super();
	}

//	/**
//	 * @see IWorkbenchAdapter#getChildren(Object)
//	 */
//	public Object[] getChildren(Object o) {
//		if ( o instanceof AJDTStructureViewNode ) {  
//			AJDTStructureViewNode node = (AJDTStructureViewNode) o;	
//			List acceptedChidren = new ArrayList();
//			for (Iterator it = node.getChildren().iterator(); it.hasNext(); ) {
//				AJDTStructureViewNode child = (AJDTStructureViewNode)it.next();
//				if (StructureViewNodeFactory.acceptNode(node.getStructureNode(), child.getStructureNode())) {
//					acceptedChidren.add(child);
//				} 
//			}  
//			return acceptedChidren.toArray();
//		} else { 
//			return new Object[0];
//		}
//	}  

	/**
	 * @see IWorkbenchAdapter#getChildren(Object)
	 */
	public Object[] getChildren(Object o) {
		if ( o instanceof AJDTStructureViewNode ) {
			AJDTStructureViewNode node = (AJDTStructureViewNode) o;	
			return node.getChildren().toArray();
		} else {
			return new Object[0];
		}
	}

	/**
	 * @see IWorkbenchAdapter#getImageDescriptor(Object)
	 */
	public ImageDescriptor getImageDescriptor(Object o) {
		ImageDescriptor retVal = ImageDescriptor.getMissingImageDescriptor();
		if ( o instanceof AJDTStructureViewNode ) {
			AJDTStructureViewNode node = (AJDTStructureViewNode) o;	
			ImageDescriptor baseDesc = ((AJDTIcon)node.getIcon()).getImageDescriptor();
			retVal = decorate( baseDesc, node );
		}
		return retVal;
	}

	/**
	 * @see IWorkbenchAdapter#getLabel(Object)
	 */
	public String getLabel(Object o) {
		String label = "<>";
		if ( o instanceof AJDTStructureViewNode ) {
			AJDTStructureViewNode node = (AJDTStructureViewNode) o;	
			label = node.getLabel();
		}
		return label;
	}

	/**
	 * @see IWorkbenchAdapter#getParent(Object)
	 */
	public Object getParent(Object o) {
		if ( o instanceof AJDTStructureViewNode ) {
			AJDTStructureViewNode node = (AJDTStructureViewNode) o;	
			return  node.getParent();
		}
		return null;
	}


	/**
	 * Decorate icon based on modifiers, errors etc.
	 * Possible decorations are: abstract, final, synchronized, static,
	 * runnable, warning, error, overrides, implements
	 */
	private ImageDescriptor decorate( ImageDescriptor base, AJDTStructureViewNode node ) {
		int flags = 0;
		IProgramElement pNode = node.getStructureNode();
		if (pNode != null) {
			List modifiers = pNode.getModifiers();
			if ( modifiers != null ) { 
				if (modifiers.contains(IProgramElement.Modifiers.ABSTRACT)) {
					flags = flags | JavaElementImageDescriptor.ABSTRACT;
				}  
				if (modifiers.contains(IProgramElement.Modifiers.FINAL)) {
					flags = flags | JavaElementImageDescriptor.FINAL;
				} 
				if (modifiers.contains(IProgramElement.Modifiers.SYNCHRONIZED)) {
					flags = flags | JavaElementImageDescriptor.SYNCHRONIZED;
				} 
				if (modifiers.contains(IProgramElement.Modifiers.STATIC)) {
					flags = flags | JavaElementImageDescriptor.STATIC;
				}	
			}	
			if ( pNode.getKind() == IProgramElement.Kind.CONSTRUCTOR ||
				 pNode.getKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
				flags = flags | JavaElementImageDescriptor.CONSTRUCTOR;	
			}
			if ( pNode.isRunnable( ) ) {
				flags = flags | JavaElementImageDescriptor.RUNNABLE;
			}
			if ( pNode.isOverrider( ) ) {
				flags = flags | JavaElementImageDescriptor.OVERRIDES;
			}
			if ( pNode.isImplementor( ) ) {
				flags = flags | JavaElementImageDescriptor.IMPLEMENTS;
			}
			IMessage sMessage = pNode.getMessage();
			if ( sMessage != null ) {
				if ( sMessage.getKind() == IMessage.ERROR ) {
					flags = flags | JavaElementImageDescriptor.ERROR;
				} else if ( sMessage.getKind() == IMessage.WARNING ) {
					flags = flags | JavaElementImageDescriptor.WARNING;
				}
			}
		}
		return AJDTUtils.decorate( base, flags );
	}
		
}

