/**********************************************************************
Copyright (c) 2002 IBM Corporation and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html
Contributors:
Adrian Colyer, Andy Clement, Tracy Gardner - initial version
...
**********************************************************************/
package org.eclipse.ajdt.ui.tests;

import junit.framework.TestSuite;

import org.eclipse.ajdt.internal.core.tests.AJDTUtilsTest;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class AllAJPluginTests {

	// set this to false tyo avoid having to answer dialog questions about
	// the plugin - will assume that all questions have been answered "yes"
	// if set to false
	public static boolean interactiveTesting = true;

	private static boolean questionResponse;

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("Test for org.eclipse.ajdt.ui.tests");
		//$JUnit-BEGIN$
		suite.addTest(new TestSuite(AJDTUtilsTest.class));
		suite.addTest(new TestSuite(AspectJPluginTest.class));
		//$JUnit-END$
		return suite;
	}

	public static synchronized boolean confirmWithUser(String message) {		
		
		if (!interactiveTesting) return true;
		
		final String finalMsg = message;
		AspectJPlugin.getDefault().getDisplay().syncExec(new Runnable() {
			public void run() {
				try {
					IWorkbenchWindow iww = AspectJPlugin.getDefault().getActiveWorkbenchWindow();
					// This really should not be null ...
					if (iww != null) {
						Shell shell = iww.getShell();
						questionResponse = MessageDialog.openQuestion(
							shell,
							"JUnit Verification",
							finalMsg);
					} else {
						AspectJPlugin.getDefault().getLog().log(
							new Status(
								Status.ERROR,
								AspectJPlugin.PLUGIN_ID,
								Status.OK,
								"Unable to determine workbenchwindow instance for opening an error dialog",
								null));
					}
				} catch (Throwable t) {
					System.err.println( t );
				}
			}
		});

		return questionResponse;
	}
}