/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     Andy Clement - initial version
 *******************************************************************************/
package org.eclipse.contribution.visualiser.jdtimpl;

import java.util.List;
import java.util.SortedSet;

import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.graphics.Color;

/**
 * The JDT Markup Provider
 */
public class JDTMarkupProvider implements IMarkupProvider,IResourceChangeListener {

	public JDTMarkupProvider() {
	  ResourcesPlugin.getWorkspace().addResourceChangeListener(this);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.contribution.visualiser.interfaces.IMarkupProvider#initialise()
	 */
	public void initialise() {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.contribution.visualiser.interfaces.IMarkupProvider#getMemberMarkups(org.eclipse.contribution.visualiser.interfaces.IMember)
	 */
	public List getMemberMarkups(IMember member) {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.contribution.visualiser.interfaces.IMarkupProvider#getGroupMarkups(org.eclipse.contribution.visualiser.interfaces.IGroup)
	 */
	public List getGroupMarkups(IGroup group) {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.contribution.visualiser.interfaces.IMarkupProvider#getAllMarkupKinds()
	 */
	public SortedSet getAllMarkupKinds() {
		return null;
	}

	public boolean changeMode(){
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.contribution.visualiser.interfaces.IMarkupProvider#setColorFor(java.lang.String, org.eclipse.swt.graphics.Color)
	 */
	public void setColorFor(String kind, Color color) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.contribution.visualiser.interfaces.IMarkupProvider#getColorFor(java.lang.String)
	 */
	public Color getColorFor(String kind) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.contribution.visualiser.interfaces.IMarkupProvider#processMouseclick(java.lang.String, org.eclipse.contribution.visualiser.core.Stripe, java.lang.String, int)
	 */
	public boolean processMouseclick(IMember member, Stripe stripe, String exactKind, int buttonClicked) {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IResourceChangeListener#resourceChanged(org.eclipse.core.resources.IResourceChangeEvent)
	 */
	public void resourceChanged(IResourceChangeEvent event) {
	}

	public boolean hasMultipleModes() {
		return false;
	}

//
//	/**
//	 * @param annotations
//	 * @param one_annotation
//	 * @return
//	 */
//	private boolean alreadyIn(Set annotations, Annotation one_annotation) {
//		boolean alreadyContainsIt = false;
//		Iterator setIter = annotations.iterator();
//		while (!alreadyContainsIt && setIter.hasNext()) {
//			Annotation setEntry = (Annotation) setIter.next();
//			// log("Checking entry "+setEntry+" against "+one_annotation);
//			if (setEntry.getType().equals(one_annotation.getType()))
//				alreadyContainsIt = true;
//		}
//		return alreadyContainsIt;
//	}


	/**
	 * Iterates through all the packages in a project and returns a Set of 
	 * Annotations - all those for the current project.
	 */
//	public Set getAllAnnotationsOnProject(IJavaProject JP) {
//
//		project = JP.getProject();
//
//		// Find all the project package fragments
//		IPackageFragmentRoot[] fragRoots = null;
//		try {
//			fragRoots = JP.getAllPackageFragmentRoots();
//		} catch (JavaModelException e) {
//			log(e);
//		}
//
//		// Iterate through the fragments looking for annotations
//		Set annotations = new HashSet();
//		trace("Going through fragment roots for the project...");
//		for (int i = 0; i < fragRoots.length; i++) {
//			IPackageFragmentRoot one_root = fragRoots[i];
//			try {
//				// This will skip roots that are for jar files!
//				if (one_root.getKind() != IPackageFragmentRoot.K_BINARY) {
//					trace("Frag " + i + " > " + one_root.getElementName());
//					List fragmentAnnotations =
//						getAnnotationsOnPackageFragment(one_root);
//					Iterator annIter = fragmentAnnotations.iterator();
//					while (annIter.hasNext()) {
//						Annotation one_annotation = (Annotation) annIter.next();
//						if (!alreadyIn(annotations, one_annotation)) {
//							annotations.add(one_annotation);
//						}
//
//					}
//					//annotations.addAll(getAnnotationsOnPackageFragment(one_root));
//				}
//			} catch (JavaModelException e1) {
//				log(e1);
//			}
//
//		}
//
//		trace("getAllAnnotationsOnProject result size = " + annotations.size());
//
//		return annotations;
//	}
//	
//
//	public List getAnnotationsOnPackageFragment(IPackageFragmentRoot root) {
//		trace(">>getAnnotationsOnPackageFragment " + root.getElementName());
//		List result = new ArrayList();
//		try {
//			IResource ir = root.getCorrespondingResource();
//			if (ir == null)
//				trace(
//					"Cant get resource for that package fragment");
//			else
//				result = getAnnotationsOnResource(ir);
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		trace("<<MarkersOnPackageFragment: result.length=" + result.size());
//		return result;
//
//	}
//
//   private static void trace(String string) {
//   	VisualiserPlugin.trace(string);
//   }
//
//
//
//   //TO DO: Why do we have a resource changed listener here?
//   public void resourceChanged(IResourceChangeEvent irce) {
//	   IResource res = irce.getResource();
//	   switch (irce.getType()) {
//		   case IResourceChangeEvent.POST_CHANGE:
//			 try {
//			   IResourceDelta ird = irce.getDelta();
//			   LocalDeltaMarkerChecker ldp = new LocalDeltaMarkerChecker();
//			   ird.accept(ldp);
//			   if (ldp.shouldRedraw()) {
//				   System.err.println("Redrawing...");
//				   refreshVisview();
//			   } 
//		   } catch (CoreException e) {
//			   e.printStackTrace();
//		   }
//		 break;
//	   }
//   }
//	
//   class LocalDeltaMarkerChecker implements IResourceDeltaVisitor {
//	   boolean changes = false;
//	   public void reset() {
//		   changes = false;
//	   }
//	   public boolean shouldRedraw() {
//		   return changes;
//	   }
//	   public boolean visit(IResourceDelta dta) {
//		   boolean cont = true;
//		   IResource ir = dta.getResource();
////		   System.err.println("DTAKIND="+dta.getKind());
//		   switch (dta.getKind()) {
//			   case IResourceDelta.CHANGED:
//			   int flags = dta.getFlags();
////			   System.err.println("Flags = "+flags);
//			   if ((flags & IResourceDelta.MARKERS)!=0) {
//				   IMarkerDelta[] imd = dta.getMarkerDeltas();
//				   if (imd.length>0) {
//					
//					   String interestingMarkers = new String(","+menu.getMarkersToDisplay()+","); 
////					   System.err.println("IMDs are not zero");
//					   for (int i = 0;(i<imd.length) && (changes == false);i++) {
//						   IMarkerDelta one_imd = imd[i];
//						
//						   String type;
//						   IMarker amarker = one_imd.getMarker();
////							 one_imd.getType()
////							  
////							 if (amarker==null) {
////							   if (one_imd.getKind()==IResourceDelta.REMOVED) {
////								 changes=true;cont=false;
////							   }
////							 } else {
//							  
//							  
////							 type = amarker.getType();
//							 type = one_imd.getType();
////							   System.err.println("Processing type "+type);							
//							 if (type.indexOf(".") != -1)
//							   type = type.substring(type.lastIndexOf(".") + 1);
//								
//							 if (interestingMarkers.equals(",,") || interestingMarkers.indexOf(","+type+",")!=-1) {
////							   System.err.println("Marker type is "+type);
//							   changes = true;
//							   cont = false;// Stop when the first marker change detected.
//							 }
//					   }
//				   }
//			   }
//		   }
//		   return cont;
//	   }
//   }
//
//   /**
//	* Used when processing in the package view, as we accumulate annotations from
//	* file to file - we need to move those annotations by the supplied adjuster.
//	*/
//   private Map adjustMap(Map inputMap, int adjuster) {
//	   trace("> Entering map adjuster: adjuster="+adjuster);
//	   Map outputMap = new HashMap();
//	   Set keys      = inputMap.keySet();
//	   Iterator keyIterator = keys.iterator();
//	   while (keyIterator.hasNext()) {
//		   Integer line = (Integer)keyIterator.next();
//		   trace(">  Processing inputmap, line:"+line);
//		   List annMap = (List) inputMap.get(line);
//		   List annMap_new = new ArrayList();
//		   Iterator annIterator = annMap.iterator();
//		   while (annIterator.hasNext()) {
//			   Annotation a1 = (Annotation)annIterator.next();
//			   trace(">   Adjusting annotation, currentline:"+a1.getLine());
//			   Annotation a2 = new Annotation();
//			   a2.setDescription(a1.getDescription());
//			   a2.setType(a1.getType());
//			   a2.setFile(a1.getFile());
//			   a2.setLine(a1.getLine()+adjuster);
//			   annMap_new.add(a2);
//		   }
//		   trace("<  Processing inputmap, line:"+line);
//		   outputMap.put(new Integer(line.intValue()+adjuster),annMap_new);
//	   }	
//	   trace("< Leaving map adjuster");
//	   return outputMap;
//	   /*
//	   HashMap newmap = new HashMap();
//		
//	   Set keys = oldmap.keySet();
//		
//	   Iterator it = keys.iterator();
//	   while (it.hasNext()) {
//		   Integer line = (Integer) it.next();
//			
//			
//		   List anns = oldmap.get(line);
//		   List new_list = new ArrayList();
//		   Iterator anns_it = anns.iterator();
//		   while (anns_it.hasNext()) {
//			   Annotation an = (Annotation)it.next();
//			   new_list.add(an.getType());
//				
//			   Annotation new_an = new Annotation();
//			   new_an.setDescription(an.getDescription());
//			   new_an.setType(an.getType());
//			   new_an.setFile(an.getFile());
//			   new_an.setLine(an.getLine()+adjuster);
//			   newmap.put(new_an);
//			
//		   Integer line = (Integer) it.next();
//		
//		   Object o = oldmap.get(line);
//		
//		   List oldaspects = (List) o;
//		
//		   List newaspects = new LinkedList();
//		
//		   Iterator iterator2 = oldaspects.iterator();
//		   while (iterator2.hasNext()) {
//		
//			   ProgramElementNode theaspect =
//				   (ProgramElementNode) iterator2.next();
//		
//			   String fullpath =
//				   theaspect
//					   .getSourceLocation()
//					   .getSourceFile()
//					   .getAbsolutePath();
//		
//			   Path path = new Path(fullpath);
//			   String aspectname = path.removeFileExtension().lastSegment();
//		
//			   newaspects.add(aspectname);
//		   }
//		
//		   if (!newaspects.isEmpty()) {
//			   line = new Integer(line.intValue() + startline);
//		
//			   newmap.put(line, newaspects);
//		   }
//	   }
//	   */
//	   //return newmap;
//   }
//   /**
//	* Just a pass through version of getLinesToAspectMap that allows for callers who
//	* relied on the old behaviour (i.e. the visualiser).
//	* 
//	* @param sourceFilePath
//	* @return Map is a map of line numbers to aspects
//	*/
//   public static Map getLinesToAnnotationsMap(IResource res) {
//	   return getLinesToAspectMap(res, false);
//   }
//
//   /**
//	* This method returns a map from affected source lines in a class to
//	* a List of aspects affecting that line.
//	* Based on method of same name by mik kirsten. To be replaced when StructureModelUtil
//	* corrects its implementation
//	* 
//	* AndyC: 2-Mar-03: Extended input parameter set with a boolean.  This determines
//	* if the map is filled with a map of lines->aspects or lines->advice_within_those_aspects
//	* The visualiser wants the first version of the map, the gutter annotations want the second
//	* version.  The gutter annotations needs to know more than just the aspect in affect, they
//	* need to know which advice within the aspect is in affect.
//	* 
//	* @param the full path of the source file to get a map for
//	* @param needIndividualNodes If true then the line numbers map to real advice markers within the aspects.
//	* 
//	* @return a Map from line numbers to a List of ProgramElementNodes.
//	*/
//   public static Map getLinesToAspectMap(
//	   IResource res,
//	   boolean needIndividualNodes) {
//
//	   trace(">> getLinesToAspectMap: res = " + res);
//	   //Path path = new Path(sourceFilePath);
//	   List annotationsList = null;
//	   /*		try {
//				   IJavaElement ije = JavaCore.create(project).findElement(sourceFilePath);
//				   if (ije!=null) {
//					   IResource res = ije.getCorrespondingResource();
//					   if (res!=null) annotationsList = getAnnotationsOnResource(res);
//				   }
//			   } catch (JavaModelException e) {e.printStackTrace();}
//	   */
//	   annotationsList = getAnnotationsOnResource(res);
//	   Map aspectMap = new HashMap();
//
//	   if (annotationsList == null) {
//		   return aspectMap;
//	   }
//
//	   List sortedList = sortElementsByLinenumber(annotationsList);
//	   // After this the list of annotations is sorted by the line number affected.
//
//	   for (Iterator it = sortedList.iterator(); it.hasNext();) {
//		   Annotation an = (Annotation) it.next();
//
//		   Integer ln = an.getLine_Integer();
//		   List alreadyExists = (List) aspectMap.get(ln);
//		   if (alreadyExists == null) {
//			   List newEntry = new ArrayList();
//			   newEntry.add(an);
//			   aspectMap.put(an.getLine_Integer(), newEntry);
//		   } else {
//			   aspectMap.remove(ln);
//			   alreadyExists.add(an);
//			   aspectMap.put(ln, alreadyExists);
//		   }
//	   }
//	   return aspectMap;
//   }
//   /*
//	   private static List getPackagesHelper(
//		   ProgramElementNode node,
//		   ProgramElementNode.Kind kind,
//		   String prename,
//		   List matches) {
//	
//		   if (kind == null || node.getProgramElementKind().equals(kind)) {
//			   if (prename == null) {
//				   prename = new String(node.toString());
//			   } else {
//				   prename = new String(prename + "." + node);
//			   }
//			   Object[] o = new Object[2];
//			   o[0] = node;
//			   o[1] = prename;
//	
//			   matches.add(o);
//		   }
//	
//		   for (Iterator it = node.getChildren().iterator(); it.hasNext();) {
//			   StructureNode nextNode = (StructureNode) it.next();
//			   if (nextNode instanceof ProgramElementNode) {
//				   getPackagesHelper(
//					   (ProgramElementNode) nextNode,
//					   kind,
//					   prename,
//					   matches);
//			   }
//		   }
//	
//		   return matches;
//	   }*/
//	   
//	   /**
//		 * The important method - produces annotations for a given resource, could be driven by
//		 * any process.  This current implementation uses resource markers.  But we could read
//		 * XML or anything !!!  TO DO: This should be a pluggable implementation method.
//		 */
//	   public static List getAnnotationsOnResource(IResource ir) {
//		   if (ir == null)
//			   return new ArrayList();
//
//		   boolean showEverything = true;
//		   String markerSubset = getDefault().menu.getMarkersToDisplay();
//		   if (markerSubset.length() != 0)
//			   showEverything = false;
//		   String markersToDisplay = new String("," + markerSubset + ",");
//		   List markSet = new ArrayList();
//		   IMarker markers[] = null;
//		   try {
//			   markers =
//				   ir.findMarkers("org.eclipse.core.resources.marker", true, 2);
//
//			   // If we just want to look at search markers
//			   // markers = ir.findMarkers("org.eclipse.search.searchmarker", true, 2);
//
//			   if (markers != null && markers.length != 0) {
//				   for (int j = 0; j < markers.length; j++) {
//					   IMarker m = markers[j];
//					   Annotation an = new Annotation();
//					   String type = m.getType();
//					   // Trim off the org.eclipse.blah...
//					   // For specific types we can do specific things, perhaps retrieving some
//					   // meta data and using that as the type or description.
//
//					   if (type.indexOf(".") != -1)
//						   type = type.substring(type.lastIndexOf(".") + 1);
//
//					   //	Some special casing for cme markers...
//					   if (showEverything
//						   || markersToDisplay.indexOf("," + type + ",") != -1) {
//
//						   if (type.equals("cmesearchmarker")) {
//							   String elementFrom  = (String) m.getAttribute("javaElementFrom");
//							   String elementTo    = (String) m.getAttribute("javaElementTo");
//							   String relationship = (String) m.getAttribute("relationship");
//							   String queryName    = (String) m.getAttribute("queryName");
//							   StringBuffer label = new StringBuffer();
//							   if (getDefault().menu.isPsychedelic()) {
//								   label.append(relationship+" ["+queryName+"]");
//								   an.setType(label.toString());
//							   } else if (getDefault().menu.isColorPerQuery()) {
//								   label.append(queryName);
//								   an.setType(label.toString());
//							   } else if (getDefault().menu.isColorPerRelationship()) {
//								   label.append(relationship);
//								   an.setType(label.toString());
//							   } else {
//							
//							   an.setType("CME:" + ((queryName == null
//										   || queryName.length() == 0)
//										   ? ""
//										   : queryName + ".")
//									   + relationship);
//							   }
//							   an.setLine(((Integer) m.getAttribute(IMarker.LINE_NUMBER)).intValue());
//							   an.setDescription((String)m.getAttribute(IMarker.MESSAGE));
//							   markSet.add(an);
//							
//						   } else {
//
//							   an.setType(type);
//							   an.setLine(
//								   ((Integer) m.getAttribute(IMarker.LINE_NUMBER))
//									   .intValue());
//							   an.setDescription(
//								   (String) m.getAttribute(IMarker.MESSAGE));
//							   markSet.add(an);
//						   }
//					   }
//				   }
//			   }
//		   } catch (CoreException e) {
//			   e.printStackTrace();
//		   }
//		   return markSet;
//	   }
//
//
//
//	   /**
//		* Helper function sorts a list of resources into alphabetical order
//		*/
//	   private List sortElements(List oldElements) {
//
//		   Object[] temp = oldElements.toArray();
//		   SortingComparator comparator = new SortingComparator();
//
//		   Arrays.sort(temp, comparator);
//
//		   List newResources = Arrays.asList(temp);
//
//		   return newResources;
//	   }
//
//	   /**
//		* Helper function that sorts a List containing arrays of program elements.
//		*/
//	   private List sortArray(List oldElements) {
//		   Object[] temp = oldElements.toArray();
//		   SortArrayComparator comparator = new SortArrayComparator();
//
//		   Arrays.sort(temp, comparator);
//
//		   List newElements = Arrays.asList(temp);
//
//		   return newElements;
//	   }
//
//	   //--InnerClass---//
//
//	   /**
//		* Compares two ProgramElementNodes by their String names.
//		*/
//	   private class SortingComparator implements Comparator {
//		   public int compare(Object o1, Object o2) {
//			   Annotation p1 = (Annotation) o1;
//			   Annotation p2 = (Annotation) o2;
//
//			   String name1 = p1.getDescription();
//			   String name2 = p2.getDescription();
//
//			   return name1.compareTo(name2);
//		   }
//	   }
//
//	   //May need this to sort arrays of packages but they seem to be sorted allready
//
//	   /**
//		* Compares two arrays with the first element as a ProgramElementNode by their names.
//		*/
//	   private class SortArrayComparator implements Comparator {
//
//		   public int compare(Object o1, Object o2) {
//			   Object[] array1 = (Object[]) o1;
//			   Object[] array2 = (Object[]) o2;
//
//			   Annotation p1 = (Annotation) array1[0];
//			   Annotation p2 = (Annotation) array2[0];
//
//			   String name1 = p1.getDescription();
//			   String name2 = p2.getDescription();
//
//			   return name1.compareTo(name2);
//		   }
//	   }
//
//
//
//	   public static List getPackagesInModel() {
//		   List packages = new ArrayList();
//		   IPackageFragment pkgFrags[] = null;
//		   try {
//			   pkgFrags = JavaCore.create(project).getPackageFragments();
//		   } catch (JavaModelException e) {
//			   e.printStackTrace();
//		   }
//		   return Arrays.asList(pkgFrags);
//
//	   }
//
//
//
//	   private static List sortElementsByLinenumber(List oldElements) {
//		   Object[] temp = oldElements.toArray();
//		   SortingComparatorByLineNumber comparator =
//			   new SortingComparatorByLineNumber();
//		   Arrays.sort(temp, comparator);
//		   List newResources = Arrays.asList(temp);
//		   return newResources;
//	   }
//
//	   private static class SortingComparatorByLineNumber implements Comparator {
//		   public int compare(Object o1, Object o2) {
//			   Annotation p1 = (Annotation) o1;
//			   Annotation p2 = (Annotation) o2;
//
//			   int l1 = p1.getLine();
//			   int l2 = p2.getLine();
//			   return new Integer(l1).compareTo(new Integer(l2));
//		   }
//	   }
//
//
//	   /**
//		* @return		all of the AspectJ and Java source files in a package
//		*/ /*
//		   public static List getFilesInPackage(ProgramElementNode packageNode) {
//			   List packageContents;
//			   if (packageNode == null) {
//				   return null;
//			   } else {
//				   packageContents = packageNode.getChildren();
//			   }
//			   List files = new ArrayList();
//			   for (Iterator it = packageContents.iterator(); it.hasNext();) {
//				   ProgramElementNode packageItem = (ProgramElementNode) it.next();
//				   if (packageItem.getProgramElementKind()
//					   == ProgramElementNode.Kind.FILE_JAVA
//					   || packageItem.getProgramElementKind()
//						   == ProgramElementNode.Kind.FILE_ASPECTJ) {
//					   files.add(packageItem);
//				   }
//			   }
//			   return files;
//		   }*/
//
//   /**
//	* This method is copied from StructureModelUtil inoder for it to use the working
//	* version of getLineToAspectMap()
//	* 
//	* @return		the set of aspects with advice that affects the specified package
//	*/
//   public static Set getAspectsAffectingPackage(String packageNode) {
//	   Set aspects = new HashSet();
//	   IPath resPath = new Path(packageNode);
//
//	   IJavaElement elem = null;
//	   try {
//		   elem = JavaCore.create(project).findElement(resPath);
//	   } catch (JavaModelException e) {
//		   e.printStackTrace();
//	   }
//
//	   if (elem instanceof IPackageFragment) {
//		   IPackageFragment ipf = (IPackageFragment) elem;
//		   ICompilationUnit[] cus = null;
//		   try {
//			   cus = ipf.getCompilationUnits();
//		   } catch (JavaModelException e1) {
//			   e1.printStackTrace();
//		   }
//		   // If we need to include aspects, I have to call getNonJavaResources();
//
//		   for (int f = 0; f < cus.length; f++) {
//			   Map adviceMap = getLinesToAnnotationsMap(cus[f].getResource());
//			   Collection values = adviceMap.values();
//			   for (Iterator it2 = values.iterator(); it2.hasNext();) {
//				   aspects.add(it2.next());
//			   }
//		   }
//	   } else {
//		   System.err.println(
//			   "PackageNode "
//				   + packageNode
//				   + " is not a package in the current project");
//	   }
//
//	   return aspects;
//   }

}
