/*********************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html 
 * Contributors: 
 * Sian Whiting -  initial version.
 **********************************************************************/
package org.eclipse.ajdt.ui.visualiser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import org.eclipse.contribution.visualiser.core.MarkupUtils;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.jdtimpl.JDTMember;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

/**
 * @author Sian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class AJDTMarkupProvider extends SimpleMarkupProvider {

	
	
	/**
	 * Get a List of Stripes for the given member, which are its markups.
	 */
	public List getMemberMarkups(IMember member) {
		if(markups != null) {
			if(markups.containsKey(member.getFullname())) {
				List markupList = (List)markups.get(member.getFullname());
				if(markupList != null) {
					return markupList; 
				}
			}
		}

		long stime = System.currentTimeMillis();
		List stripeList = new ArrayList();
		if(ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
			IJavaProject jp = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject();
			if( jp != null) {
				List list = NewVisualiserUtils.getMarkupInfo(member, jp.getProject());
				for (Iterator iter = list.iterator(); iter.hasNext();) {
					Map map = (Map)iter.next();
					for (Iterator iterator = map.keySet().iterator(); iterator.hasNext();) {
						Integer lineNum = (Integer) iterator.next();
						List aspects = (List)map.get(lineNum);
						Stripe stripe = new Stripe(aspects, lineNum.intValue(), 1);
						stripeList.add(stripe);
						addMarkup(member.getFullname(), stripe);
					}
				}
			}
		}
		long mtime = System.currentTimeMillis();
		MarkupUtils.processStripes(stripeList);
		long etime = System.currentTimeMillis();
//		AJDTEventTrace.generalEvent(
//				"AJDTMarkupProvider.getMemberMarkups() executed (didn't hit cache) - took "+(etime-stime)+"ms "+
//				"("+(etime-mtime)+"ms stripe processing)");
		return stripeList;
	}
	
	
	/**
	 * Get all the markup kinds.
	 * @return a Set of Strings
	 */
	public SortedSet getAllMarkupKinds() {
		SortedSet kinds = new TreeSet(); 
		if(ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
			IJavaProject jp = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject();
			if( jp != null) {
				Set aspects = AspectVisualiserPlugin.getDefault().getAllAspects(jp);
				for (Iterator iter = aspects.iterator(); iter.hasNext();) {
					IResource aspectRes = (IResource) iter.next();
					String name = aspectRes.getName();
					name = name.substring(0, name.lastIndexOf("."));
					kinds.add(name);
				}
			}
		}
		if (kinds.size() > 0) {
			return kinds;
		} else {
			return null;
		}
	}

	
	/**
	 * Process a mouse click on a stripe.  This method opens the editor at the line of the stripe clicked.
	 * @see org.eclipse.contribution.visualiser.interfaces.IMarkupProvider#processMouseclick(java.lang.String, org.eclipse.contribution.visualiser.core.Stripe, int)
	 */
	public boolean processMouseclick(IMember member, Stripe stripe, String exactKind, int buttonClicked) {
		if (buttonClicked == 1) {
			if (member instanceof JDTMember) {
				IJavaElement jEl = ((JDTMember)member).getResource();
				if (jEl != null) {
					JDTUtils.openInEditor(jEl.getResource(), stripe.getOffset());
				}
			}
			return false;
		} else {
			return true;
		}
	}
	
	
	
	/**
	 * Reset the table of markups
	 */
	protected void resetMarkups() {
		markups = new Hashtable();
	}
	
}
