/* *******************************************************************
 * Copyright (c) 2003 Contributors.
 * All rights reserved. 
 * This program and the accompanying materials are made available 
 * under the terms of the Common Public License v1.0 
 * which accompanies this distribution and is available at 
 * http://www.eclipse.org/legal/cpl-v10.html 
 *  
 * Contributors: 
 *     Mik Kersten     initial implementation 
 * ******************************************************************/
 
package org.aspectj.ajdt.internal.compiler.lookup;

//import java.io.IOException;

import org.aspectj.asm.*;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.weaver.*;

/**
 * @author Mik Kersten
 */
public class AsmInterTypeRelationshipProvider {

	public static final String INTER_TYPE_DECLARES = "declared on";
	public static final String INTER_TYPE_DECLARED_BY = "aspect declarations";

	public static void addRelationship(
		ResolvedTypeX onType,
		EclipseTypeMunger munger) {
			
//		IProgramElement.Kind kind = IProgramElement.Kind.ERROR;
//		if (munger.getMunger().getKind() == ResolvedTypeMunger.Field) {
//			kind = IProgramElement.Kind.INTER_TYPE_FIELD;
//		} else if (munger.getMunger().getKind() == ResolvedTypeMunger.Constructor) {
//			kind = IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR;
//		} else if (munger.getMunger().getKind() == ResolvedTypeMunger.Method) {
//			kind = IProgramElement.Kind.INTER_TYPE_METHOD;
//		} else if (munger.getMunger().getKind() == ResolvedTypeMunger.Parent) {
//			kind = IProgramElement.Kind.INTER_TYPE_PARENT;
//		}  	 
	
		if (munger.getSourceLocation() != null
			&& munger.getSourceLocation() != null) {
			String sourceHandle = ProgramElement.createHandleIdentifier(
				munger.getSourceLocation().getSourceFile(),
				munger.getSourceLocation().getLine(),
				munger.getSourceLocation().getColumn());
				
			String targetHandle = ProgramElement.createHandleIdentifier(
				onType.getSourceLocation().getSourceFile(),
				onType.getSourceLocation().getLine(),
				onType.getSourceLocation().getColumn());
				
			IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
			if (sourceHandle != null && targetHandle != null) {
				IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, INTER_TYPE_DECLARES,false,true);
				foreward.addTarget(targetHandle);
				
				//foreward.getTargets().add(targetHandle); // You should check if its there before you add it again - but why would it already be there?  Why are we compiling whatever this thing is.
				
				IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, INTER_TYPE_DECLARED_BY,false,true);
				back.addTarget(sourceHandle);
				//back.getTargets().add(sourceHandle);  
			}
		}
	}
}
