/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class SWTGraphics
extends Graphics {
    public static boolean debug = false;
    private final Rectangle relativeClip;
    private int translateX = 0;
    private int translateY = 0;
    private List stack = new ArrayList();
    private int stackPointer = 0;
    private final State currentState = new State();
    private final State appliedState = new State();
    private GC gc;

    public SWTGraphics(GC gc) {
        gc.setLineWidth(1);
        this.gc = gc;
        this.relativeClip = new Rectangle(gc.getClipping());
        this.init();
    }

    public void clipRect(Rectangle rect) {
        this.relativeClip.intersect(rect);
        this.setClipAbsolute(this.relativeClip.x + this.translateX, this.relativeClip.y + this.translateY, this.relativeClip.width, this.relativeClip.height);
    }

    protected void init() {
        this.currentState.bgColor = this.appliedState.bgColor = this.gc.getBackground();
        this.currentState.fgColor = this.appliedState.fgColor = this.gc.getForeground();
        this.currentState.font = this.appliedState.font = this.gc.getFont();
        this.currentState.lineWidth = this.appliedState.lineWidth = this.gc.getLineWidth();
        this.currentState.lineStyle = this.appliedState.lineStyle = this.gc.getLineStyle();
        this.currentState.clipX = this.appliedState.clipX = this.relativeClip.x;
        this.currentState.clipY = this.appliedState.clipY = this.relativeClip.y;
        this.currentState.clipW = this.appliedState.clipW = this.relativeClip.width;
        this.currentState.clipH = this.appliedState.clipH = this.relativeClip.height;
        this.currentState.xor = this.appliedState.xor = this.gc.getXORMode();
    }

    protected final void checkFill() {
        if (!this.appliedState.bgColor.equals((Object)this.currentState.bgColor)) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
        this.checkGC();
    }

    protected final void checkGC() {
        if (this.appliedState.xor != this.currentState.xor) {
            this.appliedState.xor = this.currentState.xor;
            this.gc.setXORMode(this.appliedState.xor);
        }
        if (this.appliedState.clipX != this.currentState.clipX || this.appliedState.clipY != this.currentState.clipY || this.appliedState.clipW != this.currentState.clipW || this.appliedState.clipH != this.currentState.clipH) {
            this.appliedState.clipX = this.currentState.clipX;
            this.appliedState.clipY = this.currentState.clipY;
            this.appliedState.clipW = this.currentState.clipW;
            this.appliedState.clipH = this.currentState.clipH;
            this.gc.setClipping(this.appliedState.clipX, this.appliedState.clipY, this.appliedState.clipW, this.appliedState.clipH);
        }
    }

    protected final void checkPaint() {
        this.checkGC();
        if (!this.appliedState.fgColor.equals((Object)this.currentState.fgColor)) {
            this.appliedState.fgColor = this.currentState.fgColor;
            this.gc.setForeground(this.appliedState.fgColor);
        }
        if (this.appliedState.lineStyle != this.currentState.lineStyle) {
            this.appliedState.lineStyle = this.currentState.lineStyle;
            this.gc.setLineStyle(this.appliedState.lineStyle);
        }
        if (this.appliedState.lineWidth != this.currentState.lineWidth) {
            this.appliedState.lineWidth = this.currentState.lineWidth;
            this.gc.setLineWidth(this.appliedState.lineWidth);
        }
        if (!this.appliedState.bgColor.equals((Object)this.currentState.bgColor)) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
    }

    protected final void checkText() {
        this.checkPaint();
        this.checkFill();
        if (!this.appliedState.font.equals((Object)this.currentState.font)) {
            this.appliedState.font = this.currentState.font;
            this.gc.setFont(this.appliedState.font);
        }
    }

    public void drawArc(Rectangle r, int offset, int length) {
        this.checkPaint();
        this.gc.drawArc(r.x + this.translateX, r.y + this.translateY, r.width, r.height, offset, length);
    }

    public final void drawFocus(Rectangle r) {
        this.drawFocus(r.x, r.y, r.width, r.height);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.checkPaint();
        this.checkFill();
        this.gc.drawFocus(x + this.translateX, y + this.translateY, w + 1, h + 1);
    }

    public void fillArc(Rectangle r, int offset, int length) {
        this.checkFill();
        this.gc.fillArc(r.x + this.translateX, r.y + this.translateY, r.width, r.height, offset, length);
    }

    public void drawImage(Image srcImage, Point p) {
        this.drawImage(srcImage, p.x, p.y);
    }

    public void drawImage(Image srcImage, int x, int y) {
        this.checkGC();
        this.gc.drawImage(srcImage, x + this.translateX, y + this.translateY);
    }

    public void drawImage(Image srcImage, Rectangle src, Rectangle dest) {
        this.drawImage(srcImage, src.x, src.y, src.width, src.height, dest.x, dest.y, dest.width, dest.height);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.checkGC();
        this.gc.drawImage(srcImage, x1, y1, w1, h1, x2 + this.translateX, y2 + this.translateY, w2, h2);
    }

    public void drawLine(Point p1, Point p2) {
        this.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkPaint();
        this.gc.drawLine(x1 + this.translateX, y1 + this.translateY, x2 + this.translateX, y2 + this.translateY);
    }

    public void drawOval(Rectangle r) {
        this.checkPaint();
        this.gc.drawOval(r.x + this.translateX, r.y + this.translateY, r.width, r.height);
    }

    public void fillOval(Rectangle r) {
        this.checkFill();
        this.gc.fillOval(r.x + this.translateX, r.y + this.translateY, r.width, r.height);
    }

    public void drawPolygon(PointList points) {
        this.checkPaint();
        try {
            points.translate(this.translateX, this.translateY);
            this.gc.drawPolygon(points.toIntArray());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            points.translate(-this.translateX, -this.translateY);
            throw throwable;
        }
        Object var2_4 = null;
        points.translate(-this.translateX, -this.translateY);
    }

    public void fillPolygon(PointList points) {
        this.checkFill();
        try {
            points.translate(this.translateX, this.translateY);
            this.gc.fillPolygon(points.toIntArray());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            points.translate(-this.translateX, -this.translateY);
            throw throwable;
        }
        Object var2_4 = null;
        points.translate(-this.translateX, -this.translateY);
    }

    public void drawPolyline(PointList points) {
        this.checkPaint();
        try {
            points.translate(this.translateX, this.translateY);
            int[] array = points.toIntArray();
            this.gc.drawPolyline(array);
            if (this.getLineWidth() == 1 && array.length >= 2) {
                int x = array[array.length - 2];
                int y = array[array.length - 1];
                this.gc.drawLine(x, y, x, y);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            points.translate(-this.translateX, -this.translateY);
            throw throwable;
        }
        Object var5_7 = null;
        points.translate(-this.translateX, -this.translateY);
    }

    public void drawRectangle(Rectangle r) {
        this.drawRectangle(r.x, r.y, r.width, r.height);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawRectangle(x + this.translateX, y + this.translateY, width, height);
    }

    public void fillRectangle(Rectangle r) {
        this.fillRectangle(r.x, r.y, r.width, r.height);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.checkFill();
        this.gc.fillRectangle(x + this.translateX, y + this.translateY, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkPaint();
        this.gc.drawRoundRectangle(r.x + this.translateX, r.y + this.translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkFill();
        this.gc.fillRoundRectangle(r.x + this.translateX, r.y + this.translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void drawString(String s, Point p, Graphics.TransparencyFlag transparent) {
        this.drawString(s, p.x, p.y, transparent);
    }

    public void drawString(String s, int x, int y, Graphics.TransparencyFlag transparent) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, transparent.toBoolean());
    }

    public void drawString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, true);
    }

    public void fillString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, false);
    }

    public void drawText(String s, Point p, Graphics.TransparencyFlag transparent) {
        this.drawText(s, p.x, p.y, transparent);
    }

    public void drawText(String s, int x, int y, Graphics.TransparencyFlag transparent) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, transparent.toBoolean());
    }

    public void drawText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, true);
    }

    public void fillText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, false);
    }

    public int getAdvanceWidth(char c) {
        this.checkText();
        return this.gc.getAdvanceWidth(c);
    }

    public Color getBackgroundColor() {
        return this.currentState.bgColor;
    }

    public int getCharWidth(char c) {
        this.checkText();
        return this.gc.getCharWidth(c);
    }

    public Rectangle getClip(Rectangle rect) {
        rect.setBounds(this.relativeClip);
        return rect;
    }

    public Font getFont() {
        return this.currentState.font;
    }

    public FontMetrics getFontMetrics() {
        this.checkText();
        return this.gc.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.currentState.fgColor;
    }

    public int getLineStyle() {
        return this.currentState.lineStyle;
    }

    public int getLineWidth() {
        return this.currentState.lineWidth;
    }

    public Dimension getStringExtent(String text) {
        this.checkText();
        org.eclipse.swt.graphics.Point p = this.gc.stringExtent(text);
        return new Dimension(p.x, p.y);
    }

    public Dimension getTextExtent(String text) {
        this.checkText();
        org.eclipse.swt.graphics.Point p = this.gc.textExtent(text);
        return new Dimension(p.x, p.y);
    }

    public boolean getXORMode() {
        return this.currentState.xor;
    }

    public void popState() {
        this.restoreState((State)this.stack.get(this.stackPointer - 1));
        --this.stackPointer;
    }

    public void pushState() {
        try {
            if (this.stack.size() > this.stackPointer) {
                State s = (State)this.stack.get(this.stackPointer);
                s.copyFrom(this.currentState);
            } else {
                this.stack.add(this.currentState.clone());
            }
            ++this.stackPointer;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void restoreState() {
        this.restoreState((State)this.stack.get(this.stackPointer - 1));
    }

    protected void restoreState(State s) {
        this.setBackgroundColor(s.bgColor);
        this.setForegroundColor(s.fgColor);
        this.setLineStyle(s.lineStyle);
        this.setLineWidth(s.lineWidth);
        this.setFont(s.font);
        this.setXORMode(s.xor);
        this.setClipAbsolute(s.clipX, s.clipY, s.clipW, s.clipH);
        this.translateX = this.currentState.dx = s.dx;
        this.translateY = this.currentState.dy = s.dy;
        this.relativeClip.x = s.clipX - this.translateX;
        this.relativeClip.y = s.clipY - this.translateY;
        this.relativeClip.width = s.clipW;
        this.relativeClip.height = s.clipH;
    }

    public void scale(float factor) {
    }

    public void setBackgroundColor(Color color) {
        if (this.currentState.bgColor.equals((Object)color)) {
            return;
        }
        this.currentState.bgColor = color;
    }

    public void setClip(Rectangle rect) {
        this.relativeClip.x = rect.x;
        this.relativeClip.y = rect.y;
        this.relativeClip.width = rect.width;
        this.relativeClip.height = rect.height;
        this.setClipAbsolute(rect.x + this.translateX, rect.y + this.translateY, rect.width, rect.height);
    }

    protected void setClipAbsolute(int x, int y, int w, int h) {
        if (this.currentState.clipW == w && this.currentState.clipH == h && this.currentState.clipX == x && this.currentState.clipY == y) {
            return;
        }
        this.currentState.clipX = x;
        this.currentState.clipY = y;
        this.currentState.clipW = w;
        this.currentState.clipH = h;
    }

    public void setFont(Font f) {
        if (this.currentState.font == f) {
            return;
        }
        this.currentState.font = f;
    }

    public void setForegroundColor(Color color) {
        if (this.currentState.fgColor.equals((Object)color)) {
            return;
        }
        this.currentState.fgColor = color;
    }

    public void setLineStyle(int style) {
        if (this.currentState.lineStyle == style) {
            return;
        }
        this.currentState.lineStyle = style;
    }

    public void setLineWidth(int width) {
        if (this.currentState.lineWidth == width) {
            return;
        }
        this.currentState.lineWidth = width;
    }

    protected void setTranslation(int x, int y) {
        this.translateX = this.currentState.dx = x;
        this.translateY = this.currentState.dy = y;
    }

    public void setXORMode(boolean b) {
        if (this.currentState.xor == b) {
            return;
        }
        this.currentState.xor = b;
    }

    public final void translate(Point pt) {
        this.translate(pt.x, pt.y);
    }

    public void translate(int x, int y) {
        this.setTranslation(this.translateX + x, this.translateY + y);
        this.relativeClip.x -= x;
        this.relativeClip.y -= y;
    }

    protected static class State
    implements Cloneable {
        public Color bgColor;
        public Color fgColor;
        public int lineWidth;
        public int lineStyle;
        public int dx;
        public int dy;
        public Font font;
        public int clipX;
        public int clipY;
        public int clipW;
        public int clipH;
        public boolean xor;

        protected State() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void copyFrom(State state) {
            this.bgColor = state.bgColor;
            this.fgColor = state.fgColor;
            this.lineStyle = state.lineStyle;
            this.lineWidth = state.lineWidth;
            this.dx = state.dx;
            this.dy = state.dy;
            this.font = state.font;
            this.clipX = state.clipX;
            this.clipY = state.clipY;
            this.clipW = state.clipW;
            this.clipH = state.clipH;
            this.xor = state.xor;
        }
    }
}

