/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPaneLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;

public class ScrollPane
extends Figure {
    public static final int NEVER = 0;
    public static final int AUTOMATIC = 1;
    public static final int ALWAYS = 2;
    protected Viewport viewport;
    protected ScrollBar hBar;
    protected ScrollBar vBar;
    private int hVisibility = 1;
    private int vVisibility = 1;

    public ScrollPane() {
        this.setLayoutManager(new ScrollPaneLayout());
    }

    protected void createHorizontalScrollBar() {
        ScrollBar bar = new ScrollBar();
        bar.setHorizontal(true);
        this.setHorizontalScrollBar(bar);
    }

    protected void createViewport() {
        this.setViewport(new Viewport());
    }

    protected void createVerticalScrollBar() {
        ScrollBar bar = new ScrollBar();
        this.setVerticalScrollBar(bar);
    }

    public ScrollBar getHorizontalScrollBar() {
        if (this.hBar == null) {
            this.createHorizontalScrollBar();
        }
        return this.hBar;
    }

    public int getHorizontalScrollBarVisibility() {
        return this.hVisibility;
    }

    public ScrollBar getVerticalScrollBar() {
        if (this.vBar == null) {
            this.createVerticalScrollBar();
        }
        return this.vBar;
    }

    public int getVerticalScrollBarVisibility() {
        return this.vVisibility;
    }

    public IFigure getView() {
        return this.getViewport().getContents();
    }

    public Viewport getViewport() {
        if (this.viewport == null) {
            this.createViewport();
        }
        return this.viewport;
    }

    public boolean isOpaque() {
        return true;
    }

    public void scrollHorizontalTo(int x) {
        this.getViewport().setHorizontalLocation(x);
    }

    public void scrollTo(Point location) {
        this.scrollHorizontalTo(location.x);
        this.scrollVerticalTo(location.y);
    }

    public void scrollVerticalTo(int y) {
        this.getViewport().setVerticalLocation(y);
    }

    public void setHorizontalScrollBar(ScrollBar bar) {
        if (this.hBar != null) {
            this.remove(this.hBar);
            this.hBar.getRangeModel().removePropertyChangeListener(this.hBar);
        }
        this.hBar = bar;
        if (this.hBar != null) {
            this.add(this.hBar);
            this.hBar.setRangeModel(this.getViewport().getHorizontalRangeModel());
        }
    }

    public void setHorizontalScrollBarVisibility(int v) {
        if (this.hVisibility == v) {
            return;
        }
        this.hVisibility = v;
        this.revalidate();
    }

    public void setScrollBarVisibility(int v) {
        this.setHorizontalScrollBarVisibility(v);
        this.setVerticalScrollBarVisibility(v);
    }

    public void setVerticalScrollBar(ScrollBar bar) {
        if (this.vBar != null) {
            this.remove(this.vBar);
            this.vBar.getRangeModel().removePropertyChangeListener(this.vBar);
        }
        this.vBar = bar;
        if (this.vBar != null) {
            this.add(this.vBar);
            this.vBar.setRangeModel(this.getViewport().getVerticalRangeModel());
        }
    }

    public void setVerticalScrollBarVisibility(int v) {
        if (this.vVisibility == v) {
            return;
        }
        this.vVisibility = v;
        this.revalidate();
    }

    public void setView(IFigure figure) {
        this.getViewport().setContents(figure);
    }

    public void setViewport(Viewport vp) {
        if (this.viewport != null) {
            this.remove(this.viewport);
        }
        this.viewport = vp;
        if (vp != null) {
            this.add((IFigure)vp, 0);
        }
    }

    public void validate() {
        super.validate();
        this.getHorizontalScrollBar().validate();
        this.getVerticalScrollBar().validate();
    }
}

