/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ScrollPaneSolver {
    public static int NEVER = 0;
    public static int AUTOMATIC = 1;
    public static int ALWAYS = 2;

    public static Result solve(Rectangle $REFclientArea, Viewport viewport, int hVis, int vVis, int vBarWidth, int hBarHeight) {
        boolean none;
        Result result = new Result();
        Insets insets = new Insets();
        insets.bottom = hBarHeight;
        insets.right = vBarWidth;
        Dimension preferred = viewport.getPreferredSize().getCopy();
        Dimension available = $REFclientArea.getSize();
        Dimension guaranteed = new Dimension(available).shrink(vVis == NEVER ? 0 : insets.right, hVis == NEVER ? 0 : insets.bottom);
        Dimension viewportMinSize = viewport.getMinimumSize();
        if (viewport.getContentsTracksHeight()) {
            preferred.height = viewportMinSize.height;
        }
        if (viewport.getContentsTracksWidth()) {
            preferred.width = viewportMinSize.width;
        }
        boolean both = !(none = available.contains(preferred)) && preferred.containsProper(guaranteed);
        boolean showV = both || preferred.height > available.height;
        boolean showH = both || preferred.width > available.width;
        result.showV = vVis != NEVER && (showV || vVis == ALWAYS);
        boolean bl = result.showH = hVis != NEVER && (showH || hVis == ALWAYS);
        if (!result.showV) {
            insets.right = 0;
        }
        if (!result.showH) {
            insets.bottom = 0;
        }
        Rectangle viewportArea = $REFclientArea.getCropped(insets);
        viewport.setBounds(viewportArea);
        return result;
    }

    public static class Result {
        public boolean showH;
        public boolean showV;
    }
}

