/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferencePage;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.views.Menu;
import org.eclipse.contribution.visualiser.views.Visualiser;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class VisualiserPlugin
extends AbstractUIPlugin {
    public static int LOGLEVEL = 2;
    public static Visualiser visualiser;
    public static Menu menu;
    private static VisualiserPlugin plugin;
    private ResourceBundle resourceBundle;

    public VisualiserPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.contribution.visualiser.VisualiserPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static ProviderManager getProviderManager() {
        return ProviderManager.getProviderManager();
    }

    public static void refresh() {
        if (visualiser != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IViewPart iViewPart;
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow;
                    if (visualiser != null && (iWorkbenchWindow = VisualiserPlugin.getActiveWorkbenchWindow()) != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iViewPart = iWorkbenchPage.findView("org.eclipse.contribution.visualiser.views.Visualiser")) != null) {
                        visualiser.updateDisplay(true);
                    }
                }
            });
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static VisualiserPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = VisualiserPlugin.getDefault().getResourceBundle();
        if (resourceBundle == null) {
            return string;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void trace(String string) {
        System.err.println(string);
    }

    public void setVisualiser(Visualiser visualiser) {
        VisualiserPlugin.visualiser = visualiser;
        VisualiserPlugin.visualiser.setVisContentProvider(ProviderManager.getContentProvider());
        VisualiserPlugin.visualiser.setVisMarkupProvider(ProviderManager.getMarkupProvider());
        VisualiserPlugin.visualiser.setDemarcation(VisualiserPreferences.isDemarcationEnabled());
        VisualiserPlugin.visualiser.setMinStripeSize(VisualiserPreferences.getStripeSize());
    }

    public void removeVisualiser() {
        visualiser = null;
    }

    public void setMenu(Menu menu) {
        VisualiserPlugin.menu = menu;
        VisualiserPlugin.menu.setVisMarkupProvider(ProviderManager.getMarkupProvider());
    }

    public void removeMenu() {
        menu = null;
    }

    public static void log(int n, String string) {
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        ProviderManager.initialise();
        VisualiserPreferencePage.initDefaults();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
    }
}

