/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderDefinition;
import org.eclipse.contribution.visualiser.interfaces.IContentProvider;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.NullMarkupProvider;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.views.Visualiser;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ProviderManager {
    private static IContentProvider contentP = null;
    private static IMarkupProvider markupP = null;
    private static ProviderManager instance = new ProviderManager();
    private static List contentProviders;
    private static List markupProviders;
    private static ProviderDefinition currentPD;

    public static IContentProvider getContentProvider() {
        return contentP;
    }

    public static IMarkupProvider getMarkupProvider() {
        return markupP;
    }

    private ProviderManager() {
    }

    public static void initialise() {
        Object object;
        Object object2;
        int n;
        contentProviders = new ArrayList();
        markupProviders = new ArrayList();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.contribution.visualiser.providers");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
            for (n = 0; n < iConfigurationElementArray.length; ++n) {
                try {
                    String string;
                    String string2;
                    object2 = iConfigurationElementArray[n].createExecutableExtension("class");
                    if (!(object2 instanceof IContentProvider)) continue;
                    if (iConfigurationElementArray[n].getAttribute("markupclass") != null) {
                        markupP = (IMarkupProvider)iConfigurationElementArray[n].createExecutableExtension("markupclass");
                        markupP.initialise();
                    }
                    contentP = (IContentProvider)object2;
                    contentP.initialise();
                    object = new ProviderDefinition(iConfigurationElementArray[n].getAttribute("name"), contentP, markupP);
                    contentProviders.add(object);
                    String string3 = iConfigurationElementArray[n].getAttribute("description");
                    if (string3 != null) {
                        ((ProviderDefinition)object).setDescription(string3);
                    }
                    if ((string2 = iConfigurationElementArray[n].getAttribute("title")) != null) {
                        ((ProviderDefinition)object).setTitle(string2);
                    }
                    if ((string = iConfigurationElementArray[n].getAttribute("priority")) == null) continue;
                    try {
                        ((ProviderDefinition)object).setPriority(new Integer(string));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    exception.printStackTrace();
                }
            }
        }
        if (markupP == null) {
            markupP = new NullMarkupProvider();
        }
        if (contentProviders.size() != 0) {
            Collections.sort(contentProviders, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((ProviderDefinition)object2).getPriority() - ((ProviderDefinition)object).getPriority();
                }
            });
            String string = VisualiserPreferences.getProvider();
            boolean bl = false;
            for (n = 0; n < contentProviders.size(); ++n) {
                object2 = (ProviderDefinition)contentProviders.get(n);
                object = ((ProviderDefinition)object2).getName();
                if (!string.equals(object)) continue;
                ((ProviderDefinition)object2).setEnabled(true);
                bl = true;
                break;
            }
            if (!bl) {
                ProviderDefinition providerDefinition = (ProviderDefinition)contentProviders.get(0);
                providerDefinition.setEnabled(true);
            }
        }
        if (VisualiserPlugin.menu != null) {
            VisualiserPlugin.menu.reset();
        }
    }

    public static ProviderManager getProviderManager() {
        return instance;
    }

    public static ProviderDefinition[] getAllProviderDefinitions() {
        return contentProviders.toArray(new ProviderDefinition[0]);
    }

    public static ProviderDefinition getCurrent() {
        return currentPD;
    }

    public static void setCurrent(ProviderDefinition providerDefinition) {
        boolean bl = false;
        currentPD = providerDefinition;
        if (!contentP.equals(providerDefinition.getContentProvider())) {
            bl = true;
        }
        if (!markupP.equals(providerDefinition.getMarkupInstance())) {
            bl = true;
        }
        contentP = providerDefinition.getContentProvider();
        markupP = providerDefinition.getMarkupInstance();
        if (bl) {
            VisualiserPlugin.refresh();
            if (VisualiserPlugin.visualiser != null) {
                VisualiserPlugin.visualiser.setVisContentProvider(contentP);
                VisualiserPlugin.visualiser.setVisMarkupProvider(markupP);
            }
            if (VisualiserPlugin.menu != null) {
                VisualiserPlugin.menu.setVisMarkupProvider(markupP);
            }
        }
        String string = providerDefinition.getTitle();
        Visualiser visualiser = VisualiserPlugin.visualiser;
        if (visualiser != null) {
            if (string != null) {
                visualiser.refreshTitle(string);
            } else {
                visualiser.refreshTitle(providerDefinition.getName());
            }
        }
    }

    static {
        currentPD = null;
    }
}

