/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.interfaces.simpleImpl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleContentProvider;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleGroup;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMember;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class FileContentProvider
extends SimpleContentProvider {
    private static final boolean debugLoading = false;

    public void initialise() {
        URL uRL = VisualiserPlugin.getDefault().getBundle().getEntry("/");
        try {
            URL uRL2 = Platform.resolve((URL)uRL);
            URL uRL3 = new URL(uRL2, "Content.vis");
            String string = uRL3.getPath();
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            File file = new File(string);
            if (this.numberOfGroupsDefined() == 0 && file.exists()) {
                FileContentProvider.loadVisContents(string);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error loading content file: " + iOException);
        }
    }

    public static void log(int n, String string, Exception exception) {
        VisualiserPlugin.getDefault().getLog().log((IStatus)new Status(n, "org.eclipse.contribution.visualiser", 0, string, (Throwable)exception));
    }

    public static void loadVisContents(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            SimpleGroup simpleGroup = null;
            while (string2 != null && string2.length() != 0) {
                String string3;
                if (string2.startsWith("Group:")) {
                    string3 = FileContentProvider.retrieveKeyValue("Group:", string2);
                    simpleGroup = new SimpleGroup(string3);
                    FileContentProvider.addGroup(simpleGroup);
                } else if (string2.startsWith("Member:")) {
                    String string4;
                    string3 = FileContentProvider.retrieveKeyValue("Member:", string2);
                    SimpleMember simpleMember = new SimpleMember(string3);
                    String string5 = FileContentProvider.retrieveKeyValue("Size:", string2);
                    if (string5 != null) {
                        simpleMember.setSize(Integer.parseInt(string5));
                    }
                    if ((string4 = FileContentProvider.retrieveKeyValue("Tip:", string2)) != null) {
                        simpleMember.setTooltip(string4);
                    }
                    simpleGroup.add(simpleMember);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileContentProvider.log(4, "FileContentProvider failed to load file (FNF)", fileNotFoundException);
        }
        catch (IOException iOException) {
            FileContentProvider.log(4, "FileContentProvider failed to load file (FNF)", iOException);
        }
    }

    private static String retrieveKeyValue(String string, String string2) {
        if (string2.indexOf(string) == -1) {
            return null;
        }
        String string3 = string2.substring(string2.indexOf(string) + string.length());
        String string4 = string3;
        if (string4.indexOf(" ") != -1) {
            string4 = string3.substring(0, string3.indexOf(" "));
        }
        string4 = string4.replace('_', ' ');
        return string4;
    }

    public String getEmptyMessage() {
        return VisualiserPlugin.getResourceString("FileContentProvider_EmptyMessage");
    }
}

