/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.interfaces.simpleImpl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.contribution.visualiser.core.MarkupUtils;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.utils.ColorUtils;
import org.eclipse.swt.graphics.Color;

public class SimpleMarkupProvider
implements IMarkupProvider {
    private static Map colourMemory = new HashMap();
    private static Map availableColours = new HashMap();
    public Hashtable markups = null;
    public SortedSet markupKinds;

    public void initialise() {
    }

    public boolean changeMode() {
        return false;
    }

    public boolean hasMultipleModes() {
        return false;
    }

    public List getMemberMarkups(IMember iMember) {
        Object v;
        if (iMember != null && this.markups != null && (v = this.markups.get(iMember.getFullname())) != null && v instanceof List) {
            return (List)this.markups.get(iMember.getFullname());
        }
        return null;
    }

    public void addMarkup(String string, Stripe stripe) {
        ArrayList<Stripe> arrayList;
        if (this.markups == null) {
            this.markups = new Hashtable();
        }
        if ((arrayList = (ArrayList<Stripe>)this.markups.get(string)) == null) {
            arrayList = new ArrayList<Stripe>();
            arrayList.add(stripe);
            this.markups.put(string, arrayList);
        } else {
            arrayList.add(stripe);
        }
    }

    public void processMarkups() {
        Enumeration enumeration = this.markups.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            List list = (List)this.markups.get(string);
            MarkupUtils.processStripes(list);
        }
    }

    public List getGroupMarkups(IGroup iGroup) {
        ArrayList<Stripe> arrayList = new ArrayList<Stripe>();
        List list = iGroup.getMembers();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMember iMember = (IMember)iterator.next();
            List list2 = this.getMemberMarkups(iMember);
            if (list2 != null) {
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Stripe stripe = (Stripe)iterator2.next();
                    arrayList.add(new Stripe(stripe.getKinds(), stripe.getOffset() + n, stripe.getDepth()));
                }
            }
            n += iMember.getSize().intValue();
        }
        return arrayList;
    }

    public SortedSet getAllMarkupKinds() {
        if (this.markups == null) {
            return null;
        }
        if (this.markupKinds != null) {
            return this.markupKinds;
        }
        this.markupKinds = new TreeSet();
        Enumeration enumeration = this.markups.elements();
        while (enumeration.hasMoreElements()) {
            List list = (List)enumeration.nextElement();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Stripe stripe = (Stripe)iterator.next();
                this.markupKinds.addAll(stripe.getKinds());
            }
        }
        return this.markupKinds;
    }

    public Color getColorFor(String string) {
        Color color = null;
        String string2 = "not unique";
        String string3 = new String(string2 + ":" + string);
        if (colourMemory.containsKey(string3)) {
            color = (Color)colourMemory.get(string3);
        } else {
            color = this.getNextColourFor(string2);
            colourMemory.put(string3, color);
        }
        return color;
    }

    public void setColorFor(String string, Color color) {
        colourMemory.put("not unique:" + string, color);
    }

    private Color getNextColourFor(String string) {
        Color color;
        List list;
        if (!availableColours.containsKey(string.toString())) {
            list = new ArrayList(ColorUtils.getColorList());
            availableColours.put(string.toString(), list);
        }
        if (!(list = (List)availableColours.get(string.toString())).isEmpty()) {
            color = (Color)list.get(0);
            list.remove(0);
        } else {
            color = ColorUtils.getRandomColor();
        }
        return color;
    }

    public void resetColours() {
        availableColours = new HashMap();
        colourMemory = new HashMap();
    }

    public boolean processMouseclick(IMember iMember, Stripe stripe, String string, int n) {
        return true;
    }
}

