/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.internal.preference;

import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderDefinition;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class VisualiserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor stripeSizeSelector;
    private IntegerFieldEditor minBarSizeSelector;
    private IntegerFieldEditor maxBarSizeSelector;
    private Text descriptionText;
    private CheckboxTableViewer checkboxViewer;
    private BooleanFieldEditor demarcationSelector;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        TabFolder tabFolder = new TabFolder(composite2, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        Control control = this.createProviderControl(tabFolder);
        Control control2 = this.createDrawingOptionsControl(tabFolder);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Providers");
        tabItem.setControl(control);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Drawing Options");
        tabItem.setControl(control2);
        this.populateProviders();
        return composite2;
    }

    private Control createDrawingOptionsControl(TabFolder tabFolder) {
        GridLayout gridLayout = new GridLayout();
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)gridLayout);
        this.createStripeSizeArea(composite);
        this.createMinBarWidthArea(composite);
        this.createMaxBarWidthArea(composite);
        this.createDemarcationArea(composite);
        return composite;
    }

    private Control createProviderControl(TabFolder tabFolder) {
        GridLayout gridLayout = new GridLayout();
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)gridLayout);
        this.createProvidersArea(composite);
        this.createDescriptionArea(composite);
        return composite;
    }

    private void createMaxBarWidthArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1));
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        this.maxBarSizeSelector = new IntegerFieldEditor("org.eclipse.contribution.visualiser.preferences.maxbarwidth", VisualiserPlugin.getResourceString("VisualiserPreferencePage.maxBarSize"), composite2, 3);
        this.maxBarSizeSelector.setValidRange(10, 500);
        this.maxBarSizeSelector.setErrorMessage(VisualiserPlugin.getResourceString("VisualiserPreferencePage.maxBarErrorMessage"));
        this.maxBarSizeSelector.setPreferencePage((PreferencePage)this);
        this.maxBarSizeSelector.setPreferenceStore(VisualiserPlugin.getDefault().getPreferenceStore());
        this.maxBarSizeSelector.load();
    }

    private void createMinBarWidthArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1));
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        this.minBarSizeSelector = new IntegerFieldEditor("org.eclipse.contribution.visualiser.preferences.minbarwidth", VisualiserPlugin.getResourceString("VisualiserPreferencePage.minBarSize"), composite2, 3);
        this.minBarSizeSelector.setValidRange(1, 100);
        this.minBarSizeSelector.setErrorMessage(VisualiserPlugin.getResourceString("VisualiserPreferencePage.minBarErrorMessage"));
        this.minBarSizeSelector.setPreferencePage((PreferencePage)this);
        this.minBarSizeSelector.setPreferenceStore(VisualiserPlugin.getDefault().getPreferenceStore());
        this.minBarSizeSelector.load();
    }

    private void createStripeSizeArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1));
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        this.stripeSizeSelector = new IntegerFieldEditor("org.eclipse.contribution.visualiser.preferences.stripesize", VisualiserPlugin.getResourceString("VisualiserPreferencePage.stripeSize"), composite2, 2);
        this.stripeSizeSelector.setValidRange(1, 20);
        this.stripeSizeSelector.setErrorMessage(VisualiserPlugin.getResourceString("VisualiserPreferencePage.stripeSizeErrorMessage"));
        this.stripeSizeSelector.setPreferencePage((PreferencePage)this);
        this.stripeSizeSelector.setPreferenceStore(VisualiserPlugin.getDefault().getPreferenceStore());
        this.stripeSizeSelector.load();
    }

    private void createDemarcationArea(Composite composite) {
        this.demarcationSelector = new BooleanFieldEditor("org.eclipse.contribution.visualiser.preferences.demarcation", VisualiserPlugin.getResourceString("VisualiserPreferencePage.demarcation"), composite);
        this.demarcationSelector.setPreferencePage((PreferencePage)this);
        this.demarcationSelector.setPreferenceStore(VisualiserPlugin.getDefault().getPreferenceStore());
        this.demarcationSelector.load();
    }

    private void createProvidersArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(VisualiserPlugin.getResourceString("VisualiserPreferencePage.providersLabel"));
        label.setFont(font);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2180);
        this.checkboxViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.checkboxViewer.getTable().setFont(composite2.getFont());
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((ProviderDefinition)object).getName();
            }
        });
        this.checkboxViewer.getTable().setFont(font);
        this.checkboxViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return (Object[])object;
            }
        });
        this.checkboxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    ProviderDefinition providerDefinition = (ProviderDefinition)iStructuredSelection.getFirstElement();
                    if (providerDefinition == null) {
                        VisualiserPreferencePage.this.clearDescription();
                    } else {
                        VisualiserPreferencePage.this.showDescription(providerDefinition);
                    }
                }
            }
        });
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                VisualiserPreferencePage.this.checkboxViewer.setAllChecked(false);
                VisualiserPreferencePage.this.checkboxViewer.setChecked(checkStateChangedEvent.getElement(), true);
                VisualiserPreferencePage.this.checkboxViewer.setSelection((ISelection)new StructuredSelection(checkStateChangedEvent.getElement()), true);
            }
        });
    }

    private void createDescriptionArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(VisualiserPlugin.getResourceString("VisualiserPreferencePage.description"));
        label.setFont(font);
        this.descriptionText = new Text(composite2, 2378);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setFont(font);
    }

    private void populateProviders() {
        ProviderDefinition[] providerDefinitionArray = this.getAllDefinitions();
        this.checkboxViewer.setInput((Object)providerDefinitionArray);
        for (int i = 0; i < providerDefinitionArray.length; ++i) {
            this.checkboxViewer.setChecked((Object)providerDefinitionArray[i], providerDefinitionArray[i].isEnabled());
            if (!providerDefinitionArray[i].isEnabled()) continue;
            this.showDescription(providerDefinitionArray[i]);
        }
    }

    private void showDescription(ProviderDefinition providerDefinition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String string = providerDefinition.getDescription();
        if (string == null || string.length() == 0) {
            this.descriptionText.setText(VisualiserPlugin.getResourceString("VisualiserPreferencePage.noDescription"));
        } else {
            this.descriptionText.setText(string);
        }
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    protected void performDefaults() {
        super.performDefaults();
        this.demarcationSelector.loadDefault();
        this.maxBarSizeSelector.loadDefault();
        this.minBarSizeSelector.loadDefault();
        this.stripeSizeSelector.loadDefault();
    }

    public boolean performOk() {
        if (super.performOk()) {
            ProviderDefinition[] providerDefinitionArray = ProviderManager.getAllProviderDefinitions();
            for (int i = 0; i < providerDefinitionArray.length; ++i) {
                boolean bl = this.checkboxViewer.getChecked((Object)providerDefinitionArray[i]);
                providerDefinitionArray[i].setEnabled(bl);
            }
            try {
                VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.stripesize", this.stripeSizeSelector.getIntValue());
                VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.demarcation", this.demarcationSelector.getBooleanValue());
                VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.minbarwidth", this.minBarSizeSelector.getIntValue());
                VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.maxbarwidth", this.maxBarSizeSelector.getIntValue());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (VisualiserPlugin.visualiser != null) {
                VisualiserPlugin.visualiser.updateSettingsFromPreferences();
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public static void initDefaults() {
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.demarcation", true);
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.provider", "");
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.stripesize", 3);
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.minbarwidth", 20);
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.maxbarwidth", 60);
    }

    private ProviderDefinition[] getAllDefinitions() {
        return ProviderManager.getAllProviderDefinitions();
    }
}

