/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.internal.preference;

import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VisualiserPreferencesDialog
extends Dialog
implements IPreferencePageContainer {
    public static final String PREF_DLG_TITLE_IMG = "visualiser_preference_dialog_title_image";
    public static final String PREF_DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    private Label titleImage;
    private CLabel messageLabel;
    protected Color titleAreaColor;
    private String message = "";
    private Composite titleArea;
    private Color normalMsgAreaBackground;
    private Color errorMsgAreaBackground;
    private Image messageImage;
    private Image errorMsgImage;
    private boolean showingError = false;
    private VisualiserPreferencePage visPage;
    private String errorMessage;
    static /* synthetic */ Class class$org$eclipse$jface$preference$PreferenceDialog;

    public VisualiserPreferencesDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(VisualiserPlugin.getResourceString("VisualiserPreferencePage.title"));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        this.createTitleArea(composite3);
        Composite composite4 = this.createPageContainer(composite2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 400;
        gridData.widthHint = 450;
        composite4.setLayoutData((Object)gridData);
        composite4.setFont(composite.getFont());
        Label label = new Label(composite2, 258);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        return composite2;
    }

    private Composite createTitleArea(Composite composite) {
        this.titleArea = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        Display display = composite.getDisplay();
        Color color = JFaceColors.getBannerBackground((Display)display);
        Color color2 = JFaceColors.getBannerForeground((Display)display);
        GridData gridData = new GridData(1808);
        this.titleArea.setLayout((Layout)gridLayout);
        this.titleArea.setLayoutData((Object)gridData);
        this.titleArea.setBackground(color);
        RGB rGB = new RGB(171, 168, 165);
        final Color color3 = new Color((Device)this.titleArea.getDisplay(), rGB);
        this.titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.setForeground(color3);
                Rectangle rectangle = VisualiserPreferencesDialog.this.titleArea.getClientArea();
                rectangle.height -= 2;
                --rectangle.width;
                paintEvent.gc.drawRectangle(rectangle);
            }
        });
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (VisualiserPreferencesDialog.this.titleAreaColor != null) {
                    VisualiserPreferencesDialog.this.titleAreaColor.dispose();
                }
                if (VisualiserPreferencesDialog.this.errorMsgAreaBackground != null) {
                    VisualiserPreferencesDialog.this.errorMsgAreaBackground.dispose();
                }
                color3.dispose();
            }
        });
        this.messageLabel = new CLabel(this.titleArea, 16384);
        JFaceColors.setColors((Control)this.messageLabel, (Color)color2, (Color)color);
        this.messageLabel.setText(" ");
        this.messageLabel.setFont(JFaceResources.getBannerFont());
        GridData gridData2 = new GridData(1808);
        this.messageLabel.setLayoutData((Object)gridData2);
        this.titleImage = new Label(this.titleArea, 16384);
        this.titleImage.setBackground(color);
        this.titleImage.setImage(JFaceResources.getImage((String)PREF_DLG_TITLE_IMG));
        gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        this.titleImage.setLayoutData((Object)gridData2);
        return this.titleArea;
    }

    public void setErrorMessage(String string) {
        if (this.errorMessage == null ? string == null : this.errorMessage.equals(string)) {
            return;
        }
        this.errorMessage = string;
        if (this.errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
                this.messageLabel.setBackground(this.normalMsgAreaBackground);
                this.messageLabel.setImage(null);
                this.titleImage.setImage(JFaceResources.getImage((String)PREF_DLG_TITLE_IMG));
            }
            if (this.message == null) {
                this.message = "";
            }
            this.messageLabel.setText(this.message);
            this.messageLabel.setImage(this.messageImage);
            this.messageLabel.setToolTipText(this.message);
        } else {
            this.messageLabel.setText(this.errorMessage);
            this.messageLabel.setToolTipText(this.errorMessage);
            if (!this.showingError) {
                this.showingError = true;
                if (this.errorMsgAreaBackground == null) {
                    this.errorMsgAreaBackground = JFaceColors.getErrorBackground((Display)this.messageLabel.getDisplay());
                    this.errorMsgImage = JFaceResources.getImage((String)PREF_DLG_IMG_TITLE_ERROR);
                }
                this.normalMsgAreaBackground = this.messageLabel.getBackground();
                this.messageLabel.setBackground(this.errorMsgAreaBackground);
                this.messageLabel.setImage(this.errorMsgImage);
                this.titleImage.setImage(null);
            }
        }
        this.titleArea.layout(true);
    }

    private Composite createPageContainer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        this.visPage = new VisualiserPreferencePage();
        this.visPage.setContainer(this);
        this.visPage.setTitle(VisualiserPlugin.getResourceString("VisualiserPreferencePage.title"));
        if (this.visPage.getControl() == null) {
            this.visPage.createControl(composite2);
        }
        return composite2;
    }

    public IPreferenceStore getPreferenceStore() {
        return VisualiserPlugin.getDefault().getPreferenceStore();
    }

    public void updateButtons() {
    }

    public void setMessage(String string) {
        this.setMessage(string, 0);
    }

    public void setMessage(String string, int n) {
        Image image = null;
        if (string != null) {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    image = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    image = JFaceResources.getImage((String)PREF_DLG_IMG_TITLE_ERROR);
                }
            }
        }
        this.showMessage(string, image);
    }

    private void showMessage(String string, Image image) {
        if (this.message.equals(string) && this.messageImage == image) {
            return;
        }
        this.message = string;
        if (this.message == null) {
            this.message = "";
        }
        this.messageImage = image;
        if (!this.showingError) {
            this.messageLabel.setText(this.message);
            this.messageLabel.setImage(this.messageImage);
            this.messageLabel.setToolTipText(this.message);
        }
    }

    public void updateMessage() {
        String string = this.visPage.getMessage();
        int n = 0;
        if (string != null && this.visPage instanceof IMessageProvider) {
            n = this.visPage.getMessageType();
        }
        String string2 = this.visPage.getErrorMessage();
        if (string == null && string2 == null) {
            this.messageLabel.setFont(JFaceResources.getBannerFont());
        } else {
            this.messageLabel.setFont(JFaceResources.getDialogFont());
        }
        if (string == null) {
            this.setMessage(this.visPage.getTitle());
        } else {
            this.setMessage(string, n);
        }
        this.setErrorMessage(string2);
    }

    public void updateTitle() {
    }

    protected void okPressed() {
        this.visPage.performOk();
        super.okPressed();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        imageRegistry.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile((Class)(class$org$eclipse$jface$preference$PreferenceDialog == null ? (class$org$eclipse$jface$preference$PreferenceDialog = VisualiserPreferencesDialog.class$("org.eclipse.jface.preference.PreferenceDialog")) : class$org$eclipse$jface$preference$PreferenceDialog), (String)"images/pref_dialog_title.gif"));
    }
}

