/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.jdtimpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.resources.VisualiserImages;
import org.eclipse.contribution.visualiser.interfaces.IContentProvider;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtimpl.JDTGroup;
import org.eclipse.contribution.visualiser.jdtimpl.JDTMember;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class JDTContentProvider
implements IContentProvider,
ISelectionListener {
    protected IJavaProject currentProject;
    private IResource currentlySelectedResource;
    protected IJavaElement currentlySelectedJE;

    protected int getLength(ICompilationUnit iCompilationUnit) {
        int n = 0;
        try {
            String string = iCompilationUnit.getSource();
            while (string.indexOf("\n") != -1) {
                ++n;
                string = string.substring(string.indexOf("\n") + 1);
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return n;
    }

    public void trace(String string) {
        System.err.println(string);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!ProviderManager.getContentProvider().equals(this)) {
            return;
        }
        boolean bl = false;
        try {
            if (iSelection instanceof IStructuredSelection) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                Object object = iStructuredSelection.getFirstElement();
                if (object != null) {
                    if (object instanceof IResource) {
                        this.currentlySelectedResource = (IResource)object;
                    } else if (object instanceof IJavaElement) {
                        IJavaElement iJavaElement;
                        this.currentlySelectedJE = iJavaElement = (IJavaElement)object;
                        if (iJavaElement.getUnderlyingResource() != null) {
                            if (!iJavaElement.getUnderlyingResource().equals(this.currentlySelectedResource)) {
                                bl = true;
                            }
                            this.currentlySelectedResource = iJavaElement.getUnderlyingResource();
                        }
                        if (iJavaElement.getJavaProject() != null) {
                            this.setCurrentProject(iJavaElement.getJavaProject());
                        }
                    }
                }
            } else if (iSelection instanceof ITextSelection) {
                // empty if block
            }
            if (bl) {
                VisualiserPlugin.refresh();
            }
        }
        catch (JavaModelException javaModelException) {
            System.err.println("Exception in JDTContentProvider.selectionChanged processing" + (Object)((Object)javaModelException));
        }
    }

    public List getAllMembers(IGroup iGroup) {
        return iGroup.getMembers();
    }

    public List getAllMembers() {
        ArrayList<JDTMember> arrayList;
        block5: {
            block6: {
                block4: {
                    arrayList = null;
                    if (!(this.currentlySelectedResource instanceof IProject) || this.currentlySelectedJE instanceof IPackageFragment) break block4;
                    arrayList = new ArrayList<JDTMember>();
                    if (this.getCurrentProject() == null) break block5;
                    List list = this.getAllJDTGroups(this.getCurrentProject());
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        IGroup iGroup = (IGroup)iterator.next();
                        arrayList.addAll(iGroup.getMembers());
                    }
                    break block5;
                }
                if (!(this.currentlySelectedJE instanceof IPackageFragment)) break block6;
                arrayList = new ArrayList();
                JDTGroup jDTGroup = this.getGroupForFragment((IPackageFragment)this.currentlySelectedJE);
                if (jDTGroup == null) break block5;
                arrayList.addAll(jDTGroup.getMembers());
                break block5;
            }
            if (this.currentlySelectedJE instanceof IJavaElement) {
                arrayList = new ArrayList();
                List list = this.getAllJDTGroups(this.getCurrentProject());
                Iterator iterator = list.iterator();
                block1: while (iterator.hasNext()) {
                    IGroup iGroup = (IGroup)iterator.next();
                    List list2 = iGroup.getMembers();
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        JDTMember jDTMember = (JDTMember)iterator2.next();
                        if (!jDTMember.getResource().equals(this.currentlySelectedJE)) continue;
                        arrayList.add(jDTMember);
                        continue block1;
                    }
                }
            }
        }
        return arrayList;
    }

    public void initialise() {
        if (VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
            VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        }
    }

    public boolean processMouseclick(IMember iMember, boolean bl, int n) {
        IJavaElement iJavaElement;
        if (n != 1) {
            return true;
        }
        if (bl) {
            return false;
        }
        if (iMember instanceof JDTMember && (iJavaElement = ((JDTMember)iMember).getResource()) != null) {
            JDTUtils.openInEditor(iJavaElement.getResource(), JDTUtils.getClassDeclLineNum(iJavaElement));
        }
        return false;
    }

    public List getAllGroups() {
        List<IGroup> list = null;
        if (this.currentlySelectedResource instanceof IProject && !(this.currentlySelectedJE instanceof IPackageFragment)) {
            list = this.getAllJDTGroups(this.getCurrentProject());
        } else if (this.currentlySelectedJE instanceof IPackageFragment) {
            list = new ArrayList();
            JDTGroup jDTGroup = this.getGroupForFragment((IPackageFragment)this.currentlySelectedJE);
            list.add(jDTGroup);
        } else if (this.currentlySelectedJE instanceof IJavaElement) {
            list = new ArrayList();
            List list2 = this.getAllJDTGroups(this.getCurrentProject());
            Iterator iterator = list2.iterator();
            block0: while (iterator.hasNext()) {
                IGroup iGroup = (IGroup)iterator.next();
                List list3 = iGroup.getMembers();
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    JDTMember jDTMember = (JDTMember)iterator2.next();
                    if (!jDTMember.getResource().equals(this.currentlySelectedJE)) continue;
                    list.add(jDTMember.getContainingGroup());
                    continue block0;
                }
            }
        }
        return list;
    }

    public JDTGroup getGroupForFragment(IPackageFragment iPackageFragment) {
        JDTGroup jDTGroup = null;
        try {
            if (iPackageFragment.getKind() != 2) {
                if (iPackageFragment.isDefaultPackage()) {
                    if (iPackageFragment.containsJavaResources()) {
                        jDTGroup = new JDTGroup("[default]");
                    }
                } else {
                    jDTGroup = new JDTGroup(iPackageFragment.getElementName());
                }
                if (jDTGroup != null) {
                    List list = this.getAllJDTMembers(iPackageFragment);
                    if (list.size() == 0) {
                        return null;
                    }
                    jDTGroup.addMembers(list);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return jDTGroup;
    }

    public List getAllJDTGroups(IJavaProject iJavaProject) {
        LinkedList<JDTGroup> linkedList = new LinkedList<JDTGroup>();
        try {
            IPackageFragment[] iPackageFragmentArray = iJavaProject.getPackageFragments();
            for (int i = 0; i < iPackageFragmentArray.length; ++i) {
                JDTGroup jDTGroup = this.getGroupForFragment(iPackageFragmentArray[i]);
                if (jDTGroup == null) continue;
                linkedList.add(jDTGroup);
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return linkedList;
    }

    public List getAllJDTMembers(IPackageFragment iPackageFragment) {
        LinkedList<JDTMember> linkedList = new LinkedList<JDTMember>();
        try {
            if (this.containsUsefulStuff(iPackageFragment)) {
                IJavaElement[] iJavaElementArray = iPackageFragment.getChildren();
                for (int i = 0; i < iJavaElementArray.length; ++i) {
                    if (iJavaElementArray[i].getElementType() != 5) continue;
                    String string = iJavaElementArray[i].getElementName();
                    if (string.endsWith(".java")) {
                        string = string.substring(0, string.length() - 5);
                    }
                    JDTMember jDTMember = new JDTMember(string, iJavaElementArray[i]);
                    jDTMember.setSize(this.getLength((ICompilationUnit)iJavaElementArray[i]));
                    linkedList.add(jDTMember);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            System.err.println((Object)javaModelException);
        }
        return linkedList;
    }

    protected boolean containsUsefulStuff(IPackageFragment iPackageFragment) {
        try {
            IPackageFragmentRoot iPackageFragmentRoot;
            if (iPackageFragment.getKind() == 3 && (iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment).getKind() == 2) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return true;
    }

    public String getEmptyMessage() {
        return VisualiserPlugin.getResourceString("JDTContentProvider_EmptyMessage");
    }

    public ImageDescriptor getMemberViewIcon() {
        return VisualiserImages.CLASS_VIEW;
    }

    public ImageDescriptor getGroupViewIcon() {
        return VisualiserImages.PACKAGE_VIEW;
    }

    protected void setCurrentProject(IJavaProject iJavaProject) {
        this.currentProject = iJavaProject;
    }

    public IJavaProject getCurrentProject() {
        return this.currentProject;
    }
}

