/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.jdtimpl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.MarkupUtils;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.jdtimpl.JDTMember;
import org.eclipse.contribution.visualiser.jdtimpl.JDTSearchResultsContentProvider;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.ui.IPropertyListener;

public class JDTSearchResultsMarkupProvider
extends SimpleMarkupProvider {
    private static Hashtable markupCache = new Hashtable();
    private static boolean isJavaSearch = false;
    private static JavaSearchResult javaSearchResult = null;

    public static void resetCache() {
        markupCache.clear();
    }

    public List getMemberMarkups(IMember iMember) {
        IJavaProject iJavaProject;
        List<Stripe> list;
        if (javaSearchResult == null) {
            return null;
        }
        List list2 = (List)markupCache.get(iMember);
        if (list2 != null) {
            return list2;
        }
        if (this.markups != null && this.markups.containsKey(iMember.getFullname()) && (list = (List)this.markups.get(iMember.getFullname())) != null) {
            return list;
        }
        list = new ArrayList();
        if (ProviderManager.getContentProvider() instanceof JDTSearchResultsContentProvider && (iJavaProject = ((JDTSearchResultsContentProvider)ProviderManager.getContentProvider()).getCurrentProject()) != null) {
            List list3 = this.getMarkupInfo(iMember);
            if (list3 == null) {
                return null;
            }
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                if (javaSearchResult == null) continue;
                Stripe stripe = new Stripe(javaSearchResult.getLabel(), n);
                list.add(stripe);
                this.addMarkup(iMember.getFullname(), stripe);
            }
        }
        MarkupUtils.processStripes(list);
        markupCache.put(iMember, list);
        return list;
    }

    private List getMarkupInfo(IMember iMember) {
        Object[] objectArray;
        if (javaSearchResult == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ICompilationUnit iCompilationUnit = null;
        IResource iResource = null;
        if (iMember instanceof JDTMember) {
            JDTMember jDTMember = (JDTMember)iMember;
            objectArray = jDTMember.getResource();
            if (objectArray.getElementType() == 5) {
                iCompilationUnit = (ICompilationUnit)objectArray;
                try {
                    iResource = iCompilationUnit.getUnderlyingResource();
                }
                catch (JavaModelException javaModelException) {
                    javaModelException.printStackTrace();
                }
            }
        } else {
            return null;
        }
        objectArray = javaSearchResult.getElements();
        for (int i = 0; i < objectArray.length; ++i) {
            IFile iFile = javaSearchResult.getFile(objectArray[i]);
            if (iFile == null || !iFile.getFullPath().equals(iResource.getFullPath())) continue;
            Match[] matchArray = javaSearchResult.computeContainedMatches((AbstractTextSearchResult)javaSearchResult, iFile);
            for (int j = 0; j < matchArray.length; ++j) {
                int n = JDTUtils.getLineNumber(iCompilationUnit, matchArray[j].getOffset());
                arrayList.add(new Integer(n));
            }
        }
        return arrayList;
    }

    public SortedSet getAllMarkupKinds() {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (ProviderManager.getContentProvider() instanceof JDTSearchResultsContentProvider && javaSearchResult != null) {
            treeSet.add(javaSearchResult.getLabel());
        }
        if (treeSet.size() > 0) {
            return treeSet;
        }
        return null;
    }

    public boolean processMouseclick(IMember iMember, Stripe stripe, String string, int n) {
        if (n == 1) {
            IJavaElement iJavaElement;
            if (iMember instanceof JDTMember && (iJavaElement = ((JDTMember)iMember).getResource()) != null) {
                JDTUtils.openInEditor(iJavaElement.getResource(), stripe.getOffset());
            }
            return false;
        }
        return true;
    }

    protected void resetMarkups() {
        this.markups = new Hashtable();
    }

    public boolean isJavaSearch() {
        return isJavaSearch;
    }

    public void setJavaSearch(boolean bl) {
        isJavaSearch = bl;
    }

    public void setJavaSearchResult(JavaSearchResult javaSearchResult) {
        JDTSearchResultsMarkupProvider.javaSearchResult = javaSearchResult;
    }

    static class VisualiserPropertyListener
    implements IPropertyListener {
        VisualiserPropertyListener() {
        }

        public void propertyChanged(Object object, int n) {
            if (object instanceof SearchView) {
                SearchView searchView = (SearchView)object;
                ISearchResult iSearchResult = searchView.getCurrentSearchResult();
                if (iSearchResult instanceof JavaSearchResult) {
                    isJavaSearch = true;
                    if (!((JavaSearchResult)iSearchResult).equals(javaSearchResult)) {
                        JDTSearchResultsMarkupProvider.resetCache();
                    }
                    JDTSearchResultsMarkupProvider.javaSearchResult = (JavaSearchResult)iSearchResult;
                } else {
                    isJavaSearch = false;
                    JDTSearchResultsMarkupProvider.javaSearchResult = null;
                    VisualiserPlugin.refresh();
                }
            }
        }
    }
}

