/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.views.BarButton;
import org.eclipse.contribution.visualiser.views.RectangleData;
import org.eclipse.contribution.visualiser.views.TraversableRectangleFigure;
import org.eclipse.contribution.visualiser.views.Visualiser;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class BarDrawing {
    private boolean absolute_proportions;
    private boolean continueWithAbsoluteProportions;
    private static int LOGLEVEL = 0;
    private MouseMotionListener locationListener;
    private boolean mouseInARectangle = false;
    private Shape mouseInThisRectangle;
    private Action onlyShowAction;
    private Menu rCMenu;
    private int spacing = 3;
    int maxBarWidth = 60;
    int minBarWidth = 20;
    int highlightDepth = 1;
    private int selectedColumn = -1;
    private int classNum = -1;
    private int lineNum = -1;
    private float zoom = 1.0f;
    private float max_zoom = 5.0f;
    private float scale;
    private boolean demarcation = true;
    private Shape[] rectangles;
    private Vector[] lineNums;
    private IFigure panel = new Figure();
    private MouseListener mouseListener = new MouseListener(){

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                if (mouseEvent.getSource() instanceof TraversableRectangleFigure) {
                    TraversableRectangleFigure traversableRectangleFigure = (TraversableRectangleFigure)((Object)mouseEvent.getSource());
                    traversableRectangleFigure.requestFocus();
                }
            } else if (mouseEvent.getSource() instanceof Figure && !(mouseEvent.getSource() instanceof RectangleFigure)) {
                BarDrawing.this.log(3, "Processing button3 click on Figure");
                VisualiserPlugin.visualiser.handleClick(null, null, null, mouseEvent.button);
            } else if (mouseEvent.getSource() instanceof RectangleFigure) {
                BarDrawing.this.log(3, "Processing button click on a rectangle");
                BarDrawing.this.selectedColumn = -1;
                RectangleFigure rectangleFigure = (RectangleFigure)mouseEvent.getSource();
                RectangleData rectangleData = (RectangleData)BarDrawing.this.rectangleTable.get(rectangleFigure);
                BarDrawing.this.log(3, "You clicked: " + rectangleData.toString());
                VisualiserPlugin.visualiser.handleClick(rectangleData.mem, rectangleData.kind, rectangleData.stripe, mouseEvent.button);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClicked(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                if (mouseEvent.getSource() instanceof RectangleFigure) {
                    BarDrawing.this.log(3, "Processing button click on a rectangle");
                    BarDrawing.this.selectedColumn = -1;
                    RectangleFigure rectangleFigure = (RectangleFigure)mouseEvent.getSource();
                    RectangleData rectangleData = (RectangleData)BarDrawing.this.rectangleTable.get(rectangleFigure);
                    BarDrawing.this.log(3, "You clicked: " + rectangleData.toString());
                    VisualiserPlugin.visualiser.handleClick(rectangleData.mem, rectangleData.kind, rectangleData.stripe, mouseEvent.button);
                } else {
                    VisualiserPlugin.visualiser.handleClick(null, null, null, mouseEvent.button);
                }
            }
        }
    };
    private BarButton[] columnButtons;
    private boolean limit_mode = false;
    public Rectangle viewsize;
    private List whatToDisplay;
    public static Control canvas;
    private static BarDrawing singleton;
    boolean alreadyInDrawMethod = false;
    Hashtable rectangleTable;
    Map[] markups;

    public static BarDrawing getBarDrawing() {
        if (singleton == null) {
            singleton = new BarDrawing();
        }
        return singleton;
    }

    private BarDrawing() {
        this.locationListener = new MouseMotionListener(){

            public void mouseEntered(MouseEvent mouseEvent) {
                BarDrawing.this.mouseInARectangle = true;
                BarDrawing.this.mouseInThisRectangle = (Shape)((RectangleFigure)mouseEvent.getSource());
            }

            public void mouseExited(MouseEvent mouseEvent) {
                BarDrawing.this.mouseInARectangle = false;
            }

            public void mouseHover(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }
        };
    }

    private void fillRightClickMenu(MenuManager menuManager) {
        this.onlyShowAction = new Action(){

            public void run() {
                VisualiserPlugin.visualiser.onlyShowColorsAffecting(((Label)BarDrawing.this.mouseInThisRectangle.getToolTip()).getText());
            }
        };
        this.onlyShowAction.setText(VisualiserPlugin.getResourceString("OnlyShow"));
        menuManager.add((IAction)this.onlyShowAction);
    }

    public void draw(List list, Canvas canvas, boolean bl) {
        Label label;
        int n;
        if (this.alreadyInDrawMethod) {
            return;
        }
        if (canvas == null) {
            return;
        }
        Control[] controlArray = canvas.getChildren();
        for (n = 0; n < controlArray.length; ++n) {
            controlArray[n].dispose();
        }
        this.setAbsoluteProportions(bl);
        this.alreadyInDrawMethod = true;
        BarDrawing.canvas = canvas;
        this.clearPanel();
        this.whatToDisplay = list;
        if (this.whatToDisplay == null) {
            this.whatToDisplay = Visualiser.contentP.getAllGroups();
        }
        n = list == null ? 0 : list.size();
        this.rectangles = new Shape[n];
        if (this.rectangleTable != null) {
            this.rectangleTable.clear();
        } else {
            this.rectangleTable = new Hashtable();
        }
        this.lineNums = new Vector[n];
        if (this.panel != null) {
            this.panel.removeMouseListener(this.mouseListener);
        }
        this.panel = new Figure();
        this.panel.addMouseListener(this.mouseListener);
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMinorSpacing(this.spacing);
        this.panel.setLayoutManager((LayoutManager)flowLayout);
        this.panel.setBorder((Border)new LineBorder(ColorConstants.menuBackground, 5));
        this.viewsize = canvas.getParent().getClientArea();
        if (this.zoom > 1.0f) {
            this.viewsize.width = (int)((float)this.viewsize.width * this.zoom);
            this.viewsize.height = (int)((float)this.viewsize.height * this.zoom);
        }
        LightweightSystem lightweightSystem = new LightweightSystem(canvas);
        lightweightSystem.setContents(this.panel);
        if (n > 0) {
            if (bl) {
                this.addShapesAndKeepProportions(n, this.viewsize, canvas.getParent().getClientArea());
            } else {
                this.addShapes(n, this.viewsize);
            }
        } else {
            label = new Label(Visualiser.contentP.getEmptyMessage());
            this.panel.add((IFigure)label);
        }
        label = canvas.getSize();
        org.eclipse.swt.graphics.Point point = this.zoom > 1.0f || this.absolute_proportions ? new org.eclipse.swt.graphics.Point(Math.max(this.panel.getPreferredSize().width, canvas.getParent().getClientArea().width), Math.max(canvas.getParent().getClientArea().height, this.panel.getPreferredSize().height)) : new org.eclipse.swt.graphics.Point(Math.max(this.panel.getPreferredSize().width, canvas.getParent().getClientArea().width), Math.min(canvas.getParent().getClientArea().height, this.panel.getPreferredSize().height));
        if (!label.equals((Object)point)) {
            canvas.setSize(point);
        }
        MenuManager menuManager = new MenuManager("#PopupMenu");
        this.fillRightClickMenu(menuManager);
        this.rCMenu = menuManager.createContextMenu((Control)canvas);
        canvas.setMenu(this.rCMenu);
        this.rCMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent menuEvent) {
            }

            public void menuShown(MenuEvent menuEvent) {
                BarDrawing.this.onlyShowAction.setEnabled(BarDrawing.this.mouseInARectangle);
            }
        });
        this.alreadyInDrawMethod = false;
    }

    private void addShapes(int n, Rectangle rectangle) {
        int n2;
        Object object;
        int n3;
        this.columnButtons = new BarButton[n];
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = rectangle.height - 30;
        for (int i = 0; i < n; ++i) {
            n3 = 1;
            object = this.whatToDisplay.get(i);
            if (n3 == 0) continue;
            ++n6;
            n2 = ((IMember)object).getSize();
            if (n2 <= n5) continue;
            n5 = n2;
        }
        if (!this.limit_mode) {
            n6 = n;
        }
        if (n6 * (this.minBarWidth + this.spacing) > rectangle.width - 10) {
            n4 = this.minBarWidth;
            bl = true;
        } else {
            n4 = n6 * (this.maxBarWidth + this.spacing) < rectangle.width - 10 ? this.maxBarWidth : (int)((float)rectangle.width - 10.0f) / n6 - this.spacing;
        }
        if (bl) {
            n7 -= 20;
        }
        this.scale = (float)n7 / (float)n5;
        if (this.scale > (float)this.highlightDepth) {
            this.scale = (float)Math.floor(this.scale);
        }
        BarButton barButton = null;
        for (n3 = 0; n3 < n; ++n3) {
            object = (IMember)this.whatToDisplay.get(n3);
            this.rectangles[n3] = new RectangleFigure();
            this.rectangleTable.put(this.rectangles[n3], new RectangleData((IMember)object, null, null));
            this.rectangles[n3].addMouseListener(this.mouseListener);
            this.rectangles[n3].addMouseMotionListener(this.locationListener);
            this.lineNums[n3] = new Vector();
            n2 = (int)((float)object.getSize().intValue() * this.scale + 0.5f) + 20;
            this.rectangles[n3].setSize(n4, n2);
            this.rectangles[n3].setToolTip((IFigure)new Label(object.getToolTip()));
            this.columnButtons[n3] = this.createButton(object.getName(), this.rectangles[n3].getSize().width);
            if (barButton != null) {
                barButton.setRightComponent((Figure)this.columnButtons[n3]);
                this.columnButtons[n3].setLeftComponent((Figure)barButton);
            }
            barButton = this.columnButtons[n3];
            this.rectangles[n3].add((IFigure)this.columnButtons[n3]);
            this.rectangles[n3].setBackgroundColor(ColorConstants.buttonDarkest);
            IMarkupProvider iMarkupProvider = Visualiser.markupP;
            if (this.whatToDisplay.get(n3) instanceof IGroup && this.demarcation) {
                IGroup iGroup = (IGroup)this.whatToDisplay.get(n3);
                List list = iGroup.getMembers();
                IMember[] iMemberArray = new IMember[list.size()];
                float f = 20.0f;
                list.toArray(iMemberArray);
                for (int i = 0; i < iMemberArray.length; ++i) {
                    IMember iMember = iMemberArray[i];
                    RectangleFigure rectangleFigure = new RectangleFigure();
                    rectangleFigure.addMouseListener(this.mouseListener);
                    rectangleFigure.addMouseMotionListener(this.locationListener);
                    this.rectangleTable.put(rectangleFigure, new RectangleData(iMember, null, null));
                    float f2 = (float)iMember.getSize().intValue() * this.scale + 1.5f;
                    if (i == iMemberArray.length - 1) {
                        f2 = (float)this.rectangles[n3].getSize().height - f;
                    }
                    rectangleFigure.setSize(n4, (int)f2);
                    rectangleFigure.setLocation(new Point(0, (int)f));
                    rectangleFigure.setToolTip((IFigure)new Label(iMember.getToolTip()));
                    f += (float)((int)(f2 - 1.0f));
                    rectangleFigure.setBackgroundColor(ColorConstants.buttonDarkest);
                    this.rectangles[n3].add((IFigure)rectangleFigure);
                    if (!this.attachStripes(rectangleFigure, iMarkupProvider.getMemberMarkups(iMember), iMarkupProvider, n4, true, iMember, this.columnButtons[n3])) continue;
                    rectangleFigure.setBackgroundColor(ColorConstants.white);
                }
            } else if (this.whatToDisplay.get(n3) instanceof IGroup) {
                this.log(3, "Striping " + object.getFullname());
                this.attachStripes((RectangleFigure)this.rectangles[n3], iMarkupProvider.getGroupMarkups((IGroup)object), iMarkupProvider, n4, false, (IMember)object, this.columnButtons[n3]);
            } else {
                this.log(3, "Striping " + object.getFullname());
                this.attachStripes((RectangleFigure)this.rectangles[n3], iMarkupProvider.getMemberMarkups((IMember)object), iMarkupProvider, n4, false, (IMember)object, this.columnButtons[n3]);
            }
            if (this.limit_mode) {
                if (this.rectangles[n3].getBackgroundColor() != ColorConstants.white) continue;
                this.panel.add((IFigure)this.rectangles[n3]);
                continue;
            }
            this.panel.add((IFigure)this.rectangles[n3]);
        }
    }

    private void addShapesAndKeepProportions(int n, Rectangle rectangle, Rectangle rectangle2) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            IMember iMember = (IMember)this.whatToDisplay.get(n2);
            if (iMember.getSize() <= n3) continue;
            n3 = iMember.getSize();
        }
        n2 = n3 * this.highlightDepth + 20;
        int n4 = n2 + 30;
        if (rectangle.height < n4) {
            rectangle.height = n4;
        }
        int n5 = n * (this.minBarWidth + this.spacing);
        int n6 = n5 * rectangle.height;
        boolean bl = true;
        if (n6 > 5078745) {
            String string = "Absolute proportions view would consume too much area";
            String string2 = "If the visualise attempts to render your chosen resources in absolute proportions mode, you are likely to see a NoMoreHandles exception from SWT.  Do you want to continue?  (As a workaround, you could try reducing the stripe height in the visualiser configuration and trying again)";
            bl = MessageDialog.openQuestion((Shell)canvas.getParent().getShell(), (String)string, (String)string2);
        }
        if (bl) {
            this.continueWithAbsoluteProportions = true;
            this.addShapes(n, rectangle);
        } else {
            this.continueWithAbsoluteProportions = false;
            this.absolute_proportions = false;
            VisualiserPlugin.visualiser.resetAbsoluteProportions();
            this.addShapes(n, rectangle2);
        }
    }

    private boolean attachStripes(RectangleFigure rectangleFigure, List list, IMarkupProvider iMarkupProvider, int n, boolean bl, IMember iMember, Button button) {
        Stripe stripe = null;
        boolean bl2 = false;
        int n2 = 0;
        if (list != null && list.size() > 0) {
            TreeSet<Stripe> treeSet = new TreeSet<Stripe>();
            for (int i = 0; i < list.size(); ++i) {
                stripe = (Stripe)list.get(i);
                if (stripe == null) continue;
                treeSet.add(stripe);
            }
            ArrayList<TraversableRectangleFigure> arrayList = null;
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                TraversableRectangleFigure traversableRectangleFigure;
                int n3;
                int n4;
                ++n2;
                stripe = (Stripe)iterator.next();
                int n5 = 0;
                for (n4 = 0; n4 < stripe.getKinds().size(); ++n4) {
                    if (VisualiserPlugin.menu == null) {
                        ++n5;
                        continue;
                    }
                    if (!VisualiserPlugin.menu.getActive((String)stripe.getKinds().get(n4))) continue;
                    ++n5;
                }
                n4 = 0;
                TraversableRectangleFigure traversableRectangleFigure2 = null;
                ArrayList<TraversableRectangleFigure> arrayList2 = new ArrayList<TraversableRectangleFigure>();
                for (n3 = 0; n3 < stripe.getKinds().size(); ++n3) {
                    if (VisualiserPlugin.menu != null && !VisualiserPlugin.menu.getActive((String)stripe.getKinds().get(n3))) continue;
                    bl2 = true;
                    traversableRectangleFigure = new TraversableRectangleFigure(this.rectangleTable);
                    if (traversableRectangleFigure2 != null) {
                        traversableRectangleFigure.setLeftComponent((Figure)traversableRectangleFigure2);
                        traversableRectangleFigure2.setRightComponent((Figure)traversableRectangleFigure);
                    }
                    traversableRectangleFigure2 = traversableRectangleFigure;
                    arrayList2.add(traversableRectangleFigure);
                    this.rectangleTable.put(traversableRectangleFigure, new RectangleData(iMember, stripe, (String)stripe.getKinds().get(n3)));
                    this.addStripe((Figure)traversableRectangleFigure, rectangleFigure, stripe, n, n4++, n5, bl, iMarkupProvider, n3);
                }
                if (arrayList2.size() <= 0) continue;
                if (arrayList != null) {
                    TraversableRectangleFigure traversableRectangleFigure3;
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        traversableRectangleFigure = (TraversableRectangleFigure)((Object)arrayList.get(n3));
                        traversableRectangleFigure3 = (TraversableRectangleFigure)((Object)arrayList2.get(n3 * arrayList2.size() / arrayList.size()));
                        traversableRectangleFigure.setDownComponent((Figure)traversableRectangleFigure3);
                    }
                    for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                        traversableRectangleFigure = (TraversableRectangleFigure)((Object)arrayList2.get(n3));
                        traversableRectangleFigure3 = (TraversableRectangleFigure)((Object)arrayList.get(n3 * arrayList.size() / arrayList2.size()));
                        traversableRectangleFigure.setUpComponent((Figure)traversableRectangleFigure3);
                    }
                } else {
                    for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                        traversableRectangleFigure = (TraversableRectangleFigure)((Object)arrayList2.get(n3));
                        traversableRectangleFigure.setUpComponent((Figure)button);
                        if (n3 != 0 || !(button instanceof BarButton)) continue;
                        ((BarButton)button).setDownComponent((Figure)traversableRectangleFigure);
                    }
                }
                arrayList = arrayList2;
            }
        }
        return bl2;
    }

    private void addStripe(Figure figure, RectangleFigure rectangleFigure, Stripe stripe, int n, int n2, int n3, boolean bl, IMarkupProvider iMarkupProvider, int n4) {
        int n5;
        if (rectangleFigure.getBackgroundColor() != ColorConstants.white) {
            rectangleFigure.setBackgroundColor(ColorConstants.white);
        }
        if ((n5 = stripe.getOffset() - 1) < 0) {
            n5 = 0;
        }
        int n6 = stripe.getDepth();
        this.log(3, "Adding stripe to resource " + n5 + " depth " + n6);
        float f = 1.5f + ((float)n - 1.0f) / (float)n3 * (float)n2;
        float f2 = (float)n5 * this.scale;
        if (bl) {
            Point point = rectangleFigure.getLocation();
            f2 += (float)point.y;
        } else {
            f2 += 20.0f;
        }
        if (n5 == 0) {
            f2 += 1.0f;
        }
        figure.setLocation(new Point((double)f, (double)f2));
        int n7 = 0;
        n7 = n6 == 1 ? (int)Math.max((double)this.highlightDepth, Math.floor(this.scale)) : (int)(Math.max((float)this.highlightDepth, this.scale) * (float)n6);
        int n8 = (int)((float)((n - 2) / n3) + 1.5f);
        int n9 = rectangleFigure.getBounds().width;
        int n10 = rectangleFigure.getLocation().y + rectangleFigure.getBounds().height;
        while (f2 + (float)n7 >= (float)n10) {
            --n7;
        }
        while (f + (float)n8 >= (float)n9) {
            --n8;
        }
        if (n7 > 0) {
            figure.setSize(n8, n7);
            figure.setBackgroundColor(iMarkupProvider.getColorFor((String)stripe.getKinds().get(n4)));
            figure.addMouseListener(this.mouseListener);
            figure.setToolTip((IFigure)new Label(" " + stripe.getKinds().get(n4) + " "));
            rectangleFigure.add((IFigure)figure);
        }
    }

    private void clearPanel() {
        List list = this.panel.getChildren();
        if (list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                IFigure iFigure = (IFigure)list.get(n);
                this.panel.remove(iFigure);
                iFigure.erase();
            }
        }
    }

    private void setAbsoluteProportions(boolean bl) {
        this.absolute_proportions = bl;
        if (bl) {
            this.zoom = 1.0f;
        }
    }

    public boolean zoomIn(Canvas canvas) {
        if (this.zoom + 0.5f <= this.max_zoom) {
            this.zoom += 0.5f;
            this.draw(this.whatToDisplay, canvas, this.absolute_proportions);
        }
        return this.zoom + 0.5f <= this.max_zoom;
    }

    public boolean zoomOut(Canvas canvas) {
        this.zoom = this.zoom - 0.5f <= 1.0f ? 1.0f : (this.zoom -= 0.5f);
        this.draw(this.whatToDisplay, canvas, this.absolute_proportions);
        return this.zoom > 1.0f;
    }

    protected List getDisplayedData() {
        return this.whatToDisplay;
    }

    public void setDemarcation(boolean bl, Canvas canvas) {
        if (this.demarcation != bl) {
            this.demarcation = bl;
            this.draw(this.whatToDisplay, canvas, this.absolute_proportions);
        }
    }

    public BarButton createButton(String string, int n) {
        BarButton barButton = new BarButton(string);
        barButton.setBackgroundColor(ColorConstants.buttonDarker);
        barButton.setSize(n, 20);
        barButton.setStyle(Clickable.STYLE_TOGGLE);
        return barButton;
    }

    private void log(int n, String string) {
        if (n <= LOGLEVEL) {
            System.err.println(string);
        }
    }
}

