/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class Menu
extends ViewPart {
    private IAction selectNoneAction;
    private IAction selectAllAction;
    private static String markerTypes = "cmesearchmarker";
    Button[] buttons;
    Button[] checkboxes;
    Label[] labels;
    Shell[] shells;
    ColorDialog[] colorDialogs;
    Image[] images;
    Color[] colors;
    SelectionAdapter selectionListener;
    MouseListener mouseListener;
    Composite canvas;
    ScrolledComposite scrollpane;
    GridLayout layout = new GridLayout(3, false);
    VisualiserPlugin plugin = VisualiserPlugin.getDefault();
    private static IMarkupProvider vmp;
    private static Hashtable kindActive;
    private boolean uptodate = false;
    private static Action groupByRel_Action;
    private static Action groupByQuery_Action;
    private static Action psychedelic_Action;

    public Menu() {
        this.plugin.setMenu(this);
        this.reset();
    }

    public void setVisMarkupProvider(IMarkupProvider iMarkupProvider) {
        vmp = iMarkupProvider;
    }

    private void drawImage(Image image, Color color) {
        GC gC = new GC((Drawable)image);
        gC.setBackground(color);
        Rectangle rectangle = image.getBounds();
        gC.fillRectangle(0, 0, rectangle.width, rectangle.height);
        gC.drawRectangle(0, 0, rectangle.width - 1, rectangle.height - 1);
        gC.dispose();
    }

    public void createPartControl(Composite composite) {
        this.reset();
        this.scrollpane = new ScrolledComposite(composite, 2816);
        this.canvas = new Composite((Composite)this.scrollpane, 0);
        this.scrollpane.setContent((Control)this.canvas);
        this.canvas.setLayout((Layout)this.layout);
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.getSource() instanceof Button) {
                    Button button = (Button)selectionEvent.getSource();
                    int n = 0;
                    for (int i = 0; i < Menu.this.buttons.length; ++i) {
                        if (!Menu.this.buttons[i].equals(button)) continue;
                        n = i;
                    }
                    RGB rGB = Menu.this.colorDialogs[n].open();
                    if (rGB == null) {
                        return;
                    }
                    Menu.this.colors[n] = new Color((Device)Menu.this.buttons[n].getDisplay(), rGB);
                    Image image = Menu.this.buttons[n].getImage();
                    Menu.this.drawImage(image, Menu.this.colors[n]);
                    Menu.this.buttons[n].setImage(image);
                    if (VisualiserPlugin.visualiser != null) {
                        vmp.setColorFor(Menu.this.labels[n].getText(), Menu.this.colors[n]);
                        VisualiserPlugin.visualiser.draw();
                    }
                }
            }
        };
        this.mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (VisualiserPlugin.visualiser != null) {
                    for (int i = 0; i < Menu.this.colors.length; ++i) {
                        kindActive.put((String)Menu.this.labels[i].getData(), new Boolean(Menu.this.checkboxes[i].getSelection()));
                    }
                    VisualiserPlugin.visualiser.updateDisplay(false);
                }
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }
        };
        this.makePullDownActions();
        this.contributeToActionBars();
    }

    private void makePullDownActions() {
        this.selectAllAction = new Action(){

            public int getStyle() {
                return 1;
            }

            public void run() {
                Menu.this.showAll();
            }
        };
        this.selectAllAction.setText(VisualiserPlugin.getResourceString("Select_All_20"));
        this.selectAllAction.setToolTipText(VisualiserPlugin.getResourceString("Select_All_20"));
        this.selectNoneAction = new Action(){

            public int getStyle() {
                return 1;
            }

            public void run() {
                Menu.this.showNone();
            }
        };
        this.selectNoneAction.setText(VisualiserPlugin.getResourceString("Select_None_21"));
        this.selectNoneAction.setToolTipText(VisualiserPlugin.getResourceString("Select_None_21"));
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add(this.selectAllAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add(this.selectNoneAction);
    }

    private void showAll() {
        if (this.checkboxes != null) {
            for (int i = 0; i < this.checkboxes.length; ++i) {
                this.checkboxes[i].setSelection(true);
                kindActive.put((String)this.labels[i].getData(), new Boolean(this.checkboxes[i].getSelection()));
            }
            VisualiserPlugin.visualiser.draw();
        }
    }

    private void showNone() {
        if (this.checkboxes != null) {
            for (int i = 0; i < this.checkboxes.length; ++i) {
                this.checkboxes[i].setSelection(false);
                kindActive.put((String)this.labels[i].getData(), new Boolean(false));
            }
            VisualiserPlugin.visualiser.draw();
        }
    }

    protected void onlyShow(List list) {
        if (list == null) {
            this.showNone();
        } else if (list.size() == 0) {
            this.showNone();
        } else if (list.size() == this.checkboxes.length) {
            this.showAll();
        } else {
            for (int i = 0; i < this.labels.length; ++i) {
                if (list.contains(this.labels[i].getText())) {
                    this.checkboxes[i].setSelection(true);
                    kindActive.put((String)this.labels[i].getData(), new Boolean(true));
                    continue;
                }
                this.checkboxes[i].setSelection(false);
                kindActive.put((String)this.labels[i].getData(), new Boolean(false));
            }
            VisualiserPlugin.visualiser.draw();
        }
    }

    public boolean getActive(String string) {
        if (kindActive == null) {
            return false;
        }
        if (kindActive.get(string) == null) {
            return false;
        }
        return (Boolean)kindActive.get(string);
    }

    public void reset() {
        this.uptodate = false;
    }

    public void ensureUptodate() {
        if (this.uptodate) {
            return;
        }
        this.clear();
        SortedSet sortedSet = vmp.getAllMarkupKinds();
        if (sortedSet == null) {
            return;
        }
        this.buttons = new Button[sortedSet.size()];
        this.checkboxes = new Button[sortedSet.size()];
        this.labels = new Label[sortedSet.size()];
        this.shells = new Shell[sortedSet.size()];
        this.images = new Image[sortedSet.size()];
        this.colorDialogs = new ColorDialog[sortedSet.size()];
        this.colors = new Color[sortedSet.size()];
        kindActive = new Hashtable();
        int n = 0;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = 12;
            this.colors[n] = vmp.getColorFor(string);
            this.buttons[n] = new Button(this.canvas, 8);
            this.shells[n] = this.buttons[n].getShell();
            this.colorDialogs[n] = new ColorDialog(this.shells[n]);
            Display display = this.shells[n].getDisplay();
            this.images[n] = new Image((Device)display, n2, n2);
            this.buttons[n].setImage(this.images[n]);
            this.buttons[n].addSelectionListener((SelectionListener)this.selectionListener);
            Image image = this.buttons[n].getImage();
            this.drawImage(image, this.colors[n]);
            this.buttons[n].setImage(image);
            this.checkboxes[n] = new Button(this.canvas, 32);
            this.checkboxes[n].addMouseListener(this.mouseListener);
            this.checkboxes[n].setSelection(true);
            this.labels[n] = new Label(this.canvas, 0);
            this.labels[n].setText(string);
            this.labels[n].setData((Object)string);
            kindActive.put(string, new Boolean(true));
            ++n;
        }
        this.canvas.layout();
        this.canvas.setSize(this.canvas.computeSize(-1, -1, true));
        this.uptodate = true;
    }

    private void clear() {
        Control[] controlArray;
        if (this.canvas != null && (controlArray = this.canvas.getChildren()).length > 0) {
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].dispose();
            }
        }
    }

    public void setFocus() {
        if (this.scrollpane != null) {
            this.scrollpane.setFocus();
        }
    }

    public void dispose() {
        this.plugin.removeMenu();
    }

    private void makeActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        Action action = new Action(){

            public void run() {
                Menu.this.markerTypesDialog();
            }
        };
        action.setText("Markers...");
        action.setToolTipText("Choose displayed markers");
        iMenuManager.add((IAction)action);
        groupByRel_Action = new Action(){

            public void run() {
                if (this.isChecked()) {
                    groupByQuery_Action.setChecked(false);
                    psychedelic_Action.setChecked(false);
                }
                VisualiserPlugin.visualiser.updateDisplay(false);
            }
        };
        groupByRel_Action.setText("Group by relationship");
        groupByRel_Action.setChecked(true);
        groupByRel_Action.setToolTipText("Have one color per relationship type");
        iMenuManager.add((IAction)groupByRel_Action);
        groupByQuery_Action = new Action(){

            public void run() {
                if (this.isChecked()) {
                    groupByRel_Action.setChecked(false);
                    psychedelic_Action.setChecked(false);
                }
                VisualiserPlugin.visualiser.updateDisplay(false);
            }
        };
        groupByQuery_Action.setText("Group by query");
        groupByQuery_Action.setChecked(false);
        groupByQuery_Action.setToolTipText("Have one color per query");
        iMenuManager.add((IAction)groupByQuery_Action);
        psychedelic_Action = new Action(){

            public void run() {
                if (this.isChecked()) {
                    groupByRel_Action.setChecked(false);
                    groupByQuery_Action.setChecked(false);
                }
                VisualiserPlugin.visualiser.updateDisplay(false);
            }
        };
        psychedelic_Action.setText("Psychedelic");
        psychedelic_Action.setChecked(false);
        psychedelic_Action.setToolTipText("Press it, you know you want to...");
        iMenuManager.add((IAction)psychedelic_Action);
    }

    public static boolean isPsychedelic() {
        return psychedelic_Action.isChecked();
    }

    public static boolean isColorPerRelationship() {
        return groupByRel_Action.isChecked();
    }

    public static boolean isColorPerQuery() {
        return groupByQuery_Action.isChecked();
    }

    public static String getMarkersToDisplay() {
        return markerTypes;
    }

    private void markerTypesDialog() {
        InputDialog inputDialog = new InputDialog(this.getSite().getShell(), "Displayed Markers", "Comma separated list of marker types (e.g. 'cmesearchmarker')", markerTypes, null);
        inputDialog.open();
        if (inputDialog.getReturnCode() == 0) {
            markerTypes = inputDialog.getValue();
            VisualiserPlugin.visualiser.updateDisplay(false);
        }
    }

    static {
        kindActive = null;
    }
}

