/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.Hashtable;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.views.BarDrawing;
import org.eclipse.contribution.visualiser.views.RectangleData;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.swt.graphics.Point;

public class TraversableRectangleFigure
extends RectangleFigure {
    private Hashtable rectangleTable;
    private Figure upComponent;
    private Figure downComponent;
    private Figure leftComponent;
    private Figure rightComponent;
    private ToolTipHelper helper;

    public TraversableRectangleFigure(Hashtable hashtable) {
        this.rectangleTable = hashtable;
        this.setForegroundColor(ColorConstants.black);
        this.addKeyListener(new KeyHandler());
        this.setFocusTraversable(true);
        this.setRequestFocusEnabled(true);
        this.setOutline(false);
    }

    public void handleFocusGained(FocusEvent focusEvent) {
        super.handleFocusGained(focusEvent);
        this.setOutline(true);
        this.repaint();
    }

    public void handleFocusLost(FocusEvent focusEvent) {
        super.handleFocusLost(focusEvent);
        this.setOutline(false);
        this.removeToolTip();
        this.repaint();
    }

    public boolean isToolTipShowing() {
        return this.helper != null && this.helper.isShowing();
    }

    public void showToolTip() {
        if (this.helper != null && this.helper.isShowing()) {
            this.removeToolTip();
        }
        Point point = BarDrawing.canvas.toDisplay(new Point(this.getLocation().x, this.getLocation().y));
        this.helper = new ToolTipHelper(BarDrawing.canvas);
        this.helper.displayToolTipNear((IFigure)this, this.getToolTip(), point.x, point.y);
    }

    private void removeToolTip() {
        if (this.helper != null) {
            this.helper.dispose();
            this.helper = null;
        }
    }

    public Figure getUpComponent() {
        return this.upComponent;
    }

    public void setUpComponent(Figure figure) {
        this.upComponent = figure;
    }

    public Figure getDownComponent() {
        return this.downComponent;
    }

    public void setDownComponent(Figure figure) {
        this.downComponent = figure;
    }

    public Figure getLeftComponent() {
        return this.leftComponent;
    }

    public void setLeftComponent(Figure figure) {
        this.leftComponent = figure;
    }

    public Figure getRightComponent() {
        return this.rightComponent;
    }

    public void setRightComponent(Figure figure) {
        this.rightComponent = figure;
    }

    class KeyHandler
    implements KeyListener {
        KeyHandler() {
        }

        private void traverseToFigure(TraversableRectangleFigure traversableRectangleFigure, Figure figure) {
            if (figure instanceof TraversableRectangleFigure) {
                TraversableRectangleFigure traversableRectangleFigure2 = (TraversableRectangleFigure)figure;
                if (traversableRectangleFigure.isToolTipShowing()) {
                    traversableRectangleFigure2.showToolTip();
                }
            }
            figure.requestFocus();
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = keyEvent.getSource();
            if (!(object instanceof TraversableRectangleFigure)) {
                return;
            }
            TraversableRectangleFigure traversableRectangleFigure = (TraversableRectangleFigure)((Object)object);
            if (keyEvent.character == ' ') {
                RectangleFigure rectangleFigure = (RectangleFigure)keyEvent.getSource();
                RectangleData rectangleData = (RectangleData)traversableRectangleFigure.rectangleTable.get(rectangleFigure);
                VisualiserPlugin.visualiser.handleClick(rectangleData.mem, rectangleData.kind, rectangleData.stripe, 1);
            } else if (keyEvent.keycode == 0x1000001) {
                if (traversableRectangleFigure.getUpComponent() != null) {
                    this.traverseToFigure(traversableRectangleFigure, traversableRectangleFigure.getUpComponent());
                }
            } else if (keyEvent.keycode == 0x1000002) {
                if (traversableRectangleFigure.getDownComponent() != null) {
                    this.traverseToFigure(traversableRectangleFigure, traversableRectangleFigure.getDownComponent());
                }
            } else if (keyEvent.keycode == 0x1000003) {
                if (traversableRectangleFigure.leftComponent != null) {
                    this.traverseToFigure(traversableRectangleFigure, traversableRectangleFigure.getLeftComponent());
                }
            } else if (keyEvent.keycode == 0x1000004) {
                if (traversableRectangleFigure.rightComponent != null) {
                    this.traverseToFigure(traversableRectangleFigure, traversableRectangleFigure.getRightComponent());
                }
            } else if (keyEvent.keycode == 0x100000B) {
                traversableRectangleFigure.showToolTip();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

