/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.core.resources.VisualiserImages;
import org.eclipse.contribution.visualiser.interfaces.IContentProvider;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferencesDialog;
import org.eclipse.contribution.visualiser.views.BarDrawing;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class Visualiser
extends ViewPart {
    private Action lockAction;
    private static VisualiserPlugin plugin = VisualiserPlugin.getDefault();
    private static BarDrawing barDrawing = BarDrawing.getBarDrawing();
    private static Action groupViewAction;
    private static Action memberViewAction;
    private Action absoluteProportionsAction;
    private Action doubleClickAction;
    private Action limitAction;
    private Action zoomInAction;
    private Action zoomOutAction;
    private Action changeStripeModeAction;
    private Action preferencesAction;
    private static ImageDescriptor groupViewImage;
    private static ImageDescriptor memberViewImage;
    public boolean justOpenedFile = false;
    private static int viewMode;
    private static final int VIEWMODE_GROUPS = 0;
    private static final int VIEWMODE_GROUP = 1;
    private static final int VIEWMODE_MEMBERS = 2;
    protected static IContentProvider contentP;
    protected static IMarkupProvider markupP;
    private static List data;
    private static boolean inGroupView;
    private static boolean inLimitMode;
    private static boolean absoluteProportions;
    private static boolean locked;
    private static Canvas canvas;
    private static ScrolledComposite container;
    private Vector selectedElements;
    private Vector annotations;
    private Color[] colors;
    private Rectangle viewsize;
    private static Point containerSize;
    private static Stack context;

    public Visualiser() {
        plugin.setVisualiser(this);
        this.updateSettingsFromPreferences();
    }

    public void createPartControl(Composite composite) {
        try {
            this.getSite().getPage().showView("org.eclipse.contribution.visualiser.views.Menu");
        }
        catch (PartInitException partInitException) {
            System.err.println("Error initialising Visualiser Menu");
        }
        container = new ScrolledComposite(composite, 768);
        container.setAlwaysShowScrollBars(false);
        container.setLayoutData((Object)new GridData(1808));
        containerSize = container.getSize();
        canvas = new Canvas((Composite)container, 0);
        canvas.setLayoutData((Object)new GridData(1808));
        container.setContent((Control)canvas);
        this.selectedElements = new Vector();
        this.annotations = new Vector();
        this.makeActions();
        memberViewAction.setChecked(true);
        this.zoomOutAction.setEnabled(false);
        this.contributeToActionBars();
        container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Visualiser.updateVisUI();
            }
        });
        String string = ProviderManager.getCurrent().getTitle();
        this.refreshTitle(string);
        data = contentP.getAllMembers();
        this.updateDisplay(true);
    }

    public void draw() {
        Visualiser.updateVisUI();
    }

    public void updateSettingsFromPreferences() {
        this.setDemarcation(VisualiserPreferences.isDemarcationEnabled());
        this.setMinStripeSize(VisualiserPreferences.getStripeSize());
        this.setMaxBarSize(VisualiserPreferences.getMaxBarSize());
        this.setMinBarSize(VisualiserPreferences.getMinBarSize());
    }

    public void refreshTitle(String string) {
        this.setContentDescription(VisualiserPlugin.getResourceString("Visualiser") + " - " + string);
    }

    public void setDemarcation(boolean bl) {
        barDrawing.setDemarcation(bl, canvas);
    }

    public void setMinStripeSize(int n) {
        Visualiser.barDrawing.highlightDepth = n;
        if (canvas != null) {
            this.draw();
        }
    }

    public void setMaxBarSize(int n) {
        Visualiser.barDrawing.maxBarWidth = n;
        this.draw();
    }

    public void setMinBarSize(int n) {
        Visualiser.barDrawing.minBarWidth = n;
        this.draw();
    }

    public void updateDisplay(boolean bl) {
        Visualiser.log(3, "Entering updateDisplay");
        if (!locked) {
            if (inGroupView) {
                if (viewMode == 1) {
                    data = contentP.getAllGroups();
                } else if (viewMode == 0) {
                    data = contentP.getAllGroups();
                } else if (viewMode == 2) {
                    data = contentP.getAllGroups();
                }
            } else if (!inGroupView) {
                if (viewMode == 1) {
                    data = contentP.getAllMembers();
                } else if (viewMode == 0) {
                    data = contentP.getAllMembers();
                } else if (viewMode == 2) {
                    data = contentP.getAllMembers();
                }
            }
        }
        if (VisualiserPlugin.menu != null && bl) {
            VisualiserPlugin.menu.reset();
            VisualiserPlugin.menu.ensureUptodate();
        }
        Visualiser.updateVisUI();
    }

    private static List limitData(List list) {
        if (list == null) {
            return null;
        }
        Visualiser.log(3, "In limit processing: Input size: " + list.size());
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2;
            IMember iMember;
            Object e = iterator.next();
            if (e instanceof IGroup) {
                iMember = (IGroup)e;
                list2 = markupP.getGroupMarkups((IGroup)iMember);
                if (!Visualiser.containsActiveStripe(list2)) continue;
                arrayList.add(e);
                continue;
            }
            iMember = (IMember)e;
            list2 = markupP.getMemberMarkups(iMember);
            if (!Visualiser.containsActiveStripe(list2)) continue;
            arrayList.add(e);
        }
        Visualiser.log(3, "Finished limit processing: Output size: " + arrayList.size());
        return arrayList;
    }

    private static boolean containsActiveStripe(List list) {
        if (list == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Stripe stripe = (Stripe)iterator.next();
            List list2 = stripe.getKinds();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (VisualiserPlugin.menu == null) {
                    return true;
                }
                if (!VisualiserPlugin.menu.getActive(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static void updateVisUI() {
        if (inLimitMode) {
            barDrawing.draw(Visualiser.limitData(data), canvas, absoluteProportions);
        } else {
            barDrawing.draw(data, canvas, absoluteProportions);
        }
    }

    private static void log(int n, String string) {
        if (n <= VisualiserPlugin.LOGLEVEL) {
            System.err.println(string);
        }
    }

    private IMarker getMarker(int n) {
        IResource iResource;
        IMarker iMarker = null;
        if (this.selectedElements.elementAt(n) instanceof IResource && (iResource = (IResource)this.selectedElements.elementAt(n)) != null) {
            try {
                iMarker = iResource.createMarker("org.eclipse.core.resources.marker");
            }
            catch (CoreException coreException) {
                System.err.println((Object)coreException);
            }
        }
        return iMarker;
    }

    private IMarker getMarker(int n, int n2) {
        IResource iResource;
        IMarker iMarker = null;
        if (this.selectedElements.elementAt(n) instanceof IResource && (iResource = (IResource)this.selectedElements.elementAt(n)) != null) {
            try {
                iMarker = iResource.createMarker("org.eclipse.core.resources.marker");
                iMarker.setAttribute("lineNumber", n2);
            }
            catch (CoreException coreException) {
                System.err.println((Object)coreException);
            }
        }
        return iMarker;
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        boolean bl = false;
        if (markupP != null) {
            bl = markupP.hasMultipleModes();
        }
        this.fillLocalToolBar(iActionBars.getToolBarManager(), bl);
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.preferencesAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.limitAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)groupViewAction);
        iMenuManager.add((IAction)memberViewAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager, boolean bl) {
        iToolBarManager.add((IAction)this.zoomInAction);
        iToolBarManager.add((IAction)this.zoomOutAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.lockAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.absoluteProportionsAction);
        iToolBarManager.add((IContributionItem)new Separator());
        if (bl) {
            iToolBarManager.add((IAction)this.changeStripeModeAction);
            iToolBarManager.add((IContributionItem)new Separator());
        }
        iToolBarManager.add((IAction)this.limitAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)groupViewAction);
        iToolBarManager.add((IAction)memberViewAction);
    }

    private void makeActions() {
        this.makeActionPreferences();
        this.makeActionChangeStripeMode();
        this.makeActionZoomin();
        this.makeActionZoomout();
        this.makeActionLimitvis();
        this.makeActionGroupView();
        this.makeActionMemberView();
        this.makeActionAbsoluteProportions();
        this.makeActionLock();
    }

    private void makeActionPreferences() {
        this.preferencesAction = new Action(){

            public void run() {
                VisualiserPreferencesDialog visualiserPreferencesDialog = new VisualiserPreferencesDialog(new Shell());
                visualiserPreferencesDialog.create();
                visualiserPreferencesDialog.open();
            }
        };
        this.preferencesAction.setText(VisualiserPlugin.getResourceString("Preferences_24"));
        this.preferencesAction.setToolTipText(VisualiserPlugin.getResourceString("Preferences_Tip_25"));
        this.preferencesAction.setImageDescriptor(VisualiserImages.PREFERENCES);
    }

    private void makeActionAbsoluteProportions() {
        this.absoluteProportionsAction = new Action(){

            public void run() {
                absoluteProportions = !absoluteProportions;
                Visualiser.updateVisUI();
                Visualiser.this.zoomInAction.setEnabled(!absoluteProportions);
                Visualiser.this.zoomOutAction.setEnabled(!absoluteProportions);
            }

            public int getStyle() {
                return 2;
            }
        };
        this.absoluteProportionsAction.setText(VisualiserPlugin.getResourceString("Absolute_Proportions"));
        this.absoluteProportionsAction.setToolTipText(VisualiserPlugin.getResourceString("Absolute_Proportions"));
        this.absoluteProportionsAction.setImageDescriptor(VisualiserImages.ABSOLUTE_PROPORTIONS);
    }

    private void makeActionChangeStripeMode() {
        this.changeStripeModeAction = new Action(){

            public void run() {
                if (markupP.changeMode()) {
                    Visualiser.this.updateDisplay(true);
                }
            }
        };
        this.changeStripeModeAction.setText(VisualiserPlugin.getResourceString("Change_Mode_22"));
        this.changeStripeModeAction.setToolTipText(VisualiserPlugin.getResourceString("Change_Mode_23"));
        ImageDescriptor imageDescriptor = VisualiserImages.CHANGE_STRIPE_MODE;
        this.changeStripeModeAction.setImageDescriptor(imageDescriptor);
    }

    private void makeActionMemberView() {
        memberViewAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                Visualiser.activateMemberView();
                Visualiser.this.updateDisplay(false);
            }
        };
        memberViewAction.setText(VisualiserPlugin.getResourceString("Class_View_15"));
        memberViewAction.setToolTipText(VisualiserPlugin.getResourceString("Changes_to_member_view_16"));
        memberViewAction.setImageDescriptor(memberViewImage);
    }

    private void makeActionGroupView() {
        groupViewAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (!inGroupView) {
                    this.setChecked(true);
                    memberViewAction.setChecked(false);
                    inGroupView = true;
                } else {
                    this.setChecked(true);
                }
                Visualiser.activateGroupView();
                Visualiser.this.updateDisplay(false);
            }
        };
        groupViewAction.setText(VisualiserPlugin.getResourceString("Package_View_12"));
        groupViewAction.setToolTipText(VisualiserPlugin.getResourceString("Changes_to_group_view_13"));
        groupViewAction.setImageDescriptor(groupViewImage);
    }

    private void makeActionLimitvis() {
        this.limitAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (!inLimitMode) {
                    inLimitMode = true;
                } else {
                    inLimitMode = false;
                }
                this.setChecked(inLimitMode);
                Visualiser.this.updateDisplay(false);
            }
        };
        this.limitAction.setText(VisualiserPlugin.getResourceString("Limit_view_9"));
        this.limitAction.setToolTipText(VisualiserPlugin.getResourceString("Limits_visualisation_to_affected_bars_only_10"));
        this.limitAction.setImageDescriptor(VisualiserImages.LIMIT_MODE);
    }

    private void makeActionZoomout() {
        this.zoomOutAction = new Action(){

            public void run() {
                boolean bl = barDrawing.zoomOut(canvas);
                this.setEnabled(bl);
                Visualiser.this.zoomInAction.setEnabled(true);
            }
        };
        this.zoomOutAction.setText(VisualiserPlugin.getResourceString("Zoom_Out_6"));
        this.zoomOutAction.setToolTipText(VisualiserPlugin.getResourceString("Zooms_out_7"));
        this.zoomOutAction.setImageDescriptor(VisualiserImages.ZOOM_OUT);
    }

    private void makeActionZoomin() {
        this.zoomInAction = new Action(){

            public void run() {
                Visualiser.this.zoomOutAction.setEnabled(true);
                boolean bl = barDrawing.zoomIn(canvas);
                this.setEnabled(bl);
            }
        };
        this.zoomInAction.setText(VisualiserPlugin.getResourceString("Zoom_In_3"));
        this.zoomInAction.setToolTipText(VisualiserPlugin.getResourceString("Zooms_in_on_visualisation_4"));
        this.zoomInAction.setImageDescriptor(VisualiserImages.ZOOM_IN);
    }

    private void makeActionLock() {
        this.lockAction = new Action(){

            public void run() {
                locked = !locked;
                groupViewAction.setEnabled(!locked);
                memberViewAction.setEnabled(!locked);
                if (!locked) {
                    Visualiser.this.updateDisplay(true);
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this.lockAction.setText(VisualiserPlugin.getResourceString("Lock"));
        this.lockAction.setToolTipText(VisualiserPlugin.getResourceString("Lock_Tooltip"));
        this.lockAction.setImageDescriptor(VisualiserImages.LOCK);
    }

    public void setFocus() {
        if (container != null) {
            container.setFocus();
        }
    }

    public void dispose() {
        plugin.removeVisualiser();
        canvas = null;
    }

    public void setVisContentProvider(IContentProvider iContentProvider) {
        contentP = iContentProvider;
        memberViewImage = iContentProvider.getMemberViewIcon() == null ? VisualiserImages.MEMBER_VIEW : iContentProvider.getMemberViewIcon();
        ImageDescriptor imageDescriptor = groupViewImage = iContentProvider.getGroupViewIcon() == null ? VisualiserImages.GROUP_VIEW : iContentProvider.getGroupViewIcon();
        if (groupViewAction != null) {
            groupViewAction.setImageDescriptor(groupViewImage);
        }
        if (memberViewAction != null) {
            memberViewAction.setImageDescriptor(memberViewImage);
        }
    }

    public void setVisMarkupProvider(IMarkupProvider iMarkupProvider) {
        markupP = iMarkupProvider;
        if (markupP.hasMultipleModes()) {
            if (this.changeStripeModeAction == null) {
                this.makeActionChangeStripeMode();
                if (this.getViewSite() != null) {
                    IActionBars iActionBars = this.getViewSite().getActionBars();
                    iActionBars.getToolBarManager().removeAll();
                    this.fillLocalToolBar(iActionBars.getToolBarManager(), true);
                    iActionBars.updateActionBars();
                }
            }
        } else if (this.changeStripeModeAction != null) {
            IActionBars iActionBars = this.getViewSite().getActionBars();
            iActionBars.getToolBarManager().removeAll();
            this.fillLocalToolBar(iActionBars.getToolBarManager(), false);
            iActionBars.updateActionBars();
            this.changeStripeModeAction = null;
        }
    }

    private static void activateMemberView() {
        inGroupView = false;
        memberViewAction.setChecked(true);
        groupViewAction.setChecked(false);
    }

    private static void activateGroupView() {
        inGroupView = true;
        memberViewAction.setChecked(false);
        groupViewAction.setChecked(true);
    }

    protected void onlyShowColorsAffecting(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = contentP.getAllMembers();
        boolean bl = false;
        Object object8 = list.iterator();
        while (object8.hasNext()) {
            object7 = (IMember)object8.next();
            if (!object7.getToolTip().equals(string)) continue;
            bl = true;
            object6 = markupP.getMemberMarkups((IMember)object7);
            if (object6 == null) {
                VisualiserPlugin.menu.onlyShow(null);
                return;
            }
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = (Stripe)object5.next();
                object3 = ((Stripe)object4).getKinds();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (arrayList.contains(object)) continue;
                    arrayList.add(object);
                }
            }
        }
        if (!bl) {
            object8 = contentP.getAllGroups();
            object7 = object8.iterator();
            while (object7.hasNext()) {
                object6 = (IGroup)object7.next();
                if (!object6.getToolTip().equals(string)) continue;
                object5 = markupP.getGroupMarkups((IGroup)object6);
                if (object5 == null) {
                    VisualiserPlugin.menu.onlyShow(null);
                    return;
                }
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = (Stripe)object4.next();
                    object2 = ((Stripe)object3).getKinds();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        if (arrayList.contains(string2)) continue;
                        arrayList.add(string2);
                    }
                }
            }
        }
        VisualiserPlugin.menu.onlyShow(arrayList);
    }

    protected void handleClick(IMember iMember, String string, Stripe stripe, int n) {
        boolean bl = contentP.processMouseclick(iMember != null ? iMember : null, stripe != null, n);
        if (stripe != null) {
            boolean bl2 = bl = markupP.processMouseclick(iMember != null ? iMember : null, stripe, string, n) && bl;
        }
        if (bl) {
            if (n != 3) {
                Visualiser.stackContext();
                if (inGroupView) {
                    IGroup iGroup = iMember.getContainingGroup();
                    Visualiser.activateMemberView();
                }
                this.updateDisplay(false);
            } else {
                Visualiser.unstackContext();
            }
        }
    }

    private static void stackContext() {
        ViewContext viewContext = new ViewContext();
        viewContext.setGroupView(inGroupView);
        viewContext.setLimitmode(inLimitMode);
        viewContext.setData(data);
        if (context.size() == 0) {
            context.push(viewContext);
        } else if (!viewContext.equals((ViewContext)context.peek())) {
            context.push(viewContext);
        }
    }

    private static void unstackContext() {
        if (context.size() == 0) {
            return;
        }
        ViewContext viewContext = (ViewContext)context.pop();
        inGroupView = viewContext.getGroupView();
        inLimitMode = viewContext.getLimitMode();
        data = viewContext.getData();
    }

    public void resetAbsoluteProportions() {
        absoluteProportions = false;
        this.absoluteProportionsAction.setChecked(false);
        this.zoomInAction.setEnabled(true);
        this.zoomOutAction.setEnabled(true);
    }

    static {
        groupViewImage = VisualiserImages.GROUP_VIEW;
        memberViewImage = VisualiserImages.MEMBER_VIEW;
        viewMode = 0;
        data = null;
        inGroupView = false;
        inLimitMode = false;
        absoluteProportions = false;
        locked = false;
        context = new Stack();
    }

    private static class ViewContext {
        private boolean groupview;
        private boolean subselect;
        private boolean limitmode;
        private List subselection;
        private List data;

        private ViewContext() {
        }

        public boolean equals(ViewContext viewContext) {
            int n;
            if (this.groupview != viewContext.groupview) {
                return false;
            }
            if (this.limitmode != viewContext.limitmode) {
                return false;
            }
            if (this.subselection == null && viewContext.subselection != null) {
                return false;
            }
            if (viewContext.subselection == null && this.subselection != null) {
                return false;
            }
            if (this.subselection != null) {
                if (this.subselection.size() != viewContext.subselection.size()) {
                    return false;
                }
                for (n = 0; n < this.subselection.size(); ++n) {
                    if (this.subselection.get(n).equals(viewContext.subselection.get(n))) continue;
                    return false;
                }
            }
            if (this.data == null && viewContext.data != null) {
                return false;
            }
            if (viewContext.data == null && this.data != null) {
                return false;
            }
            if (this.data != null) {
                if (this.data.size() != viewContext.data.size()) {
                    return false;
                }
                for (n = 0; n < this.data.size(); ++n) {
                    if (this.data.get(n).equals(viewContext.data.get(n))) continue;
                    return false;
                }
            }
            return true;
        }

        public void setGroupView(boolean bl) {
            this.groupview = bl;
        }

        public boolean getGroupView() {
            return this.groupview;
        }

        public void setSubselect(boolean bl) {
            this.subselect = bl;
        }

        public boolean getSubselect() {
            return this.subselect;
        }

        public void setSubselection(List list) {
            this.subselection = list;
        }

        public List getSubselection() {
            return this.subselection;
        }

        public void setData(List list) {
            this.data = list;
        }

        public List getData() {
            return this.data;
        }

        public void setLimitmode(boolean bl) {
            this.limitmode = bl;
        }

        public boolean getLimitMode() {
            return inLimitMode;
        }
    }
}

